/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modellwerkstatt.manmap.runtime.IM3Entity;
import org.modellwerkstatt.manmap.runtime.MMDummyEntity;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;

public class MMObjectKeyStore<Key, Entity extends IM3Entity<Key>> {
    protected Map<Key, Entity> entityStore = new HashMap<Key, Entity>();
    protected List<Entity> toInsertedOnTransaction = new ArrayList<Entity>();

    public void set(Key key, Entity e) {
        if (this.toInsertedOnTransaction.contains(e)) {
            this.toInsertedOnTransaction.remove(e);
        }
        this.entityStore.put(key, e);
    }

    public void addAsToInsertedOnTransaction(Entity e) {
        if (!MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key())) {
            throw new RuntimeException("The entity " + e + " has already a key set (" + e.getIM3Key() + ") and has therefore to be handled with the entityStore.");
        }
        this.toInsertedOnTransaction.add(e);
    }

    public Entity get(Key key) {
        return (Entity)((IM3Entity)this.entityStore.get(key));
    }

    public boolean has(Key key) {
        return this.entityStore.containsKey(key);
    }

    public boolean inToInsertOnTransactionList(Entity e) {
        return this.toInsertedOnTransaction.contains(e);
    }

    public List<Entity> getCheckedoutEntities() {
        ArrayList<IM3Entity> result = new ArrayList<IM3Entity>();
        Collection<Entity> all = this.entityStore.values();
        for (IM3Entity e : all) {
            if (e.getReadOnly()) continue;
            result.add(e);
        }
        for (IM3Entity e : this.toInsertedOnTransaction) {
            if (!MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key())) {
                throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
            }
            if (e.getReadOnly()) continue;
            result.add(e);
        }
        return result;
    }

    public List<Key> getCheckedoutEntitiesKeys() {
        ArrayList result = new ArrayList();
        Collection<Entity> all = this.entityStore.values();
        for (IM3Entity e : all) {
            if (e.getReadOnly()) continue;
            result.add(e.getIM3Key());
        }
        for (IM3Entity e : this.toInsertedOnTransaction) {
            if (!MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key())) {
                throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
            }
            if (e.getReadOnly()) continue;
            result.add(e.getIM3Key());
        }
        return result;
    }

    public List<Entity> getAllEntities() {
        ArrayList<IM3Entity> result = new ArrayList<IM3Entity>();
        Collection<Entity> all = this.entityStore.values();
        for (IM3Entity e : all) {
            result.add(e);
        }
        for (IM3Entity e : this.toInsertedOnTransaction) {
            if (!MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key())) {
                throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
            }
            result.add(e);
        }
        return result;
    }

    public List<Key> getAllEntitiesKeys() {
        ArrayList result = new ArrayList();
        Collection<Entity> all = this.entityStore.values();
        for (IM3Entity e : all) {
            result.add(e.getIM3Key());
        }
        for (IM3Entity e : this.toInsertedOnTransaction) {
            if (!MMStaticAccessHelper.isNullKeyStaticHelper(e.getIM3Key())) {
                throw new RuntimeException("We have the entity " + e + " (key " + e.getIM3Key() + ") in the 'to insert on transaction' list. Session handling corrupted - this should not happen.");
            }
            result.add(e.getIM3Key());
        }
        return result;
    }

    public boolean isDirty() {
        if (this.toInsertedOnTransaction.size() != 0) {
            return true;
        }
        Collection<Entity> all = this.entityStore.values();
        for (IM3Entity e : all) {
            if (!e.getDirty()) continue;
            return true;
        }
        return false;
    }

    public void removeEntity(Entity entity) {
        if (!this.entityStore.containsKey(entity.getIM3Key())) {
            throw new IllegalArgumentException("Entity " + entity + " was not found in KeyStore for " + entity.getClass().getName());
        }
        this.entityStore.remove(entity.getIM3Key());
    }

    public String toString() {
        String className = "(unknown)";
        if (this.entityStore.size() != 0) {
            className = ((IM3Entity)this.entityStore.values().iterator().next()).getClass().getName();
        }
        return "KeyStore for " + className + " with " + this.entityStore.size() + " objects.";
    }

    public String findDirty() {
        StringBuilder builder = new StringBuilder();
        Collection<Entity> all = this.entityStore.values();
        for (IM3Entity e : all) {
            if (!e.getDirty()) continue;
            builder.append("dirty entity (checkedout): " + e.getClass().getName() + "\n");
        }
        for (IM3Entity e : this.toInsertedOnTransaction) {
            if (!e.getDirty()) continue;
            builder.append("dirty entity (wainting for insert): " + e.getClass().getName() + "\n");
        }
        return builder.toString();
    }

    public int getRoObjectSize() {
        Collection<Entity> all = this.entityStore.values();
        int size = 0;
        for (IM3Entity e : all) {
            if (!e.getReadOnly()) continue;
            ++size;
        }
        return size;
    }

    public int getRwObjectSize() {
        return this.entityStore.size() - this.getRoObjectSize();
    }

    public int getDirtyObjectSize() {
        Collection<Entity> all = this.entityStore.values();
        int size = 0;
        for (IM3Entity e : all) {
            if (!e.getDirty()) continue;
            ++size;
        }
        for (IM3Entity e : this.toInsertedOnTransaction) {
            if (!e.getDirty()) continue;
            ++size;
        }
        return size;
    }

    public String getDirtyObjectInfo() {
        Collection<Entity> all = this.entityStore.values();
        Object infos = "";
        for (IM3Entity e : all) {
            if (!e.getDirty()) continue;
            infos = (String)infos + " " + e + ",";
        }
        for (IM3Entity e : this.toInsertedOnTransaction) {
            if (!e.getDirty()) continue;
            infos = (String)infos + " " + e + ",";
        }
        return infos;
    }

    public static void main(String[] args) {
        MMObjectKeyStore<Integer, MMDummyEntity> myKeyStore = new MMObjectKeyStore<Integer, MMDummyEntity>();
        MMDummyEntity e = new MMDummyEntity();
        myKeyStore.set(new Integer(1), e);
        System.out.println(">> " + myKeyStore);
        myKeyStore.removeEntity(e);
        System.out.println(">> " + myKeyStore);
    }
}

