/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.springframework.beans.factory.annotation.Autowired;

public class MMOracleDescription
implements IM3DatabaseDescription {
    private static final int ORACLE_MAX_EXP = 999;
    @Autowired
    private DataSource dataSource;

    @Override
    public boolean needsSequenceSelectPre() {
        return true;
    }

    @Override
    public boolean needsIdSelectPost() {
        return false;
    }

    @Override
    public String castAsDate(String orig) {
        return " CAST( " + orig + " AS DATE) ";
    }

    @Override
    public String getTimeStampQuery() {
        return "SELECT SYSTIMESTAMP FROM DUAL";
    }

    @Override
    public String queryForKey(String sequenceName) {
        return "SELECT " + sequenceName + ".NEXTVAL FROM DUAL";
    }

    @Override
    public String queryForListOfKey(String sequenceName, int num) {
        return "SELECT " + sequenceName + ".NEXTVAL FROM (SELECT level FROM DUAL CONNECT BY level <= " + num + ")";
    }

    @Override
    public void handleInOperatorInQuery(String fieldName, List<?> listOfObjects, StringBuilder whereStatement, List<Object> queryParams) {
        int size = ListSequence.fromList(listOfObjects).count();
        if (size > 0 && size < 999) {
            whereStatement.append(fieldName + " in (");
            for (int i = 0; i < size; ++i) {
                ListSequence.fromList(queryParams).addElement(ListSequence.fromList(listOfObjects).getElement(i));
                whereStatement.append("?");
                if (i + 1 >= size) continue;
                whereStatement.append(",");
            }
            whereStatement.append(")");
        } else if (size > 0) {
            whereStatement.append("(1, " + fieldName + ") in (");
            for (int i = 0; i < size; ++i) {
                ListSequence.fromList(queryParams).addElement(ListSequence.fromList(listOfObjects).getElement(i));
                whereStatement.append("(1, ?)");
                if (i + 1 >= size) continue;
                whereStatement.append(",");
            }
            whereStatement.append(")");
        } else {
            whereStatement.append("0=1");
        }
    }

    @Override
    public void handleLimitQuery(StringBuilder whereStatement, int count) {
        whereStatement.append(" FETCH NEXT " + count + " ROWS ONLY");
    }

    @Override
    public void setSessionInfo(String appNameVersionInfo) {
        appNameVersionInfo = appNameVersionInfo.replace(" ", "_");
        String sqlStatement = "BEGIN dbms_application_info.set_client_info('" + appNameVersionInfo + "'); END;";
        boolean initSqlCalled = false;
        try {
            Class<?> cls = this.dataSource.getClass();
            Method m = cls.getMethod("setInitSQL", String.class);
            m.invoke((Object)this.dataSource, sqlStatement);
            initSqlCalled = true;
        }
        catch (NoSuchMethodException cls) {
        }
        catch (InvocationTargetException cls) {
        }
        catch (IllegalAccessException cls) {
            // empty catch block
        }
        if (!initSqlCalled) {
            try {
                Connection con = this.dataSource.getConnection();
                Statement statement = con.createStatement();
                statement.execute(sqlStatement);
                con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

