/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.runtime;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.manmap.runtime.IM3QueryFromSqlRowRef;
import org.modellwerkstatt.manmap.runtime.IM3TypeHandler;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;

public class MMQueryFromSqlRowHelper
implements IM3QueryFromSqlRowRef {
    private ResultSet rs;
    public IM3TypeHandler<DateTime> _dateTimeTypeHandler = MMStaticAccessHelper._dateTimeTypeHandler;
    public IM3TypeHandler<LocalDate> _localDateTypeHandler = MMStaticAccessHelper._localDateTypeHandler;
    public IM3TypeHandler<BigDecimal> _bigDecimalTypeHandler = MMStaticAccessHelper._bigDecimalTypeHandler;
    public IM3TypeHandler<String> _stringTypeHandler = MMStaticAccessHelper._stringTypeHandler;
    public IM3TypeHandler<Integer> _intTypeHandler = MMStaticAccessHelper._intTypeHandler;

    @Override
    public void setResultSet(ResultSet rs) {
        this.rs = rs;
    }

    @Override
    public int getAsInteger(int colId) {
        try {
            return this._intTypeHandler.getResult(this.rs, colId + 1);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting colId " + colId, es);
        }
    }

    @Override
    public String getAsString(int colId) {
        try {
            return this._stringTypeHandler.getResult(this.rs, colId + 1);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting colId " + colId, es);
        }
    }

    @Override
    public BigDecimal getAsDecimal(int colId) {
        try {
            return this._bigDecimalTypeHandler.getResult(this.rs, colId + 1);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting colId " + colId, es);
        }
    }

    @Override
    public DateTime getAsDateTime(int colId) {
        try {
            return this._dateTimeTypeHandler.getResult(this.rs, colId + 1);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting colId " + colId, es);
        }
    }

    @Override
    public LocalDate getAsLocalDate(int colId) {
        try {
            return this._localDateTypeHandler.getResult(this.rs, colId + 1);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting colId " + colId, es);
        }
    }

    @Override
    public int getAsInteger(String colName) {
        try {
            return this._intTypeHandler.getResult(this.rs, colName);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting col '" + colName + "'", es);
        }
    }

    @Override
    public String getAsString(String colName) {
        try {
            return this._stringTypeHandler.getResult(this.rs, colName);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting col '" + colName + "'", es);
        }
    }

    @Override
    public BigDecimal getAsDecimal(String colName) {
        try {
            return this._bigDecimalTypeHandler.getResult(this.rs, colName);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting col '" + colName + "'", es);
        }
    }

    @Override
    public DateTime getAsDateTime(String colName) {
        try {
            return this._dateTimeTypeHandler.getResult(this.rs, colName);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting col '" + colName + "'", es);
        }
    }

    @Override
    public LocalDate getAsLocalDate(String colName) {
        try {
            return this._localDateTypeHandler.getResult(this.rs, colName);
        }
        catch (SQLException es) {
            throw new RuntimeException("While getting col '" + colName + "'", es);
        }
    }

    @Override
    public void setIntegerParameter(PreparedStatement statement, int index, int val, StringBuilder debugSb) {
        try {
            this._intTypeHandler.setParameter(statement, index + 1, val, debugSb);
        }
        catch (SQLException ex) {
            throw new RuntimeException("While setting param " + index, ex);
        }
    }

    @Override
    public void setStringParameter(PreparedStatement statement, int index, String val, StringBuilder debugSb) {
        try {
            this._stringTypeHandler.setParameter(statement, index + 1, val, debugSb);
        }
        catch (SQLException ex) {
            throw new RuntimeException("While setting param " + index, ex);
        }
    }

    @Override
    public void setBigDecimalParameter(PreparedStatement statement, int index, BigDecimal val, StringBuilder debugSb) {
        try {
            this._bigDecimalTypeHandler.setParameter(statement, index + 1, val, debugSb);
        }
        catch (SQLException ex) {
            throw new RuntimeException("While setting param " + index, ex);
        }
    }

    @Override
    public void setDateTimeParameter(PreparedStatement statement, int index, DateTime val, StringBuilder debugSb) {
        try {
            this._dateTimeTypeHandler.setParameter(statement, index + 1, val, debugSb);
        }
        catch (SQLException ex) {
            throw new RuntimeException("While setting param " + index, ex);
        }
    }

    @Override
    public void setLocalDateParameter(PreparedStatement statement, int index, LocalDate val, StringBuilder debugSb) {
        try {
            this._localDateTypeHandler.setParameter(statement, index + 1, val, debugSb);
        }
        catch (SQLException ex) {
            throw new RuntimeException("While setting param " + index, ex);
        }
    }
}

