/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.manmap.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.manmap.runtime.IM3Entity;
import org.modellwerkstatt.manmap.runtime.IM3Session;
import org.modellwerkstatt.manmap.runtime.MMObjectKeyStore;
import org.modellwerkstatt.manmap.runtime.MMShutdownRequestException;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;

public abstract class MMSession
implements IM3Session {
    protected Map<Integer, MMObjectKeyStore> keyStores = MapSequence.fromMap(new HashMap());
    protected List<IM3Entity> transactionEntities = ListSequence.fromList(new ArrayList());
    protected volatile boolean readOnly = false;
    protected boolean dirty;

    @Override
    public MMObjectKeyStore getOrCreateKeyStore(int uniqueHierarchyHashCode) {
        if (Thread.interrupted()) {
            throw new MMShutdownRequestException("getOrCreateKeyStore() - Thread.interrupted()=true, raising ShutDownRequest Exception.");
        }
        if (MapSequence.fromMap(this.keyStores).get((Object)uniqueHierarchyHashCode) == null) {
            MapSequence.fromMap(this.keyStores).put((Object)uniqueHierarchyHashCode, new MMObjectKeyStore());
        }
        return (MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueHierarchyHashCode);
    }

    @Override
    public void ensureInSession(Object obj) {
        if (obj instanceof IM3Entity) {
            IM3Entity ent = (IM3Entity)obj;
            int uniqueHierarchyHashCode = ent.getSessionObjectKeyStoreID();
            if (MapSequence.fromMap(this.keyStores).get((Object)uniqueHierarchyHashCode) == null) {
                MapSequence.fromMap(this.keyStores).put((Object)uniqueHierarchyHashCode, new MMObjectKeyStore());
            }
            if (!((MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueHierarchyHashCode)).has(ent.getIM3Key())) {
                if (!MMStaticAccessHelper.isNullKeyStaticHelper(ent.getIM3Key())) {
                    ((MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueHierarchyHashCode)).set(ent.getIM3Key(), ent);
                } else {
                    ((MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueHierarchyHashCode)).addAsToInsertedOnTransaction(ent);
                }
            }
        } else if (obj instanceof List) {
            for (Object singleEntity : (List)obj) {
                this.ensureInSession(singleEntity);
            }
        } else {
            throw new RuntimeException("ensureInSession() can be called with param list<Entity> or Entity only. (called with " + obj + ")");
        }
    }

    public String getKeyStoreInfo() {
        final StringBuilder sb = new StringBuilder();
        sb.append("---------- M3ManMapSession STATISTICS ----------\n");
        final Wrappers._int ro = new Wrappers._int(0);
        final Wrappers._int rw = new Wrappers._int(0);
        final Wrappers._int dirty = new Wrappers._int(0);
        final Wrappers._T dirtyInfo = new Wrappers._T((Object)"");
        MapSequence.fromMap(this.keyStores).visitAll((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<IMapping<Integer, MMObjectKeyStore>>(){

            public void invoke(IMapping<Integer, MMObjectKeyStore> it) {
                ro.value += ((MMObjectKeyStore)it.value()).getRoObjectSize();
                rw.value += ((MMObjectKeyStore)it.value()).getRwObjectSize();
                dirty.value += ((MMObjectKeyStore)it.value()).getDirtyObjectSize();
                dirtyInfo.value = (String)dirtyInfo.value + ((MMObjectKeyStore)it.value()).getDirtyObjectInfo();
            }
        });
        sb.append("Read Only Objects: " + ro.value + "\n");
        sb.append("Read Write Objects: " + rw.value + "\n");
        sb.append("Dirty Objects: " + dirty.value + "\n");
        sb.append("               " + (String)dirtyInfo.value);
        sb.append("\n\n");
        sb.append("Keystores in this session currently " + MapSequence.fromMap(this.keyStores).count() + " ------ \n");
        MapSequence.fromMap(this.keyStores).visitAll((_FunctionTypes._void_P1_E0)new _FunctionTypes._void_P1_E0<IMapping<Integer, MMObjectKeyStore>>(){

            public void invoke(IMapping<Integer, MMObjectKeyStore> it) {
                sb.append(((MMObjectKeyStore)it.value()).toString() + "\n");
            }
        });
        return sb.toString();
    }

    @Override
    public boolean isDirty() {
        List stores = Sequence.fromIterable((Iterable)MapSequence.fromMap(this.keyStores).values()).toList();
        if (this.dirty) {
            return true;
        }
        for (int i = 0; i < ListSequence.fromList((List)stores).count(); ++i) {
            if (!((MMObjectKeyStore)ListSequence.fromList((List)stores).getElement(i)).isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public String findDirtyEntities() {
        StringBuilder builder = new StringBuilder();
        List stores = Sequence.fromIterable((Iterable)MapSequence.fromMap(this.keyStores).values()).toList();
        for (int i = 0; i < ListSequence.fromList((List)stores).count(); ++i) {
            builder.append(((MMObjectKeyStore)ListSequence.fromList((List)stores).getElement(i)).findDirty());
        }
        return builder.toString();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public void addEntityInvolvedInTransaction(IM3Entity e) {
        ListSequence.fromList(this.transactionEntities).addElement((Object)e);
    }

    @Override
    public void clearAllKeystores() {
        MapSequence.fromMap(this.keyStores).clear();
        ListSequence.fromList(this.transactionEntities).clear();
    }

    @Override
    public <T> List<T> getEntitiesCheckedOut(int uniqueSessionEntityID) {
        if (MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID) == null) {
            return ListSequence.fromList(new ArrayList());
        }
        return ((MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID)).getCheckedoutEntities();
    }

    @Override
    public <T> List<T> getEntitiesCheckedOutKey(int uniqueSessionEntityID) {
        if (MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID) == null) {
            return ListSequence.fromList(new ArrayList());
        }
        return ((MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID)).getCheckedoutEntitiesKeys();
    }

    @Override
    public <T> List<T> getEntitiesAll(int uniqueSessionEntityID) {
        if (MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID) == null) {
            return ListSequence.fromList(new ArrayList());
        }
        return ((MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID)).getAllEntities();
    }

    @Override
    public <T> List<T> getEntitiesAllKey(int uniqueSessionEntityID) {
        if (MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID) == null) {
            return ListSequence.fromList(new ArrayList());
        }
        return ((MMObjectKeyStore)MapSequence.fromMap(this.keyStores).get((Object)uniqueSessionEntityID)).getAllEntitiesKeys();
    }

    @Override
    public void detachAllEntitiesByUniqueHashCode(int uniqueId) {
        if (MapSequence.fromMap(this.keyStores).get((Object)uniqueId) == null) {
            throw new IllegalArgumentException("Class with id " + uniqueId + " currently not used in this Session, can not detach it.");
        }
        MapSequence.fromMap(this.keyStores).removeKey((Object)uniqueId);
    }
}

