/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.AppMainWindowController;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.ConclusionEvent;
import org.modellwerkstatt.dataux.runtime.core.FocusEvent;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.core.KeyEvent;
import org.modellwerkstatt.dataux.runtime.core.WindowControllerMDI;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;

public class ApplicationMDI
extends AppMainWindowController
implements IOFXUserServices,
IApplication {
    protected List<ICommandContainer> runningTabCommandContainers;
    protected ICommandContainer promptWindowCommandContainer = null;
    private int currentRunningTabIndex;
    private boolean deliverTabChangeFocusEvent;
    private ISelectionController selCrtlAcrossTabs = new ISelectionController(){

        @Override
        public ISelectionController registerSelControlled(Class interestedInSelectionType, ISelectionController.Binding binding, IGenSelControlled xuElemToRegister) {
            return null;
        }

        @Override
        public IOFXSelection getSelectionAbsolute(Class cls, boolean includingDerived) {
            if (ApplicationMDI.this.currentRunningTabIndex >= 0) {
                return ApplicationMDI.this.runningTabCommandContainers.get(ApplicationMDI.this.currentRunningTabIndex).getSelectionAbsoluteFromCurrentPagePane(cls, includingDerived);
            }
            return null;
        }

        @Override
        public void pushSelectionAbsolute(IOFXSelection sel) {
            throw new RuntimeException("Not implemented.");
        }

        public void forceNotEditable() {
            throw new RuntimeException("Not implemented.");
        }

        @Override
        public IOFXSelection getLocalSelection() {
            return null;
        }

        @Override
        public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate newFocusHolder) {
            if (ApplicationMDI.this.currentRunningTabIndex >= 0) {
                ApplicationMDI.this.runningTabCommandContainers.get(ApplicationMDI.this.currentRunningTabIndex).receiveAndProcess(new ConclusionEvent(1, "UPDATE"));
            }
        }
    };
    private String lastRequestedRedirect = null;

    public ApplicationMDI(IToolkit_UiFactory factory, IToolkit_MainWindow appWin, IGenAppUiModule appBehavior, AppJmxRegistration registration, IOFXCoreReporter.MoWarePlatform pltfrm) {
        super(factory, appBehavior, registration, pltfrm);
        this.runningTabCommandContainers = new ArrayList<ICommandContainer>();
        this.appMainWindow = appWin;
        this.mainWindowController = new WindowControllerMDI(factory, this, (IToolkit_Window)appWin);
        this.currentRunningTabIndex = -1;
        this.deliverTabChangeFocusEvent = true;
    }

    public boolean initializeApplication(OFXUrlParams url, String systemName, IOFXUserEnvironment userEnv, String userConnectionInfo, String connectInfoAddOn) {
        return super.initializeApplication(url, this.selCrtlAcrossTabs, systemName, userEnv, userConnectionInfo, connectInfoAddOn);
    }

    public void onKeyPressEvent(KeyEvent ev) {
        if (this.shutdownMode) {
            return;
        }
        if ("DBG_LOCKING".equals(ev.getKey())) {
            this.mainWindowController.showBigInformationDialog("LOCKING SERVICE DEBUGGER:\n\n Please check locking information via dashboard.", null);
            return;
        }
        if (!this.applicationModalTabMode) {
            for (CmdAction action : this.mainMenuAndTileActions) {
                if (!ev.getKey().equals(action.hotKey) || !action.reevalEnabled()) continue;
                action.startCommand();
                return;
            }
        }
        if (this.currentRunningTabIndex >= 0) {
            this.runningTabCommandContainers.get(this.currentRunningTabIndex).receiveAndProcess(ev);
        }
    }

    public void onTabChangeEvent(int currentIndex) {
        if (this.shutdownMode) {
            return;
        }
        this.currentRunningTabIndex = currentIndex;
        if (this.currentRunningTabIndex >= 0) {
            this.reevalEnabledInMenusAndTiles();
            if (this.deliverTabChangeFocusEvent) {
                this.runningTabCommandContainers.get(this.currentRunningTabIndex).receiveAndProcess(new FocusEvent(false));
            }
        }
    }

    public void showCommandContainerUI(ICommandContainer cmdCont, IToolkit_CommandContainerUi ui, String windowTitle, IToolkit_Form content) {
        if (!ui.isTabWindow()) {
            if (this.promptWindowCommandContainer != null) {
                throw new RuntimeException("Application error: opening a prompt window " + cmdCont + " while a prompt window is already executed " + this.promptWindowCommandContainer);
            }
            this.promptWindowCommandContainer = cmdCont;
            content.rootForm();
            ui.show(windowTitle, content);
        } else {
            this.deliverTabChangeFocusEvent = false;
            this.runningTabCommandContainers.add(cmdCont);
            content.rootForm();
            ui.show(windowTitle, content);
            ++this.currentRunningTabIndex;
            this.appMainWindow.addTab(ui);
            if (ui.isModalTabWindow()) {
                this.lockCurrentTabAsModal(true);
            }
            this.deliverTabChangeFocusEvent = true;
        }
        this.checkToInstallConfirmCloseAlert();
    }

    public void lockCurrentTabAsModal(boolean lock) {
        if (lock) {
            if (this.promptWindowCommandContainer != null || this.applicationModalTabMode) {
                throw new RuntimeException("Progamming error - this should not happen. promptWindow open or modalTab already running?" + this.promptWindowCommandContainer + " / " + this.applicationModalTabMode);
            }
            this.applicationModalTabMode = true;
            this.appMainWindow.setCurrentTabModal(true);
        } else {
            if (!this.applicationModalTabMode) {
                this.logFrmwrkProblem("", "", "org.modellwerkstatt.App", "AppCrtl.lockCurrenTabAsModal(false) called while not in modal mode.", OFXConsoleHelper._____organizeCurrentStacktrace_____() + " \n \n " + this.fullApplicationCrtlState());
            }
            this.applicationModalTabMode = false;
            this.appMainWindow.setCurrentTabModal(false);
        }
    }

    public void closeCommandContainerUI(ICommandContainer cmd, IToolkit_CommandContainerUi ui, ICommandContainer parent) {
        this.reevalEnabledInMenusAndTiles();
        if (ui == null) {
            if (!this.shutdownMode) {
                if (this.promptWindowCommandContainer != null) {
                    this.promptWindowCommandContainer.receiveAndProcess(new FocusEvent(false));
                } else if (this.currentRunningTabIndex >= 0) {
                    this.runningTabCommandContainers.get(this.currentRunningTabIndex).receiveAndProcess(new FocusEvent(false));
                } else {
                    this.recalcAndShowTiles();
                }
            }
        } else if (ui.isTabWindow()) {
            if (ui.isModalTabWindow()) {
                this.lockCurrentTabAsModal(false);
            }
            int i = this.currentRunningTabIndex--;
            this.deliverTabChangeFocusEvent = false;
            this.runningTabCommandContainers.remove(cmd);
            this.appMainWindow.ensureTabClosed(ui);
            ui.close();
            if (!this.shutdownMode && parent != null && this.runningTabCommandContainers.indexOf(parent) >= 0) {
                parent.receiveAndProcess(new FocusEvent(true));
            } else if (!this.shutdownMode && this.runningTabCommandContainers.size() > 0) {
                if (--i < 0) {
                    i = 0;
                }
                this.runningTabCommandContainers.get(i).receiveAndProcess(new FocusEvent(true));
            } else if (!this.shutdownMode) {
                this.recalcAndShowTiles();
            }
            this.deliverTabChangeFocusEvent = true;
        } else {
            this.promptWindowCommandContainer = null;
            ui.close();
            if (!this.shutdownMode & this.currentRunningTabIndex >= 0) {
                this.runningTabCommandContainers.get(this.currentRunningTabIndex).receiveAndProcess(new FocusEvent(false));
            }
        }
        this.checkToInstallConfirmCloseAlert();
    }

    public void focusTab(ICommandContainer cc, IToolkit_CommandContainerUi ui) {
        this.deliverTabChangeFocusEvent = false;
        this.appMainWindow.focusTab(ui);
        this.deliverTabChangeFocusEvent = true;
    }

    @Override
    public boolean noGraphsToCommit() {
        for (int i = 0; i < this.runningTabCommandContainers.size(); ++i) {
            if (!this.runningTabCommandContainers.get(i).hasRwSessionToCommit()) continue;
            return false;
        }
        return true;
    }

    public void onExitRequested(boolean doNotCheckBackOnOpenGO) {
        boolean noGraphsOpen = this.noGraphsToCommit();
        if (doNotCheckBackOnOpenGO || noGraphsOpen) {
            this.shutdownMode = true;
            this.internal_immediatelyShutdown();
            this.appMainWindow.closeApplicationAndExit();
        } else {
            this.appMainWindow.showDialog(IToolkit_MainWindow.DlgType.QUESTIONCLOSE_SMALL, this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.CLOSE_APP), new IApplication.DlgRunnable(){

                @Override
                public void run(boolean confirmed) {
                    if (confirmed) {
                        ApplicationMDI.this.internal_immediatelyShutdown();
                        ApplicationMDI.this.appMainWindow.closeApplicationAndExit();
                    }
                }
            });
        }
    }

    @Deprecated
    public void legacyStartCommandByUriAndParam(String uri, String firstParam) {
        Wrappers._int i = new Wrappers._int(0);
        StringBuilder available = new StringBuilder();
        CmdAction actionToStart = (CmdAction)ListSequence.fromList((List)this.mainMenuAndTileActions).findFirst(it -> {
            String uriIdent = it.labelText.toLowerCase().replaceAll("\\W", "");
            available.append(uriIdent + "," + (i.value++ % 5 == 0 ? "\n" : ""));
            return uri.equals(uriIdent);
        });
        if (actionToStart == null) {
            String availableString = available.toString();
            availableString = availableString.substring(0, availableString.lastIndexOf(","));
            this.mainWindowController.showSimpleInfoDialog(String.format(this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.CMD_NOT_AVAILABLE), availableString), null);
        } else {
            Object[] params = actionToStart.calculateParams(null);
            if (params == null) {
                throw new RuntimeException("This can not be true. Tried to start a command with params null.");
            }
            if (firstParam != null) {
                params[0] = firstParam;
            }
            final BasisCmdStart ev = new BasisCmdStart(actionToStart.commandFqName, params);
            ev.setLabelText(actionToStart.labelText);
            this.execAfterStartupOrNow(new Runnable(){

                @Override
                public void run() {
                    ApplicationMDI.this.mainWindowController.receiveAndProcess(ev);
                }
            });
        }
    }

    public void startCommandWithoutParams(CmdAction actionToStart) {
        Object[] params = actionToStart.calculateParams(null);
        if (params == null) {
            throw new RuntimeException("This can not be true. Tried to start a command with params null.");
        }
        BasisCmdStart ev = new BasisCmdStart(actionToStart.commandFqName, params);
        ev.setLabelText(actionToStart.labelText);
        this.mainWindowController.receiveAndProcess(ev);
    }

    @Override
    public void internal_closeAllRunningCmds() {
        this.deliverTabChangeFocusEvent = false;
        this.afterStartupCmd = null;
        if (this.promptWindowCommandContainer != null) {
            this.promptWindowCommandContainer.internal_immediatelyShutdown();
        }
        if (this.runningTabCommandContainers.size() > 0) {
            ArrayList<ICommandContainer> runningTabsReverse = new ArrayList<ICommandContainer>(this.runningTabCommandContainers);
            Collections.reverse(runningTabsReverse);
            for (ICommandContainer c : runningTabsReverse) {
                c.internal_immediatelyShutdown();
            }
        }
        for (ICommandContainer container : List.copyOf(this.allRunningContainersToTerminate)) {
            this.logFrmwrkProblem("", "", "org.modellwerkstatt.App", "The container " + container + " was not terminated as running prompt or tab in internal_closeAllRunningCmds(). [Dialog not acknowledged, but killed?]", "");
            container.internal_immediatelyShutdown();
        }
        this.deliverTabChangeFocusEvent = true;
    }

    @Override
    public boolean isSameInstanceRunningThenFocus(String fqName, Object[] params) {
        boolean running = false;
        for (ICommandContainer cntr : this.runningTabCommandContainers) {
            if (!cntr.isSameCommandInstance(fqName, params)) continue;
            cntr.receiveAndProcess(new FocusEvent(true));
            running = true;
            break;
        }
        return running;
    }

    @Override
    public String fullApplicationCrtlState() {
        String s = this.appUserSystemVersionInfo() + " " + this.deviceId + ": ";
        Object[] allCommanndsRightNow = this.runningTabCommandContainers.toArray();
        for (int i = 0; i < allCommanndsRightNow.length; ++i) {
            s = s + "TAB " + (i + 1) + " " + allCommanndsRightNow[i] + ", ";
        }
        if (this.promptWindowCommandContainer != null) {
            s = s + "PROMPT " + this.promptWindowCommandContainer;
        }
        return s;
    }

    public String toString() {
        return this.fullApplicationCrtlState() + (this.shutdownMode ? " SHUTDOWNMODE" : "");
    }

    @Override
    public void openUrl(String url) {
        this.lastRequestedRedirect = url;
        this.appPrintService.openUrl(url);
    }

    public String getLastRequestedRedirectAndReset() {
        String red = this.lastRequestedRedirect;
        this.lastRequestedRedirect = null;
        return red;
    }
}

