/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.HashMap;
import java.util.Map;
import javax.management.NotificationBroadcasterSupport;
import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.core.ApplicationReporterMBean;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.telemetrics.ApplicationTelemetrics;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.UncategorizedSQLException;

public abstract class ApplicationReporter
extends NotificationBroadcasterSupport
implements ApplicationReporterMBean {
    protected IToolkit_UiFactory uiFactory;
    protected IOFXUserEnvironment userEnvironment;
    protected String userInfo;
    protected String userName;
    protected int userId;
    protected int userLangIndex;
    protected String connectionInfo;
    protected String connectionInfoAddOn;
    protected String deviceName;
    protected String deviceId;
    protected String deviceSwName;
    protected String systemName;
    protected IOFXCoreReporter.MoWarePlatform platform;
    protected String shortAppName;
    protected String appFqName;
    protected String swAppVersion;
    protected String progressor;
    protected AppJmxRegistration jmxRegHelper;
    protected long sequence;
    protected long lastInteraction;
    protected long appStartupLocalMillis;
    protected long lastRequestDiffMillis;
    protected long lastRequestDiffMillis2;
    protected long lastRequestDiffMillis3;
    protected String lastRequestLog;
    protected boolean debug;
    protected boolean ebLockingEnabled;
    protected String currentSequence = "no seq.";
    protected String jmxUniqueNameSuffix = "";

    public ApplicationReporter(IToolkit_UiFactory uf, AppJmxRegistration helper, IOFXCoreReporter.MoWarePlatform aPlatFrm) {
        this.uiFactory = uf;
        this.jmxRegHelper = helper;
        this.userInfo = "no-userinfo";
        this.progressor = "no-info";
        this.sequence = 0L;
        this.debug = false;
        this.ebLockingEnabled = true;
        this.userLangIndex = -1;
        this.systemName = "no-info";
        this.appStartupLocalMillis = this.lastInteraction = System.currentTimeMillis();
        this.platform = aPlatFrm;
        this.lastRequestDiffMillis = 0L;
        this.lastRequestDiffMillis2 = 0L;
        this.lastRequestDiffMillis3 = 0L;
        this.lastRequestLog = "";
    }

    protected void userLoggedIn(String sysName, IOFXUserEnvironment userEnv, String connInfo, String connectInfoAddOn, String aAppFqName, String aShortAppName, String swVersion) {
        this.userEnvironment = userEnv;
        this.appStartupLocalMillis = userEnv.getAppStartupLocalMillis();
        this.userName = userEnv.getUserName();
        this.userId = userEnv.getUserId();
        this.userInfo = userEnv.getUserName() + " (" + userEnv.getUserId() + ")";
        this.userLangIndex = userEnv.getLangIndex();
        this.deviceName = userEnv.getDeviceName();
        this.deviceSwName = userEnv.getDeviceSwName();
        this.deviceId = userEnv.getDeviceId();
        this.appFqName = aAppFqName;
        this.shortAppName = aShortAppName;
        this.swAppVersion = swVersion;
        this.connectionInfo = connInfo;
        this.connectionInfoAddOn = connectInfoAddOn;
        this.systemName = sysName;
        this.jmxRegHelper.registerClient(this);
    }

    public String appUserSystemVersionInfo() {
        return this.shortAppName + " " + this.swAppVersion + "  [" + this.userName + " @ " + this.systemName + "]";
    }

    public String getEscSwAppVersion() {
        return this.swAppVersion.toLowerCase().replaceAll("\\W", "_");
    }

    public void touch() {
        this.lastInteraction = System.currentTimeMillis();
    }

    @Override
    public String getuser_deviceId() {
        return this.deviceId;
    }

    @Override
    public String getuser_deviceSw() {
        return this.deviceSwName;
    }

    @Override
    public String getuser_jmxInstanceName() {
        Object full = this.userInfo.replace(":", "_");
        if (!"".equals(this.deviceName)) {
            full = (String)full + " " + this.deviceName;
        }
        if (!"".equals(this.jmxUniqueNameSuffix)) {
            full = (String)full + this.jmxUniqueNameSuffix;
        }
        return full;
    }

    public void setJmxUniqueNameSuffix(String s) {
        this.jmxUniqueNameSuffix = s;
    }

    @Override
    public String getuser_device() {
        return this.deviceName + " / " + this.deviceSwName;
    }

    @Override
    public String getuser_connectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public String getuser_connectionInfoAddOn() {
        return this.connectionInfoAddOn;
    }

    public String setuser_connectionInfoAddOn(String val) {
        this.connectionInfoAddOn = val;
        return this.connectionInfoAddOn;
    }

    @Override
    public String getuser_progressor() {
        return this.progressor;
    }

    public void setuser_progressor(String prog) {
        this.progressor = prog;
    }

    public void setuser_formseqId(String id) {
        this.currentSequence = id;
    }

    @Override
    public String getuser_sequenceinfo() {
        return this.currentSequence;
    }

    public void setuser_lastRequestDiffMillis(long val, long val2, long val3, String log) {
        this.lastRequestDiffMillis = val;
        this.lastRequestDiffMillis2 = val2;
        this.lastRequestDiffMillis3 = val3;
        this.lastRequestLog = log;
    }

    @Override
    public String getuser_lastInteraction() {
        return new DateTime(this.lastInteraction).toString();
    }

    @Override
    public String getuser_appStartup() {
        return new DateTime(this.appStartupLocalMillis).toString();
    }

    protected CoreReporterInfo createInfoObject(IOFXCoreReporter.Type typ, String source, String cmdName, String sessId, IOFXCoreReporter.LogPriority prio, String desc) {
        CoreReporterInfo info = new CoreReporterInfo(typ, this.appFqName, this.swAppVersion, source, cmdName, sessId, prio, this.userId, this.userName, this.deviceName + " " + this.deviceSwName, this.deviceId, this.connectionInfo, "moware11 2025.24 (dck)", this.platform, this.systemName, desc);
        return info;
    }

    public void logMowareTracing(String commandName, String sessId, String source, String desc, String param1) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE, source, commandName, sessId, IOFXCoreReporter.LogPriority.TRACE, desc);
        info.addParameter("param", (Object)param1);
        this.uiFactory.report(info);
    }

    public void logMowareTracing(String commandName, String sessId, String source, String desc, HashMap<String, Object> paramsNotNull) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE, source, commandName, sessId, IOFXCoreReporter.LogPriority.TRACE, desc);
        CoreReporterInfo.takeOverParamsIfNotNull((Map)info.getParameters(), paramsNotNull);
        this.uiFactory.report(info);
    }

    public void logFrmwrkProblem(String commandName, String sessId, String source, String desc, String param1) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
        info.addParameter("param", (Object)param1);
        this.uiFactory.report(info);
    }

    public void logFrmwrkProblem(String commandName, String sessId, String source, Throwable t, String desc) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
        info.setException(t);
        this.uiFactory.report(info);
    }

    public void logAppWarning(String commandName, String sessId, String source, String warningMsg, String param1) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.INFO, warningMsg);
        info.addParameter("param", (Object)param1);
        this.uiFactory.report(info);
    }

    public void logAppProblem(String commandName, String sessId, String source, Throwable t, String desc) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
        info.setException(t);
        this.uiFactory.report(info);
    }

    public void logAppProblem(String commandName, String sessId, String source, Throwable t, String desc, String param1) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, source, commandName, sessId, IOFXCoreReporter.LogPriority.ERROR, desc);
        info.addParameter("param", (Object)param1);
        info.setException(t);
        this.uiFactory.report(info);
    }

    public void logAppTrace(String commandName, String sessId, String source, String desc, String param, Map<String, Object> additionalParamsOrNull) {
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_TRACE, source, commandName, sessId, IOFXCoreReporter.LogPriority.TRACE, desc);
        info.addParameter("param", (Object)param);
        CoreReporterInfo.takeOverParamsIfNotNull((Map)info.getParameters(), additionalParamsOrNull);
        if (this.lastRequestDiffMillis > 0L) {
            info.addParameter("reqDiff", (Object)this.lastRequestDiffMillis);
            this.lastRequestDiffMillis = 0L;
        }
        if (this.lastRequestDiffMillis2 > 0L) {
            info.addParameter("reqDiff2", (Object)this.lastRequestDiffMillis2);
            info.addParameter("reqLog", (Object)this.lastRequestLog);
            this.lastRequestDiffMillis2 = 0L;
        }
        if (this.lastRequestDiffMillis3 > 0L) {
            info.addParameter("reqDiff3", (Object)this.lastRequestDiffMillis3);
            this.lastRequestDiffMillis3 = 0L;
        }
        this.uiFactory.report(info);
    }

    public String reportException(String cmdOrSysName, String sessId, String message, String contextInformation, Throwable throwable) {
        Object messageToUser;
        Object exMessage = throwable.getMessage();
        cmdOrSysName = MoVersion.getShortNameFromFQ((String)cmdOrSysName);
        if (throwable instanceof NullPointerException) {
            messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n";
            exMessage = "Null Pointer Exception";
            this.logAppProblem(cmdOrSysName, sessId, "org.modellwerkstatt.Exception", throwable, "NPE", message + "\n" + contextInformation);
        } else if (throwable instanceof IncorrectResultSetColumnCountException) {
            if (((String)exMessage).contains("GET()")) {
                messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n" + this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.GET_USER_PROBLEM) + "\n\n[" + (String)exMessage + "]";
                exMessage = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.GET_PROBLEM);
                this.logAppProblem(cmdOrSysName, sessId, "org.modellwerkstatt.Exception", throwable, "IncorrectResultSetColumnCount", message + "\n" + contextInformation);
            } else if (((String)exMessage).contains("UPDATE()")) {
                messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n" + this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TCN_PROBLEM) + "\n\n[" + (String)exMessage + "]";
                exMessage = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TCN_PROBLEM);
                this.logAppProblem(cmdOrSysName, sessId, "org.modellwerkstatt.TCN", throwable, "IncorrectResultSetColumnCount", message + "\n" + contextInformation);
            } else {
                messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n" + this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.INSERT_DELETE_RELOAD_PROBLEM) + "\n\n[" + (String)exMessage + "]";
                exMessage = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.INSERT_DELETE_RELOAD_PROBLEM);
                this.logAppProblem(cmdOrSysName, sessId, "org.modellwerkstatt.Exception", throwable, "IncorrectResultSetColumnCount", message + "\n" + contextInformation);
            }
        } else if (throwable instanceof UncategorizedSQLException) {
            if (((String)exMessage).toLowerCase().contains("[17002]")) {
                messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.LOST_CONN_USER_ERROR);
                exMessage = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_ERROR);
            } else {
                messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n";
                exMessage = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_ERROR);
            }
            this.logAppProblem(cmdOrSysName, sessId, "org.modellwerkstatt.Exception", throwable, "UncategorizedSQL", message + "\n" + contextInformation);
        } else if (throwable instanceof OFXShutDownSessionException) {
            IOFXProblem prblm = ((OFXShutDownSessionException)throwable).getProblem();
            messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR);
            exMessage = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.GUARD_MSG) + " " + prblm.getSimpleUserText();
            this.logAppProblem(cmdOrSysName, sessId, "org.modellwerkstatt.Exception", throwable, "Guard", prblm.getSimpleUserText());
        } else {
            messageToUser = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_USER_ERROR) + "\n\n";
            exMessage = this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.TEC_ERROR);
            this.logAppProblem(cmdOrSysName, sessId, "org.modellwerkstatt.Exception", throwable, throwable.getClass().getSimpleName(), message + "\n" + contextInformation);
        }
        exMessage = "\n\n Exception occured in " + cmdOrSysName + ": " + (String)exMessage + "\n\n\n";
        exMessage = (String)exMessage + OFXConsoleHelper.stackTrace2String((Throwable)throwable);
        exMessage = (String)exMessage + "\n\nCONTEXT:   " + message;
        if (contextInformation != null && !"".equals(contextInformation.trim())) {
            exMessage = (String)exMessage + "\n" + contextInformation;
        }
        this.jmxRegHelper.getAppTelemetrics().incException();
        if (this.uiFactory.isSilentExLogging()) {
            return messageToUser;
        }
        return exMessage;
    }

    public ApplicationTelemetrics getAppTelemetrics() {
        return this.jmxRegHelper.getAppTelemetrics();
    }

    public void closeReporting() {
        if (this.jmxRegHelper != null) {
            try {
                this.logAppTrace("", "", "org.modellwerkstatt.Login", "application shutdown", "", null);
                this.jmxRegHelper.unregisterClient(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.jmxRegHelper = null;
    }

    @Override
    public abstract String fullApplicationCrtlState();

    @Override
    public String toggleDebugEnabled() {
        this.debug = !this.debug;
        return "Debug now set to '" + this.debug + "'.";
    }

    @Override
    public String toggleEventBusLockingEnabled() {
        this.ebLockingEnabled = !this.ebLockingEnabled;
        this.logAppTrace("", "", "org.modellwerkstatt.Locking", "eb locking via jmx set to " + this.ebLockingEnabled, "", null);
        return "EventBusLocking now set to '" + this.ebLockingEnabled + "'.";
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isEbLockingForThisInstance() {
        return this.uiFactory.getEventBusLocking() && this.ebLockingEnabled;
    }

    public void setDebug(boolean dbg) {
        this.debug = dbg;
    }
}

