/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.modellwerkstatt.dataux.runtime.auth.IExtAuthProvider;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenPagePane;
import org.modellwerkstatt.dataux.runtime.sdicore.CheckerForCmdUrlDefaults;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IMoEventBusService;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXPrintFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.OFXSimpleManMapSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class BaseUiFactory
implements IOFXCoreReporter {
    protected MoWareTranslations defaulTrans;
    protected String connectionInfo;
    protected boolean skipTCNExceptions;
    protected boolean isSilentLogging;
    protected boolean mowareTrace;
    protected boolean appTrace;
    protected boolean eventBusLocking;
    protected boolean scrollAdjustEnabled;
    protected boolean portJEnabled;
    protected boolean portJLocal;
    protected boolean logAllEventsToStdErrAdditionally;
    protected boolean experimentalFeatures;
    protected boolean reloadOnTabChange;
    protected boolean collectSelections;
    protected boolean alwaysRollbackSession;
    protected boolean checkAlsoPredecessorDuplication;
    protected boolean optimKeyboard;
    protected boolean autoParDeploymentForwardGracefully;
    private boolean deployedVersionCheck;
    protected String uploadLocationRetrieve;
    protected String uploadLocationStore;
    protected String uploadFsLocationStore;
    protected int uploadMaxSize;
    protected String COMMAND_CONTAINER_FQ_NAME = "org.modellwerkstatt.dataux.runtime.core.EventCommandContainer";
    protected Class commandContainerClass;
    protected List<IOFXCmdModule.CmdUrlDefaults> allUrlDefaults;
    protected List<IExtAuthProvider> extAuthProviders;
    @Autowired
    protected ApplicationContext context;
    @Autowired
    protected IOFXPrintFactory printFactory;
    @Autowired
    protected DataSource dataSource;
    @Autowired
    protected IOFXPlatform platform;
    @Autowired
    private IMoEventBusService eventBusService;
    @Autowired
    private IOFXTranslationProvider transProvider;

    public BaseUiFactory(MoWareTranslations.TranslationSelection transType) {
        this.defaulTrans = new MoWareTranslations(transType);
        this.allUrlDefaults = new ArrayList<IOFXCmdModule.CmdUrlDefaults>();
        this.connectionInfo = null;
        this.skipTCNExceptions = false;
        this.isSilentLogging = false;
        this.eventBusLocking = false;
        this.mowareTrace = false;
        this.scrollAdjustEnabled = false;
        this.portJEnabled = false;
        this.portJLocal = false;
        this.experimentalFeatures = false;
        this.reloadOnTabChange = false;
        this.collectSelections = false;
        this.alwaysRollbackSession = false;
        this.checkAlsoPredecessorDuplication = false;
        this.optimKeyboard = false;
        this.deployedVersionCheck = true;
        this.autoParDeploymentForwardGracefully = false;
        this.commandContainerClass = null;
        this.logAllEventsToStdErrAdditionally = false;
        this.uploadMaxSize = 2000000;
    }

    public void initCmdUrlDefaults() {
        Map allModuels = this.context.getBeansOfType(IOFXCmdModule.class);
        for (String key : allModuels.keySet()) {
            this.allUrlDefaults.addAll(Arrays.asList(((IOFXCmdModule)allModuels.get(key)).getCmdUrlDefaults()));
        }
        CheckerForCmdUrlDefaults checker = new CheckerForCmdUrlDefaults();
        List<String> doubles = checker.check(this.allUrlDefaults);
        if (doubles.size() != 0) {
            throw new RuntimeException("The following urls (+ param counts) are defined more than once in the application: " + String.join((CharSequence)", ", doubles));
        }
    }

    public List<IOFXCmdModule.CmdUrlDefaults> getAllCmdUrlDefaults() {
        return this.allUrlDefaults;
    }

    public void initExtAuthProviders() {
        this.extAuthProviders = new ArrayList<IExtAuthProvider>();
        Map allProviders = this.context.getBeansOfType(IExtAuthProvider.class);
        for (IExtAuthProvider provider : allProviders.values()) {
            this.extAuthProviders.add(provider);
        }
    }

    public List<IExtAuthProvider> getAllExtAuthProviders() {
        return this.extAuthProviders;
    }

    public boolean getSkipLoggingTcnException() {
        return this.skipTCNExceptions;
    }

    public void setSkipLoggingTcnException(boolean val) {
        this.skipTCNExceptions = val;
    }

    public boolean isSilentExLogging() {
        return this.isSilentLogging;
    }

    public void setSilentExLogging(boolean val) {
        this.isSilentLogging = val;
    }

    public void setPortJ(boolean val) {
        this.portJEnabled = val;
    }

    public boolean getPortJ() {
        return this.portJEnabled;
    }

    public void setPortJLocal(boolean val) {
        this.portJEnabled = val;
        this.portJLocal = val;
        if (val) {
            OFXLogger.enablePortJ();
        }
    }

    public boolean getPortJLocal() {
        return this.portJLocal;
    }

    public boolean isScrollAdjust() {
        return this.scrollAdjustEnabled;
    }

    public void setScrollAdjust(boolean val) {
        this.scrollAdjustEnabled = val;
    }

    public boolean getMowareTrace() {
        return this.mowareTrace;
    }

    public boolean getAppTrace() {
        return this.appTrace;
    }

    public void setAppTrace(boolean val) {
        this.appTrace = val;
    }

    public boolean getOptimKeyboard() {
        return this.optimKeyboard;
    }

    public void setOptimKeyboard(boolean val) {
        this.optimKeyboard = val;
    }

    public boolean getExperimentalFeatures() {
        return this.experimentalFeatures;
    }

    public void setExperimentalFeatures(boolean val) {
        this.experimentalFeatures = val;
    }

    public boolean getCollectSelections() {
        return this.collectSelections;
    }

    public void setCollectSelections(boolean val) {
        this.collectSelections = val;
    }

    public boolean getCheckAlsoPredecessorDuplication() {
        return this.checkAlsoPredecessorDuplication;
    }

    public void setCheckAlsoPredecessorDuplication(boolean val) {
        this.checkAlsoPredecessorDuplication = val;
    }

    public boolean getReloadOnTabChange() {
        return this.reloadOnTabChange;
    }

    public void setReloadOnTabChange(boolean val) {
        this.reloadOnTabChange = val;
    }

    public boolean getAlwaysRollbackSession() {
        return this.alwaysRollbackSession;
    }

    public void setAlwaysRollbackSession(boolean val) {
        this.alwaysRollbackSession = val;
    }

    public boolean getEventBusLocking() {
        return this.eventBusLocking;
    }

    public void setMowareTrace(boolean val) {
        this.mowareTrace = val;
        if (val) {
            this.appTrace = val;
        }
    }

    public void setEventBusLocking(boolean val) {
        this.eventBusLocking = val;
    }

    public void setLogEventsToStdErr(boolean val) {
        this.logAllEventsToStdErrAdditionally = val;
    }

    public boolean getLogEventsToStdErr() {
        return this.logAllEventsToStdErrAdditionally;
    }

    public String getUploadLocationRetrieve() {
        return this.uploadLocationRetrieve;
    }

    public String getUploadLocationStore() {
        return this.uploadLocationStore;
    }

    public String getUploadFsLocationStore() {
        return this.uploadFsLocationStore;
    }

    public void setUploadLocationRetrieve(String val) {
        this.uploadLocationRetrieve = val.endsWith(File.separator) ? val : val + File.separator;
    }

    public void setUploadLocationStore(String val) {
        this.uploadLocationStore = val.endsWith(File.separator) ? val : val + File.separator;
    }

    public void setUploadFsLocationStore(String val) {
        this.uploadFsLocationStore = val.endsWith(File.separator) ? val : val + File.separator;
    }

    public void setUploadMaxSize(int val) {
        this.uploadMaxSize = val;
    }

    public int getUploadMaxSize() {
        return this.uploadMaxSize;
    }

    public void setAutoParDeploymentForwardGracefully(boolean val) {
        this.autoParDeploymentForwardGracefully = val;
    }

    public boolean isAutoParDeploymentForwardGracefully() {
        return this.autoParDeploymentForwardGracefully;
    }

    public boolean isCheckDeployedVersion() {
        return this.deployedVersionCheck;
    }

    public void setCheckDeployedVersion(boolean val) {
        this.deployedVersionCheck = val;
    }

    public void setDefaultEnglish(boolean val) {
        this.defaulTrans = new MoWareTranslations(MoWareTranslations.TranslationSelection.EN_DEFAULT_TRANS);
    }

    public String getSettingsDescription() {
        Object settings = "";
        if (this.skipTCNExceptions) {
            settings = (String)settings + "SkipLoggingTcnExcpt ";
        }
        if (this.isSilentLogging) {
            settings = (String)settings + "SilentExcptLoggin ";
        }
        if (this.eventBusLocking) {
            settings = (String)settings + "EventBusLocking ";
        }
        if (this.scrollAdjustEnabled) {
            settings = (String)settings + "ScrollAdjust ";
        }
        if (this.alwaysRollbackSession) {
            settings = (String)settings + "AlwaysRollbackSession ";
        }
        if (this.portJEnabled) {
            settings = (String)settings + "PortJ ";
        }
        if (this.experimentalFeatures) {
            settings = (String)settings + "ExperimentalFeatures ";
        }
        if (this.reloadOnTabChange) {
            settings = (String)settings + "ReloadOnTabChange ";
        }
        if (this.collectSelections) {
            settings = (String)settings + "CollectSelections ";
        }
        if (this.deployedVersionCheck) {
            settings = (String)settings + "ChckDplVrs ";
        }
        if (this.autoParDeploymentForwardGracefully) {
            settings = (String)settings + "AutoParDeplyFrwdGracefly ";
        }
        if (this.logAllEventsToStdErrAdditionally) {
            settings = (String)settings + "LogAllEventsToStdErrAdditionally ";
        }
        if (this.appTrace) {
            settings = (String)settings + "AppTrace ";
        }
        if (this.mowareTrace) {
            settings = (String)settings + "MoWareTrace ";
        }
        return settings;
    }

    public String getStatusDescription() {
        String settings = "EventBus " + this.eventBusService.getCurrentStatus();
        return settings;
    }

    public Object getNewClassInstanceByFQName(String fqName) {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> bean = cl.loadClass(fqName);
            Object instance = this.context.getAutowireCapableBeanFactory().createBean(bean);
            return instance;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Class '" + fqName + "' not found!", cnfe);
        }
    }

    public IGenPagePane createGenPagePaneByFqName(String fqName) {
        return (IGenPagePane)this.getNewClassInstanceByFQName(fqName);
    }

    public IOFXSession createNewSession(IOFXUserEnvironment userEnv, IOFXUserServices srv) {
        if (userEnv == null || srv == null) {
            throw new RuntimeException("This can not happen " + userEnv + " / " + srv + " - none should be null.");
        }
        OFXSimpleManMapSession session = (OFXSimpleManMapSession)this.context.getAutowireCapableBeanFactory().createBean(OFXSimpleManMapSession.class);
        session.initSession(userEnv, srv, this.alwaysRollbackSession);
        return session;
    }

    public IOFXCommand createNewCommand(Class commandClass) {
        return (IOFXCommand)this.context.getAutowireCapableBeanFactory().createBean(commandClass);
    }

    public void report(CoreReporterInfo cri) {
        if (this.logAllEventsToStdErrAdditionally) {
            System.err.println(OFXLogger.convertToString((CoreReporterInfo)cri));
        }
        if (!this.mowareTrace && cri.getMsgType() == IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE) {
            return;
        }
        if (!this.appTrace && cri.getMsgType() == IOFXCoreReporter.Type.APP_TRACE) {
            return;
        }
        boolean sent = false;
        if (this.portJLocal) {
            sent = true;
            if (this.sendToPortJ(cri)) {
                OFXLogger.logCoreInfoToJOrConsole((CoreReporterInfo)cri);
            }
        } else if (this.portJEnabled) {
            sent = true;
            if (this.sendToPortJ(cri)) {
                sent = this.getEventBus().sendToLogChannel("portjlog", OFXLogger.convertToJSON((CoreReporterInfo)cri));
            }
        }
        if (!sent) {
            if (cri.getMsgType() == IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM) {
                cri.setPrio(IOFXCoreReporter.LogPriority.DEBUG);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(cri.getCmdFqName() + ": ");
            sb.append(cri.getDescription() + " ");
            if (cri.getParameters().containsKey("param")) {
                sb.append(cri.getParameters().get("param") + " ");
                cri.getParameters().remove("param");
            }
            Set allKeys = cri.getParameters().keySet();
            for (String key : allKeys) {
                sb.append(" " + key + ": " + cri.getParameters().get(key));
            }
            if (!this.skipTCNExceptions || !"org.modellwerkstatt.TCN".equals(cri.getSource())) {
                OFXLogger.log((String)cri.getSource(), (IOFXCoreReporter.LogPriority)cri.getPrio(), (String)sb.toString(), (Throwable)cri.getException());
            }
        }
    }

    public IMoEventBusService getEventBus() {
        return this.eventBusService;
    }

    public IOFXTranslationProvider getTransProvider() {
        return this.transProvider;
    }

    public IPrintingServiceImpl createConfiguredUserPrintService(Object tecHandle, IOFXUserEnvironment userEnvironment) {
        return this.printFactory.createConfiguredUserPrintService(tecHandle, userEnvironment);
    }

    public IOFXCmdModule getModuleByInstanceName(String fqName) {
        return (IOFXCmdModule)this.context.getBean(fqName);
    }

    public String getSystemLabel(int langIndex, MoWareTranslations.Key key) {
        if (langIndex < 0) {
            return this.defaulTrans.t(key);
        }
        if (this.transProvider.providesTranslationKey(key.name())) {
            return this.transProvider.translateSingle(langIndex, key.name());
        }
        return this.defaulTrans.t(key);
    }

    public IOFXPlatform getPlatform() {
        return this.platform;
    }

    public String getConnectionUrl() {
        if (this.connectionInfo == null) {
            try {
                DatabaseMetaData dbmd = this.dataSource.getConnection().getMetaData();
                this.connectionInfo = dbmd.getURL();
                String version = dbmd.getDriverVersion();
                this.connectionInfo = this.connectionInfo + " (ver " + version + ")";
            }
            catch (SQLException sqex) {
                OFXLogger.log(BaseUiFactory.class, (IOFXCoreReporter.LogPriority)IOFXCoreReporter.LogPriority.INFO, (String)"Can not get db-driver connection info", (Throwable)sqex);
                this.connectionInfo = "(not available due to SQLException)";
            }
        }
        return this.connectionInfo;
    }

    public ICommandContainer createCommandContainer() {
        try {
            if (this.commandContainerClass == null) {
                this.commandContainerClass = Class.forName(this.COMMAND_CONTAINER_FQ_NAME);
            }
            return (ICommandContainer)this.commandContainerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCommandContainerFqName(String fqName) {
        this.COMMAND_CONTAINER_FQ_NAME = fqName;
    }

    public boolean isFX8LegacyImpl() {
        return false;
    }
}

