/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import mjson.Json;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.CancelAndClose;
import org.modellwerkstatt.dataux.runtime.core.CancelAndCloseImmediately;
import org.modellwerkstatt.dataux.runtime.core.CloseCntrCmdTermedEvent;
import org.modellwerkstatt.dataux.runtime.core.CloseCntrExInfoEvent;
import org.modellwerkstatt.dataux.runtime.core.CompoundOuterCmdStart;
import org.modellwerkstatt.dataux.runtime.core.ConclusionEvent;
import org.modellwerkstatt.dataux.runtime.core.FlagOnUiEvent;
import org.modellwerkstatt.dataux.runtime.core.GlobalCmdTermEvent;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.dataux.runtime.core.IWindowController;
import org.modellwerkstatt.dataux.runtime.core.InitCmdEvent;
import org.modellwerkstatt.dataux.runtime.core.InitPageAfterCon;
import org.modellwerkstatt.dataux.runtime.core.KeyEvent;
import org.modellwerkstatt.dataux.runtime.core.OpenUiEvent;
import org.modellwerkstatt.dataux.runtime.core.PagePaneSelCrtl;
import org.modellwerkstatt.dataux.runtime.core.PagePaneSelectionRecorder;
import org.modellwerkstatt.dataux.runtime.core.ReevalEvent;
import org.modellwerkstatt.dataux.runtime.core.SetupUiAftrPageInit;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenPagePane;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.javaxbus.ConsumerHandler;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXPage;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSelProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXSelcrtlBasics;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXChangePageException;
import org.modellwerkstatt.objectflow.runtime.OFXCommandDisabledReason;
import org.modellwerkstatt.objectflow.runtime.OFXConclusionInformation;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.OFXSuccessorCommandConfig;
import org.modellwerkstatt.objectflow.runtime.Selection;

public abstract class CommandContainer
implements ICommandContainer,
ConsumerHandler {
    public static final int ESC_CONCLUSION_CODE = 0;
    public static final String ESC_CONCLUSION_ICON_NAME = "arrow_back";
    public static final int UPDATE_CONCLUSION_CODE = 1;
    protected IToolkit_UiFactory uiFactory;
    protected IApplication app;
    protected IWindowController windowCrtl;
    protected IOFXCommand command;
    protected Object[] cmdParams;
    protected IOFXCommand predecessorCommand;
    protected Object[] predecessorCmdParams;
    protected String fullCmdNameAndSuccessor;
    protected String sessId;
    protected String cmdStartDescription;
    protected int langIndex;
    protected boolean containerClosed;
    protected long containerClosedTimestamp;
    protected boolean isStillOkayAsParentForMultiExecution;
    protected CommandContainer parentCommandContainer;
    protected String windowTitle;
    protected String adjustedUrl;
    private int currentPageIndex;
    private List<IOFXProblem> currentProblems;
    private String currentPageTitle;
    private String currentLockingMessage;
    private List<?> currentBoundObjects;
    private String currentUIColor;
    protected List<OFXConclusionInformation> currentConclusionInfos;
    protected List<IOFXPage.IOFXPageConclusion> currentConclusions;
    private IGenPagePane currentGenPagePane;
    protected IToolkit_CommandContainerUi commandUI;
    protected PagePaneSelCrtl currentPagePaneSelCrtl;
    protected PagePaneSelectionRecorder selRecorder;
    protected boolean autoConclusionMode_NoUi;
    protected boolean commandRequestedModalTab;
    protected boolean ebLockingActive;
    protected long ebLockRequestedTimestamp;
    private List<String> ebLocksHold;

    public void initialize(IToolkit_UiFactory fact, IApplication crtl, IWindowController win, ICommandContainer parent, BasisCmdStart startEvent, String aSessId) {
        this.uiFactory = fact;
        this.app = crtl;
        this.windowCrtl = win;
        this.parentCommandContainer = (CommandContainer)parent;
        this.containerClosed = false;
        this.currentUIColor = null;
        this.fullCmdNameAndSuccessor = startEvent.getCommandName();
        this.sessId = aSessId;
        this.windowTitle = startEvent.getLabelText();
        this.isStillOkayAsParentForMultiExecution = true;
        this.commandRequestedModalTab = false;
        this.autoConclusionMode_NoUi = false;
        this.ebLockingActive = false;
        this.selRecorder = new PagePaneSelectionRecorder();
    }

    public boolean isSuccessor() {
        return this.predecessorCommand != null;
    }

    @Override
    public boolean isAutoConNoUi() {
        return this.autoConclusionMode_NoUi;
    }

    public boolean setAutoConclusionMode_NoUi() {
        this.autoConclusionMode_NoUi = true;
        return true;
    }

    protected void fg_conclusionKey(KeyEvent ev) throws Exception {
        if (this.containerClosed) {
            return;
        }
        boolean processed = false;
        if ("DBG_GRAPH".equals(ev.getKey())) {
            String controllerInfo = this.currentPagePaneSelCrtl.getControllersInfo();
            this.windowCrtl.showGraphDebugger(this.currentPagePaneSelCrtl.getLoadedList(), controllerInfo);
            processed = true;
        } else if ("DBG_SESSION".equals(ev.getKey())) {
            this.windowCrtl.showBigInformationDialog("SESSION DEBUGGER\n\nYour session is currently in the following state:\n\n" + this.command.getCommandSession().toString(), null);
            processed = true;
        } else {
            for (OFXConclusionInformation info : this.currentConclusionInfos) {
                if (ev.isWithModifier() || !ev.getKey().equals(info.hotkey) || !info.enabled) continue;
                processed = true;
                this.fg_doConclusion(info.conclusionHashCode);
                break;
            }
        }
        if (!processed) {
            this.currentPagePaneSelCrtl.onGlobalKeyPressEvent(ev.getKey());
        }
    }

    protected void bg_fg_initContainer(InitCmdEvent ev) {
        this.cmdParams = ev.getParams();
        this.command = ev.getCommand();
        this.cmdStartDescription = ev.paramInfo();
        if (this.command.getCommandSession() == null) {
            this.receiveAndProcess(new CloseCntrExInfoEvent(new RuntimeException("Configuration/Programming Error - no session provided for command.")));
            return;
        }
        if (this.command.hasSuccessorCommand() && this.isSuccessor()) {
            this.receiveAndProcess(new CloseCntrExInfoEvent(new RuntimeException("Command has a successor and is run as successor, this is not supported by the runtime.")));
            return;
        }
        this.langIndex = this.getSession().getUserEnvironment().getLangIndex();
        this.isStillOkayAsParentForMultiExecution = this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.SEARCH_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL});
        if (!this.isSuccessor()) {
            this.commandRequestedModalTab |= this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL});
            this.app.getAppTelemetrics().incCommands();
            if (this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD})) {
                this.currentUIColor = this.parentCommandContainer.currentUIColor;
            }
            if (this.currentUIColor == null) {
                this.currentUIColor = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)this.command.getCommandFqName())).getCommandDefaultColor(this.command.getCommandFqName());
            }
        }
        if (!this.command.getCommandSession().isReadOnly()) {
            List locks = this.command.getLockNecessaryLockNames();
            if (ListSequence.fromList((List)(locks = ListSequence.fromList((List)locks).where(it -> it != null).toList())).count() > 0 && this.app.isEbLockingForThisInstance()) {
                this.ebLockingActive = true;
                this.ebLocksHold = ListSequence.fromList(new ArrayList());
                this.uiFactory.getEventBus().register((ConsumerHandler)this, "locking");
                Object lockName = "";
                for (String lock : locks) {
                    lockName = (String)lockName + lock + ", ";
                    ListSequence.fromList(this.ebLocksHold).addElement((Object)lock.toLowerCase());
                }
                this.ebLockRequestedTimestamp = System.currentTimeMillis();
                this.uiFactory.getEventBus().publish("locking", this.createLockJson((String)lockName, this.ebLockRequestedTimestamp, this.hashCode()).set("type", (Object)"requestLock"));
            }
        }
        if (this.isAutoConNoUi() && this.currentLockingMessage != null) {
            List problems = this.getSession().getAndclearProblemState();
            ListSequence.fromList((List)problems).addElement((Object)new OFXProblem(this.currentLockingMessage, null, null, new IOFXProblem.Opt[0]));
            this.receiveAndProcess(new CancelAndClose(problems));
            return;
        }
        try {
            this.currentProblems = ListSequence.fromList(new ArrayList());
            this.command.initCommand();
        }
        catch (OFXAbortedException aborted) {
            this.receiveAndProcess(new CancelAndClose(this.getSession().getAndclearProblemState()));
            return;
        }
        catch (Exception ex) {
            this.receiveAndProcess(new CloseCntrExInfoEvent(ex));
            return;
        }
        this.adjustedUrl = this.command.getAdjustedCmdUrl();
        if (this.windowTitle == null) {
            this.windowTitle = this.command.getCommandTitleShort();
        }
        if (!this.isSuccessor()) {
            String addOnTitle = this.command.getWindowTitle();
            if (addOnTitle != null && this.command.getWindowTitleType() == IOFXCommand.OFXWindowTitleType.ADD_ON) {
                this.windowTitle = this.windowTitle + " " + addOnTitle;
            } else if (addOnTitle != null) {
                this.windowTitle = addOnTitle;
            }
        } else if (this.command.getWindowTitleType() == IOFXCommand.OFXWindowTitleType.FORCE_OVERWRITE && this.command.getWindowTitle() != null) {
            this.windowTitle = this.command.getWindowTitle();
        }
        if (this.command.hasSuccessorCommand() && this.command.isReadyForSuccessor()) {
            this.prepareSuccessorExecution();
            return;
        }
        if (this.command.isTerminatedOk()) {
            this.receiveAndProcess(new CloseCntrCmdTermedEvent("no pages, term ok"));
            return;
        }
        if (this.command.isUserCancelTerminated()) {
            this.receiveAndProcess(new CloseCntrCmdTermedEvent("user canceled due to RO-session and no page present"));
            return;
        }
        this.currentPageIndex = this.command.getCurrentPageIndex();
        try {
            this.selRecorder.clear();
            this.currentBoundObjects = this.command.initCurrentPage((IOFXSelProvider)this.selRecorder);
            this.currentProblems = this.getSession().getAndclearProblemState();
        }
        catch (OFXAbortedException ex) {
            List problems = this.getSession().getAndclearProblemState();
            if (this.isAutoConNoUi()) {
                this.receiveAndProcess(new CancelAndClose(problems));
                return;
            }
            this.currentBoundObjects = ListSequence.fromList(new ArrayList());
            this.currentProblems = problems;
        }
        catch (Exception ex) {
            this.receiveAndProcess(new CloseCntrExInfoEvent(ex));
            return;
        }
        this.currentPageTitle = this.command.calcCurrentPageDynamicTitleAndScopes();
        if (this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL}) && !this.getSession().inSuccessorPattern() && this.getSession().isDirty()) {
            this.app.logAppWarning(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "DIRTY_SESSION (not shared) after cmd init + page init", null);
        }
        this.receiveAndProcess(new OpenUiEvent());
    }

    private IGenPagePane instantiateNewGenPagePane() {
        String currentPagePaneFqName = this.command.calcCurrentPagePaneFqName(this.command.getCurrentPageIndex());
        IGenPagePane pane = this.uiFactory.createGenPagePaneByFqName(currentPagePaneFqName);
        if (pane == null) {
            throw new RuntimeException("Form " + currentPagePaneFqName + " for Command " + this.command.getCommandFqName() + " not found (null). Recompile complete solution? ");
        }
        return pane;
    }

    private void setupNewInitializedGenPagePane() {
        if (this.currentPagePaneSelCrtl != null) {
            this.currentPagePaneSelCrtl.gcClear();
        }
        this.currentPagePaneSelCrtl = new PagePaneSelCrtl(this, this.uiFactory.getPlatform(), this.currentGenPagePane, this.currentGenPagePane.getPagePaneType(), this.langIndex);
        this.currentGenPagePane.initializeGenPagePane(this.currentPagePaneSelCrtl, this.uiFactory);
        if (this.command.getCommandSession().isReadOnly()) {
            this.currentPagePaneSelCrtl.forceNotEditable();
        }
        if (this.currentPageTitle != null && !this.currentPageTitle.trim().equals("")) {
            this.currentGenPagePane.setHeading(this.currentPageTitle);
        }
        if (ListSequence.fromList(this.currentProblems).count() > 0) {
            this.configureProblemsWithAResolveAction(this.currentProblems);
            this.currentGenPagePane.setProblems(this.currentProblems);
            this.receiveAndProcess(new FlagOnUiEvent(this.currentProblems));
            this.currentProblems = ListSequence.fromList(new ArrayList());
        }
        this.currentConclusions = Arrays.asList(this.command.getCurrentPageConclusions((IOFXSelProvider)this.currentGenPagePane));
        this.currentConclusionInfos = new ArrayList<OFXConclusionInformation>();
        OFXConclusionInformation escInfo = this.currentConclusions.size() == 0 || this.isDocumentSearch() ? new OFXConclusionInformation(0, this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.CLOSE_BUTTON), ESC_CONCLUSION_ICON_NAME, "ESC", false) : new OFXConclusionInformation(0, this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.ESC_BUTTON), ESC_CONCLUSION_ICON_NAME, "ESC", false);
        escInfo.enabled = !this.command.hasOption(IOFXCommand.OFXCmdOptions.NO_ESC);
        this.currentConclusionInfos.add(escInfo);
        for (int i = 0; i < this.currentConclusions.size(); ++i) {
            IOFXPage.IOFXPageConclusion curCon = this.currentConclusions.get(i);
            String buttonText = this.uiFactory.getTransProvider().translateSingle(this.langIndex, this.uiFactory.getPlatform().getTextForLabel(curCon.getLabelName()));
            OFXConclusionInformation info = new OFXConclusionInformation(curCon.hashCode(), buttonText, this.uiFactory.getPlatform().getIconForLabel(curCon.getLabelName()), this.uiFactory.getPlatform().getHotKeyForLabel(curCon.getLabelName()), this.uiFactory.getPlatform().isHideOnDisabledForLabel(curCon.getLabelName()));
            this.currentConclusionInfos.add(info);
        }
        this.commandUI.setConclusions(this.currentConclusionInfos, this.currentPagePaneSelCrtl.getGlobalHotkeys());
    }

    private void setupNewPageWithoutUI() {
        if (this.currentPagePaneSelCrtl != null) {
            this.currentPagePaneSelCrtl.gcClear();
        }
        this.currentPagePaneSelCrtl = new PagePaneSelCrtl(this, this.uiFactory.getPlatform(), null, ListSequence.fromList(this.currentBoundObjects).getElement(0).getClass(), this.langIndex);
        if (this.command.getCommandSession().isReadOnly()) {
            this.currentPagePaneSelCrtl.forceNotEditable();
        }
        this.currentConclusions = Arrays.asList(this.command.getCurrentPageConclusions((IOFXSelProvider)this.currentGenPagePane));
        this.currentConclusionInfos = new ArrayList<OFXConclusionInformation>();
        OFXConclusionInformation escInfo = new OFXConclusionInformation(0, this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.ESC_BUTTON), ESC_CONCLUSION_ICON_NAME, "ESC", false);
        escInfo.enabled = !this.command.hasOption(IOFXCommand.OFXCmdOptions.NO_ESC);
        this.currentConclusionInfos.add(escInfo);
        for (int i = 0; i < this.currentConclusions.size(); ++i) {
            IOFXPage.IOFXPageConclusion curCon = this.currentConclusions.get(i);
            String buttonText = this.uiFactory.getTransProvider().translateSingle(this.langIndex, this.uiFactory.getPlatform().getTextForLabel(curCon.getLabelName()));
            OFXConclusionInformation info = new OFXConclusionInformation(curCon.hashCode(), buttonText, this.uiFactory.getPlatform().getIconForLabel(curCon.getLabelName()), this.uiFactory.getPlatform().getHotKeyForLabel(curCon.getLabelName()), true);
            this.currentConclusionInfos.add(info);
        }
    }

    protected void fg_reevalConclusions() {
        boolean scanConclusionPresent = false;
        for (int i = 0; i < this.currentConclusions.size(); ++i) {
            this.currentConclusionInfos.get((int)(i + 1)).enabled = this.currentConclusions.get(i).isEnabled();
            if (!"UPD".equals(this.currentConclusionInfos.get((int)(i + 1)).hotkey)) continue;
            scanConclusionPresent = true;
        }
        if (this.getSession().isLockedByOtherUser()) {
            this.currentConclusionInfos.get((int)0).enabled = true;
        }
        if (!this.isAutoConNoUi()) {
            this.commandUI.reevalConclusions(this.currentConclusionInfos);
        }
        this.app.reevalEnabledInMenusAndTiles();
    }

    protected void fg_requestFocusAndFinalAfterEventOnCurrentForm(boolean bringTabToForeGround) {
        if (bringTabToForeGround) {
            this.windowCrtl.focusTab(this, this.commandUI);
        }
        if (this.uiFactory.getReloadOnTabChange()) {
            this.currentPagePaneSelCrtl.reloadViews();
        }
        this.commandUI.delayedRequestFocus();
        this.currentPagePaneSelCrtl.preDelayedAfterFullUiInitialized();
        this.commandUI.delayedAfterFullUiInitialized();
    }

    protected void fg_openUserInterface() throws Exception {
        boolean successorCanUseUiFromPredecessor;
        boolean bl = successorCanUseUiFromPredecessor = this.isSuccessor() && this.commandUI != null;
        if (!this.isAutoConNoUi()) {
            this.currentGenPagePane = this.instantiateNewGenPagePane();
            if (!successorCanUseUiFromPredecessor) {
                if (this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD})) {
                    boolean fullSize = this.command.wizzardWithFullSizeUis() || this.currentGenPagePane.pageNeedsMaxAvailableSpace();
                    this.commandUI = this.uiFactory.createPromptContainerUi(this.app.getMainWindowImpl(), fullSize);
                } else {
                    this.commandUI = this.uiFactory.createTabContainerUi(this.app.getMainWindowImpl(), this.commandRequestedModalTab);
                }
            }
            this.commandUI.setCommandContainer(this);
            if (this.currentLockingMessage != null && !this.currentLockingMessage.equals("")) {
                this.commandUI.setNotification(this.currentLockingMessage);
            }
            this.setupNewInitializedGenPagePane();
            if (successorCanUseUiFromPredecessor) {
                IToolkit_Form frm = this.currentGenPagePane.getPagePaneToolkitImpl();
                frm.rootForm();
                this.commandUI.setContent(frm);
                if (this.command.getWindowTitleType() == IOFXCommand.OFXWindowTitleType.FORCE_OVERWRITE) {
                    this.commandUI.adjustWindowTitle(this.windowTitle);
                }
            } else {
                if (this.adjustedUrl != null) {
                    this.commandUI.setAdjustUrl(this.adjustedUrl);
                }
                this.windowCrtl.showCommandContainerUI(this, this.commandUI, this.windowTitle, this.currentGenPagePane.getPagePaneToolkitImpl());
            }
        } else {
            this.setupNewPageWithoutUI();
        }
        this.currentPagePaneSelCrtl.addLoadedListReference(this.currentBoundObjects);
        if (!this.isAutoConNoUi()) {
            this.selRecorder.transferSelections(this.currentPagePaneSelCrtl);
            String color = this.currentGenPagePane.calcUiColor(this.currentPagePaneSelCrtl.getSelection(this.currentGenPagePane.getPagePaneType(), false).getObjectOrNull());
            if (color != null) {
                this.currentUIColor = color;
            }
            if (this.currentUIColor != null) {
                this.commandUI.setColor(this.currentUIColor);
            }
            this.fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
        }
    }

    protected void fg_ensureTerminatedAndCloseContainer(Exception x) {
        try {
            if (this.containerClosed) {
                this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "CommandContainer.fg_ensureTerminatedExceptionConclusionAndCloseContainer() container already closed, but closing requested with ex.", OFXConsoleHelper.stackTrace2String((Throwable)x));
                return;
            }
            if (!this.command.isTerminatedCancel()) {
                this.command.doFinalCancelConclusion(null, x);
            }
            this.fg_closeUiAndContainer(x instanceof OFXShutDownSessionException);
        }
        catch (Throwable t) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "CommandContainer.fg_ensureTerminatedExceptionConclusionAndCloseContainer() Ex while closing command.", OFXConsoleHelper.stackTrace2String((Throwable)t));
        }
    }

    protected void fg_cancelAndClose(boolean userCancelRequested, List<IOFXProblem> problems) {
        if (this.containerClosed) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "CommandContainer.fg_cancelAndClose() requested, but container already closed. (user_cancel " + userCancelRequested + " / " + problems + ")", OFXConsoleHelper._____organizeCurrentStacktrace_____());
            return;
        }
        try {
            if (userCancelRequested) {
                this.command.doFinalUserCancelConclusion();
            } else if (!this.command.isTerminatedCancel()) {
                this.command.doFinalCancelConclusion(problems, null);
            }
        }
        catch (Exception ex) {
            this.app.logAppProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", ex, "CommandContainer.fg_cancelAndClose() ex in cmd while closing. (user_cancel " + userCancelRequested + " / " + problems + ")");
        }
        try {
            this.fg_closeUiAndContainer(false);
        }
        catch (Exception ex) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", ex, "CommandContainer.fg_cancelAndClose() frmwrk ex in fg_closeUiAndContainer(false). (user_cancel " + userCancelRequested + " / " + problems + ")");
            this.ebLockingActive = false;
            this.ebLocksHold = ListSequence.fromList(new ArrayList());
        }
    }

    protected void fg_doConclusion(int ccHash) throws Exception {
        boolean wasDynamicUpdateConclusion;
        boolean bl = wasDynamicUpdateConclusion = ccHash == 1;
        if (this.containerClosed) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "CommandContainer.fg_doConclusion() hash " + ccHash + " but container already closed!", OFXConsoleHelper._____organizeCurrentStacktrace_____());
            return;
        }
        if (this.app.checkForAppParDeploymentForward()) {
            return;
        }
        if (ccHash == 0) {
            if (this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD, IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL}) && this.command.getCommandSession().isDirty() && !this.command.isCurrentlyReadOnlySession() && !this.isAutoConNoUi()) {
                this.receiveAndProcess(new CancelAndClose());
                return;
            }
            this.receiveAndProcess(new CancelAndCloseImmediately(true, "USER_CANCEL"));
            return;
        }
        if (ccHash == 1) {
            for (OFXConclusionInformation info : this.currentConclusionInfos) {
                if (!"UPD".equals(info.hotkey)) continue;
                ccHash = info.conclusionHashCode;
                break;
            }
        }
        IOFXPage.IOFXPageConclusion conclusionToExecute = null;
        for (IOFXPage.IOFXPageConclusion c : this.currentConclusions) {
            if (c.hashCode() != ccHash) continue;
            conclusionToExecute = c;
            break;
        }
        if (conclusionToExecute == null) {
            throw new RuntimeException("TEC Problem: conclusion ccHash " + ccHash + " not found in " + this.currentConclusions + " (contclsd? " + this.containerClosed + ")");
        }
        if (!conclusionToExecute.isEnabled() && this.getSession().isLockedByOtherUser()) {
            String msg = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.LOCK_NOT_GOT_CANCEL), this.getSession().getLockedByUser());
            List problems = this.getSession().getAndclearProblemState();
            ListSequence.fromList((List)problems).addElement((Object)new OFXProblem(msg, null, null, new IOFXProblem.Opt[0]));
            this.receiveAndProcess(new CancelAndClose(problems));
            return;
        }
        if (!conclusionToExecute.isEnabled()) {
            throw new RuntimeException("Conclusion " + conclusionToExecute.getLabelName() + " not enabled!");
        }
        boolean canSaveOnForms = true;
        boolean changePageRequestedInConclusion = false;
        try {
            if (!this.isAutoConNoUi()) {
                this.currentGenPagePane.setProblems((List<IOFXProblem>)ListSequence.fromList(new ArrayList()));
            }
            if (conclusionToExecute.needsSave()) {
                String errText = this.currentPagePaneSelCrtl.issueSaveAndValidate();
                boolean bl2 = canSaveOnForms = errText == null;
                if (!canSaveOnForms) {
                    if (this.uiFactory.flagValidationAdditionally()) {
                        this.currentGenPagePane.setProblems((List<IOFXProblem>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new IOFXProblem[]{new OFXProblem(errText, "", null, new IOFXProblem.Opt[0])}));
                    } else {
                        this.currentGenPagePane.setProblems((List<IOFXProblem>)ListSequence.fromListAndArray(new ArrayList(), (Object[])new IOFXProblem[]{new OFXProblem("", "", null, new IOFXProblem.Opt[0])}));
                    }
                } else {
                    List<IDelegateChange> changes = this.currentPagePaneSelCrtl.collectDelegateChanges();
                    if (changes != null) {
                        this.reportDelegateChanges(changes);
                    }
                }
            }
            if (canSaveOnForms) {
                this.command.execConclusion(conclusionToExecute);
            }
            if (this.command.hasSuccessorCommand() && this.command.isReadyForSuccessor()) {
                this.prepareSuccessorExecution();
                return;
            }
            if (this.command.isTerminatedOk() || this.command.isTerminatedCancel()) {
                this.receiveAndProcess(new CloseCntrCmdTermedEvent("Term in page conclusion"));
                return;
            }
        }
        catch (OFXAbortedException ex) {
            List problems = this.getSession().getAndclearProblemState();
            if (this.isAutoConNoUi() || this.command.isTerminatedOk() || this.command.isTerminatedCancel()) {
                this.receiveAndProcess(new CancelAndClose(problems));
                return;
            }
            this.currentPagePaneSelCrtl.reloadViews();
            this.configureProblemsWithAResolveAction(problems);
            this.currentGenPagePane.setProblems(problems);
            this.currentProblems = ListSequence.fromList(new ArrayList());
            this.fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
            this.receiveAndProcess(new FlagOnUiEvent(problems));
            return;
        }
        catch (OFXChangePageException ex) {
            changePageRequestedInConclusion = true;
        }
        if (changePageRequestedInConclusion) {
            boolean inBackground = this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.SEARCH_CMD}) && this.uiFactory.useBackgroundThread() && !wasDynamicUpdateConclusion;
            this.receiveAndProcess(new InitPageAfterCon(inBackground));
        } else if (!this.isAutoConNoUi() && canSaveOnForms) {
            this.currentPagePaneSelCrtl.reloadViews();
            this.fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
        }
    }

    public void bg_fg_initPage() {
        boolean onlyAReload = this.currentPageIndex == this.command.getCurrentPageIndex();
        this.currentPageIndex = this.command.getCurrentPageIndex();
        if (this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.SEARCH_CMD})) {
            this.command.getCommandSession().clearAllKeystores();
        }
        long startTime = System.currentTimeMillis();
        try {
            this.selRecorder.clear();
            this.currentBoundObjects = this.command.initCurrentPage((IOFXSelProvider)this.selRecorder);
            List sessionProblems = this.getSession().getAndclearProblemState();
            if (ListSequence.fromList(this.currentProblems).count() > 0) {
                ListSequence.fromList(this.currentProblems).addSequence((ISequence)ListSequence.fromList((List)sessionProblems));
            } else {
                this.currentProblems = sessionProblems;
            }
            this.currentPageTitle = this.command.calcCurrentPageDynamicTitleAndScopes();
        }
        catch (OFXAbortedException ex) {
            List problems = this.getSession().getAndclearProblemState();
            if (this.isAutoConNoUi()) {
                this.receiveAndProcess(new CancelAndClose(problems));
                return;
            }
            this.currentBoundObjects = ListSequence.fromList(new ArrayList());
            ListSequence.fromList(this.currentProblems).addSequence((ISequence)ListSequence.fromList((List)problems));
        }
        catch (Exception ex) {
            this.receiveAndProcess(new CloseCntrExInfoEvent(ex));
            return;
        }
        this.receiveAndProcess(new SetupUiAftrPageInit(onlyAReload, startTime));
    }

    public void fg_setupUiAfterPageInit(SetupUiAftrPageInit uEvent) {
        boolean onlyAReload = uEvent.isReloadOnly();
        if (!onlyAReload) {
            this.currentGenPagePane = this.instantiateNewGenPagePane();
            this.setupNewInitializedGenPagePane();
            IToolkit_Form frm = this.currentGenPagePane.getPagePaneToolkitImpl();
            frm.rootForm();
            this.commandUI.setContent(frm);
        } else {
            if (this.currentPageTitle != null && !this.currentPageTitle.trim().equals("")) {
                this.currentGenPagePane.setHeading(this.currentPageTitle);
            }
            if (ListSequence.fromList(this.currentProblems).count() > 0) {
                this.configureProblemsWithAResolveAction(this.currentProblems);
                this.currentGenPagePane.setProblems(this.currentProblems);
                this.receiveAndProcess(new FlagOnUiEvent(this.currentProblems));
                this.currentProblems = ListSequence.fromList(new ArrayList());
            }
            this.command.getCurrentPageConclusions((IOFXSelProvider)this.currentGenPagePane);
        }
        this.currentPagePaneSelCrtl.addLoadedListReference(this.currentBoundObjects);
        this.selRecorder.transferSelections(this.currentPagePaneSelCrtl);
        this.fg_requestFocusAndFinalAfterEventOnCurrentForm(false);
    }

    public void fg_pushSelectionNoReloadView(Object objectToSelect) {
        IOFXSelection possibleSelection = Selection.convertObject2Selection((Object)objectToSelect);
        this.currentPagePaneSelCrtl.updateSelectionExchangeRootObjects(possibleSelection, this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.SEARCH_CMD}));
    }

    public boolean fg_handleGlobalCmdTerminate(GlobalCmdTermEvent ev, String compoundGOConc) throws Exception {
        if (this.command == null || this.containerClosed) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "fg_handleGlobalCmdTerminate() command is null - due to printing? [NPE predecessor=" + this.predecessorCommand + " closed=" + this.containerClosed + "]", null);
            return true;
        }
        if (this.parentCommandContainer == ev.getClosedContainer()) {
            this.parentCommandContainer = null;
            if (this.isGraphEdit()) {
                this.receiveAndProcess(new CancelAndCloseImmediately(false, "Graph owner of this graph edit was killed. canceling this ge."));
            }
            return true;
        }
        if (ev.iAmParent(this) && ev.killParentGO() && !this.isAutoConNoUi()) {
            this.receiveAndProcess(new CancelAndCloseImmediately(false, "GUARD in graphedit " + this.fullCmdNameAndSuccessor));
            return true;
        }
        if (!this.command.hasOption(IOFXCommand.OFXCmdOptions.NEW_STYLE_TERM_HANDLING) && ev.iAmParent(this)) {
            for (Object obj : ev.getCmdSelections()) {
                this.fg_pushSelectionNoReloadView(obj);
            }
        }
        if ((IOFXCommand.OFXTermHandlerType.NoOrChildHandler((IOFXCommand.OFXTermHandlerType)this.command.getCmdTermHandlerType()) && ev.iAmParent(this) || IOFXCommand.OFXTermHandlerType.ALSO_ANY_CMD_TERM.equals((Object)this.command.getCmdTermHandlerType())) && !this.isAutoConNoUi()) {
            this.currentGenPagePane.setProblems((List<IOFXProblem>)ListSequence.fromList(new ArrayList()));
        }
        if (IOFXCommand.OFXTermHandlerType.CHILD_CMD_TERM_ONLY.equals((Object)this.command.getCmdTermHandlerType()) && ev.iAmParent(this) || IOFXCommand.OFXTermHandlerType.ALSO_ANY_CMD_TERM.equals((Object)this.command.getCmdTermHandlerType())) {
            try {
                this.selRecorder.clear();
                this.command.handleCmdTermAndClearGeFqName(ev.iAmParent(this), ev.wasOk(), ev.getCmdSelections(), (IOFXSelProvider)this.selRecorder);
            }
            catch (OFXAbortedException ex) {
                this.isStillOkayAsParentForMultiExecution = false;
                List problems = this.getSession().getAndclearProblemState();
                if (this.isAutoConNoUi()) {
                    this.receiveAndProcess(new CancelAndClose(problems));
                } else {
                    this.configureProblemsWithAResolveAction(problems);
                    this.currentGenPagePane.setProblems(problems);
                    this.currentProblems = ListSequence.fromList(new ArrayList());
                    if (!ev.isNoReloadOnParent()) {
                        this.currentPagePaneSelCrtl.reloadViews();
                        this.selRecorder.transferSelections(this.currentPagePaneSelCrtl);
                    }
                    this.receiveAndProcess(new FlagOnUiEvent(problems));
                }
                return true;
            }
            catch (Exception e) {
                this.isStillOkayAsParentForMultiExecution = false;
                this.receiveAndProcess(new CloseCntrExInfoEvent(e));
                return true;
            }
        }
        if ((ev.iAmParent(this) || IOFXCommand.OFXTermHandlerType.ALSO_ANY_CMD_TERM.equals((Object)this.command.getCmdTermHandlerType())) && !ev.isNoReloadOnParent() && !this.isAutoConNoUi()) {
            this.currentPageTitle = this.command.calcCurrentPageDynamicTitleAndScopes();
            if (this.currentPageTitle != null && !this.currentPageTitle.trim().equals("")) {
                this.currentGenPagePane.setHeading(this.currentPageTitle);
            }
            this.currentPagePaneSelCrtl.reloadViews();
            this.selRecorder.transferSelections(this.currentPagePaneSelCrtl);
        }
        if (ev.iAmParent(this) && this.isAutoConNoUi()) {
            if (compoundGOConc == null) {
                throw new IllegalStateException("AutoConc of GO " + this.fullCmdNameAndSuccessor + " is null.");
            }
            if (ev.wasOk()) {
                int conclusionHash = this.getConclusionHashFromName(compoundGOConc);
                this.receiveAndProcess(new ConclusionEvent(conclusionHash, "AutoCon"));
                return true;
            }
            this.receiveAndProcess(new CancelAndCloseImmediately(false, "auto conclusion no ui - child not termed final_ok"));
            return true;
        }
        return false;
    }

    public void fg_closeUiAndContainer(boolean sessionShutdownByGuard) {
        this.containerClosed = true;
        this.isStillOkayAsParentForMultiExecution = false;
        this.containerClosedTimestamp = System.currentTimeMillis();
        try {
            if (this.ebLockingActive) {
                this.getUiFactory().getEventBus().unregister((ConsumerHandler)this, "locking");
            }
        }
        catch (Throwable t) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "Ex while unregistering locking", OFXConsoleHelper.stackTrace2String((Throwable)t));
        }
        finally {
            this.ebLocksHold = null;
            this.ebLockingActive = false;
        }
        Object selectionsToForward = ListSequence.fromList(new ArrayList());
        if (this.command == null) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "Command is null here (MoWare Bug) - this can not be true", OFXConsoleHelper._____organizeCurrentStacktrace_____());
            return;
        }
        if (this.command.isTerminatedOk()) {
            Object cmdOkMsg;
            this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", "command closed FINAL_OK", "", null);
            if (!this.isSuccessor()) {
                cmdOkMsg = this.command.getTerminateOkInformation();
                selectionsToForward = this.command.getTerminateOkSelections();
            } else {
                cmdOkMsg = this.predecessorCommand.getTerminateOkInformation();
                selectionsToForward = this.predecessorCommand.getTerminateOkSelections();
                if (ListSequence.fromList((List)selectionsToForward).count() == 0 && ListSequence.fromList((List)(selectionsToForward = this.command.getTerminateOkSelections())).count() > 0) {
                    String successorMsg = this.command.getTerminateOkInformation();
                    if (cmdOkMsg != null && successorMsg != null) {
                        cmdOkMsg = successorMsg + " - " + (String)cmdOkMsg;
                    } else if (successorMsg != null) {
                        cmdOkMsg = successorMsg;
                    }
                }
            }
            boolean hasProblemOtherThenWarnings = this.getSession().hasProblemsOtherThanWarnings();
            List remainingProblems = this.getSession().getAndclearProblemState();
            if (ListSequence.fromList((List)remainingProblems).count() > 0) {
                if (hasProblemOtherThenWarnings) {
                    throw new RuntimeException("Command " + this.fullCmdNameAndSuccessor + "  has remaining problems but is terminatedOk.\n" + FlagOnUiEvent.asSimpleString(remainingProblems));
                }
                if (cmdOkMsg != null) {
                    ListSequence.fromList((List)remainingProblems).addElement((Object)new OFXProblem("\n" + (String)cmdOkMsg, null, null, new IOFXProblem.Opt[]{IOFXProblem.Opt.WARNING_HINT}));
                }
                this.windowCrtl.showProblemsDialog(remainingProblems, null);
            } else if (cmdOkMsg != null) {
                this.windowCrtl.setToastInformation((String)cmdOkMsg);
            }
        } else if (this.command.isTerminatedCancel()) {
            this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", "command closed FINAL_CANCEL", "", null);
            selectionsToForward = !this.isSuccessor() ? this.command.getTerminateCancelSelections() : this.predecessorCommand.getTerminateCancelSelections();
        } else if (this.command.isUserCancelTerminated()) {
            this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", "command closed FINAL_USER_CANCEL", "", null);
        } else {
            throw new RuntimeException("Command container close requested (not a forced shutdown), but command not terminated in ok, cancel or user cancel. cmd=" + this.fullCmdNameAndSuccessor);
        }
        try {
            if (!this.isAutoConNoUi()) {
                this.windowCrtl.closeCommandContainerUI(this, this.commandUI, this.parentCommandContainer);
            }
        }
        catch (Exception ex) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "CommandContainer.fg_closeUiAndContainer(): Apcrtl excpt isolated on excpt shutdown.", OFXConsoleHelper.stackTrace2String((Throwable)ex));
        }
        if (this.currentPagePaneSelCrtl != null) {
            this.currentPagePaneSelCrtl.gcClear();
        }
        this.currentPagePaneSelCrtl = null;
        this.currentGenPagePane = null;
        this.app.getAppTelemetrics().decCommand();
        boolean killParentGo = sessionShutdownByGuard && this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD});
        GlobalCmdTermEvent commandTermEvent = new GlobalCmdTermEvent(this, this.parentCommandContainer, killParentGo, this.command.isTerminatedOk(), this.command.isUserCancelTerminated(), this.command.isTerminatedCancel(), (List<Object>)selectionsToForward);
        this.commandUI = null;
        this.cmdParams = null;
        IOFXSession.IUxEvent registeredEvent = null;
        if (this.command.isTerminatedOk()) {
            registeredEvent = this.getSession().getRegisteredUxEvent();
        }
        this.command = null;
        this.currentConclusions = null;
        this.currentConclusionInfos = null;
        this.windowCrtl.commandClosed(commandTermEvent);
        if (registeredEvent != null) {
            this.windowCrtl.receiveAndProcess((UxEvent)registeredEvent);
        }
        this.parentCommandContainer = null;
        this.predecessorCommand = null;
        this.predecessorCmdParams = null;
    }

    private String calcDisabledReasonText(OFXCommandDisabledReason reason, String labelText) {
        String msg = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.CMD_NOT_ENABLED), labelText);
        if (reason != null) {
            if (reason.getReasonType() == OFXCommandDisabledReason.ReasonType.WRONG_STATE) {
                msg = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.INNER_CMD_WRONG_STATE), labelText, reason.getFurtherDesc());
            } else if (reason.getReasonType() == OFXCommandDisabledReason.ReasonType.NO_PERMISSION) {
                msg = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.INNER_CMD_NO_PERM), labelText);
            }
        }
        return msg;
    }

    public void fg_startCompoundInnerCommand(CompoundOuterCmdStart outerCompound) {
        IOFXCmdModule procOfInner;
        boolean enabled;
        IOFXDynCmdParams paramProvider = outerCompound.getInnerUriParamProv();
        Object[] paramsForInner = paramProvider != null ? paramProvider.calc((IOFXSelcrtlBasics)this.currentPagePaneSelCrtl, null) : this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)outerCompound.getInnerGeCmd())).getCommandDefaultParams(outerCompound.getInnerGeCmd(), (IOFXSelcrtlBasics)this.currentPagePaneSelCrtl, null);
        BasisCmdStart innerCmdEvent = new BasisCmdStart(outerCompound.getInnerGeCmd(), paramsForInner);
        if (outerCompound.getInnerGeAutoCon() != null) {
            innerCmdEvent.setAutoConclusion(outerCompound.getInnerGeAutoCon());
        }
        boolean bl = enabled = (procOfInner = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)innerCmdEvent.getCommandName()))).getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, innerCmdEvent.getCommandName(), paramsForInner, this.getSession()) != IOFXCmdModule.CommandPermission.DISABLED;
        if (!enabled) {
            OFXCommandDisabledReason reason = new OFXCommandDisabledReason(OFXCommandDisabledReason.ReasonType.COMPLEX_CONDITION, "Bedingung nicht erf\u00fcllt");
            String msg = this.calcDisabledReasonText(reason, !"".equals(outerCompound.getLabelText()) ? outerCompound.getLabelText() : MoVersion.getShortNameFromFQ((String)innerCmdEvent.getCommandName()));
            List problems = this.getSession().getAndclearProblemState();
            ListSequence.fromList((List)problems).addElement((Object)new OFXProblem(msg, null, null, new IOFXProblem.Opt[0]));
            this.receiveAndProcess(new CancelAndClose(problems));
        } else {
            this.receiveAndProcess(innerCmdEvent);
        }
    }

    public int getConclusionHashFromName(String autoConclusionName) throws Exception {
        Integer conclusionHash = null;
        if ("OFX_USER_CANCEL".equals(autoConclusionName)) {
            conclusionHash = 0;
        } else {
            for (int i = 0; i < this.currentConclusions.size(); ++i) {
                if (!this.currentConclusions.get(i).getName().equals(autoConclusionName)) continue;
                conclusionHash = this.currentConclusions.get(i).hashCode();
                break;
            }
            if (conclusionHash == null) {
                throw new RuntimeException("getConclusionHashByName '" + autoConclusionName + "' not found in " + this.command.getCommandFqName() + "\n available " + this.currentConclusions);
            }
        }
        return conclusionHash;
    }

    private void prepareSuccessorExecution() {
        OFXSuccessorCommandConfig cfg = this.command.getSuccessorCommandConfig();
        IOFXCmdModule prc = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)cfg.getCmdName()));
        IOFXCmdModule.CommandPermission perm = prc.getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, cfg.getCmdName(), cfg.getParams(), this.getSession());
        if (perm == IOFXCmdModule.CommandPermission.DISABLED) {
            OFXCommandDisabledReason reason = new OFXCommandDisabledReason(OFXCommandDisabledReason.ReasonType.COMPLEX_CONDITION, "Bedingung nicht erf\u00fcllt.");
            String msg = this.calcDisabledReasonText(reason, MoVersion.getShortNameFromFQ((String)cfg.getCmdName()));
            List problems = this.getSession().getAndclearProblemState();
            ListSequence.fromList((List)problems).addElement((Object)new OFXProblem(msg, null, null, new IOFXProblem.Opt[0]));
            this.receiveAndProcess(new CancelAndClose(problems));
        } else if (this.uiFactory.getCheckAlsoPredecessorDuplication() && this.commandUI == null && this.app.isSameInstanceRunningThenFocus(cfg.getCmdName(), cfg.getParams())) {
            this.receiveAndProcess(new CancelAndCloseImmediately(false, "Successor already running"));
        } else {
            IOFXCommand cmd = prc.startCommand(IOFXCmdModule.CmdExecStrategy.INNER_NO_NEW_SESSION, cfg.getCmdName(), cfg.getParams(), this.getSession(), this.getSession().getUserEnvironment(), this.getSession().getUserServices());
            this.predecessorCommand = this.command;
            this.predecessorCmdParams = this.cmdParams;
            this.command = cmd;
            this.fullCmdNameAndSuccessor = this.getSession().getCurrentCmdName();
            this.command.manageAlsoPredecessor(this.predecessorCommand);
            this.receiveAndProcess(new InitCmdEvent(false, cmd, cfg.getParams()));
        }
    }

    protected Json createLockJson(String lockName, long reqTimeStamp, long reqId) {
        String userName = this.getSession().getUserEnvironment().getUserName();
        String deviceId = this.getSession().getUserEnvironment().getDeviceId();
        String deviceName = this.getSession().getUserEnvironment().getDeviceName();
        long appStartupTime = this.getSession().getUserEnvironment().getAppStartupLocalMillis();
        Json obj = Json.object().set("lockName", (Object)lockName).set("userName", (Object)userName).set("deviceName", (Object)deviceName).set("deviceId", (Object)deviceId).set("userInstanceName", (Object)this.lockingInstanceName()).set("requestTimestamp", (Object)this.ebLockRequestedTimestamp).set("containerHash", (Object)reqId).set("appStartup", (Object)appStartupTime);
        return obj;
    }

    protected String lockingInstanceName() {
        String userName = this.getSession().getUserEnvironment().getUserName();
        return userName + "__" + this.hashCode();
    }

    protected boolean isRelevantLock(String userInstanceName, String lockName) {
        if (userInstanceName.equals(this.lockingInstanceName())) {
            return false;
        }
        for (String tmp : lockName.split(",")) {
            String requestedLock = tmp.trim();
            if ("".equals(requestedLock) || !ListSequence.fromList(this.ebLocksHold).any(it -> it.equals(requestedLock))) continue;
            return true;
        }
        return false;
    }

    public void fg_showLockInfo(String byUsers) {
        if (!this.getSession().isLockedByOtherUser()) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "A showLockInfo() was issued, but session was not locked", "isLockedByOtherUser()=" + this.getSession().isLockedByOtherUser() + " / isReadOnly()=" + this.getSession().isReadOnly());
        } else {
            ListSequence.fromList(this.ebLocksHold).clear();
            this.uiFactory.getEventBus().unregister((ConsumerHandler)this, "locking");
            this.ebLockingActive = false;
            this.currentLockingMessage = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.LOCK_NOT_GOT_READONLY), byUsers);
            if (this.commandUI != null) {
                this.commandUI.setNotification(this.currentLockingMessage);
                this.receiveAndProcess(new ReevalEvent());
            }
        }
    }

    private boolean isEqualOnParam(Object param1, Object param2) {
        if (param1 == null || param2 == null) {
            return param1 == param2;
        }
        if (param1 instanceof IOFXEntity || param2 instanceof IOFXEntity) {
            if (!(param1 instanceof IOFXEntity) || !(param2 instanceof IOFXEntity)) {
                return false;
            }
            if (OFXKeyReference.isNullKey((Object)((IOFXEntity)param1).getIM3Key()) && OFXKeyReference.isNullKey((Object)((IOFXEntity)param2).getIM3Key())) {
                return false;
            }
            return this.isEqualOnParam(((IOFXEntity)param1).getIM3Key(), ((IOFXEntity)param2).getIM3Key());
        }
        return param1.equals(param2);
    }

    private boolean checkCmdInstance(IOFXCommand iam, Object[] myParams, String fqName, Object[] params) {
        if (!iam.getCommandFqName().equals(fqName)) {
            return false;
        }
        if (myParams.length != params.length) {
            return false;
        }
        for (int i = 0; i < myParams.length; ++i) {
            if (this.isEqualOnParam(myParams[i], params[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSameCommandInstance(String fqName, Object[] params) {
        if (this.predecessorCommand != null && this.uiFactory.getCheckAlsoPredecessorDuplication()) {
            return this.checkCmdInstance(this.predecessorCommand, this.predecessorCmdParams, fqName, params) || this.checkCmdInstance(this.command, this.cmdParams, fqName, params);
        }
        return this.checkCmdInstance(this.command, this.cmdParams, fqName, params);
    }

    @Override
    public boolean hasRwSessionToCommit() {
        boolean hasSessionToCommit = (this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD}) || this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL})) && !this.command.isCurrentlyReadOnlySession();
        return hasSessionToCommit;
    }

    public boolean isGraphEdit() {
        return this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD});
    }

    @Override
    public boolean isReadOnly() {
        return this.command.isCurrentlyReadOnlySession();
    }

    @Override
    public boolean isDocumentSearch() {
        return this.command.isCommandType(new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.SEARCH_CMD});
    }

    @Override
    public IOFXSelection getSelectionAbsoluteFromCurrentPagePane(Class cls, boolean includingDerived) {
        return this.currentPagePaneSelCrtl.getSelectionAbsolute(cls, includingDerived);
    }

    @Override
    public IToolkit_UiFactory getUiFactory() {
        return this.uiFactory;
    }

    @Override
    public IOFXSession getSession() {
        return this.command.getCommandSession();
    }

    public String toString() {
        return this.fullCmdNameAndSuccessor;
    }

    @Override
    public boolean isStillOkayAsParentForMultiExecution() {
        return this.isStillOkayAsParentForMultiExecution;
    }

    public String dumpCmdContainerState() {
        String s = "**** CommandContainer for " + this.fullCmdNameAndSuccessor + ", closed=" + this.containerClosed + "\n";
        s = s + "**** autoconclusionMode_NoUI=" + this.autoConclusionMode_NoUi + " isSuccesorNor" + this.isSuccessor();
        s = s + "**** predecessor=" + this.predecessorCommand;
        s = s + "**** parentCommand=" + this.parentCommandContainer;
        return s;
    }

    public void reportDelegateChanges(List<IDelegateChange> changes) {
        for (IDelegateChange chg : changes) {
            this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.DelegateChange", chg.getSource(), chg.getChange(), null);
        }
    }

    public void configureProblemsWithAResolveAction(List<IOFXProblem> prblms) {
        ListSequence.fromList(prblms).visitAll(it -> {
            BasisCmdStart bcs = (BasisCmdStart)it.getResolveActionOrNull();
            if (bcs != null) {
                bcs.setParent(this);
                IOFXCmdModule module = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)bcs.getCommandName()));
                IOFXTranslationProvider tranProvider = this.uiFactory.getTransProvider();
                IOFXPlatform platform = this.uiFactory.getPlatform();
                if (bcs.getLabelText() == null) {
                    String defaultLabel = module.getCommandDefaultLabel(bcs.getCommandName());
                    String labelText = tranProvider.translateSingle(this.getSession().getUserEnvironment().getLangIndex(), defaultLabel);
                    bcs.setLabelText(labelText);
                } else {
                    String labelText = tranProvider.translateSingle(this.getSession().getUserEnvironment().getLangIndex(), platform.getTextForLabel(bcs.getLabelText()));
                    bcs.setLabelText(labelText);
                }
            }
        });
    }
}

