/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import mjson.Json;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.CancelAndClose;
import org.modellwerkstatt.dataux.runtime.core.CancelAndCloseImmediately;
import org.modellwerkstatt.dataux.runtime.core.CircularEventStore;
import org.modellwerkstatt.dataux.runtime.core.CloseCntrCmdTermedEvent;
import org.modellwerkstatt.dataux.runtime.core.CloseCntrExInfoEvent;
import org.modellwerkstatt.dataux.runtime.core.CommandContainer;
import org.modellwerkstatt.dataux.runtime.core.CompoundOuterCmdStart;
import org.modellwerkstatt.dataux.runtime.core.ConclusionEvent;
import org.modellwerkstatt.dataux.runtime.core.FlagOnUiEvent;
import org.modellwerkstatt.dataux.runtime.core.FocusEvent;
import org.modellwerkstatt.dataux.runtime.core.GlobalCmdTermEvent;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.IWindowController;
import org.modellwerkstatt.dataux.runtime.core.InitCmdEvent;
import org.modellwerkstatt.dataux.runtime.core.InitPageAfterCon;
import org.modellwerkstatt.dataux.runtime.core.KeyEvent;
import org.modellwerkstatt.dataux.runtime.core.LockInfoEvent;
import org.modellwerkstatt.dataux.runtime.core.MultiCmdStart;
import org.modellwerkstatt.dataux.runtime.core.OpenUiEvent;
import org.modellwerkstatt.dataux.runtime.core.PushSelEvent;
import org.modellwerkstatt.dataux.runtime.core.ReevalEvent;
import org.modellwerkstatt.dataux.runtime.core.RunLater;
import org.modellwerkstatt.dataux.runtime.core.SetupUiAftrPageInit;
import org.modellwerkstatt.dataux.runtime.core.UxBgableEvent;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.javaxbus.Message;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;

public class EventCommandContainer
extends CommandContainer {
    public static DateTimeFormatter LOCK_DBG_TIME_FRMT = DateTimeFormat.forPattern((String)"EEE HH:mm:ss.SSS");
    private BlockingQueue<UxEvent> containerEventQueue;
    private CircularEventStore lastEvents;
    private boolean inLoop;
    private CompoundOuterCmdStart compoundCommand;
    private String singleAutoConclusion;
    private long lastBgEventStartTime;
    private UxBgableEvent lastBgEvent;
    private volatile boolean processingPossileNoShutdown;

    @Override
    public void initContainer(IToolkit_UiFactory fact, IApplication crtl, IWindowController win, ICommandContainer parent, BasisCmdStart cmdStart, String sessId) {
        super.initialize(fact, crtl, win, parent, cmdStart, sessId);
        this.compoundCommand = null;
        this.singleAutoConclusion = null;
        this.containerEventQueue = new LinkedBlockingQueue<UxEvent>(10);
        this.lastEvents = new CircularEventStore(15);
        this.inLoop = false;
        this.processingPossileNoShutdown = true;
        if (cmdStart instanceof CompoundOuterCmdStart) {
            this.compoundCommand = (CompoundOuterCmdStart)cmdStart;
            if (this.compoundCommand.onAutoConclusionOrNoUi()) {
                super.setAutoConclusionMode_NoUi();
            }
        } else if (cmdStart.onAutoConclusionOrNoUi()) {
            this.singleAutoConclusion = cmdStart.getAutoConclusion();
            super.setAutoConclusionMode_NoUi();
        }
        this.lastBgEventStartTime = 0L;
        this.lastBgEvent = null;
    }

    @Override
    public void receiveAndProcess(UxEvent message) {
        if (!this.processingPossileNoShutdown) {
            return;
        }
        if (message instanceof BasisCmdStart) {
            ((BasisCmdStart)message).setParent(this);
            this.windowCrtl.receiveAndProcess(message);
        } else if (message instanceof MultiCmdStart) {
            ((MultiCmdStart)message).setParent(this);
            this.windowCrtl.receiveAndProcess(message);
        } else {
            this.containerEventQueue.add(message);
            if (!this.inLoop && (this.app.getMainWindowImpl() == null || this.app.getMainWindowImpl().inUiThread())) {
                this.processPendingEvents();
            }
        }
    }

    @Override
    public void internal_immediatelyShutdown() {
        this.processingPossileNoShutdown = false;
        this.containerEventQueue.clear();
        this.containerEventQueue.add(new CancelAndCloseImmediately(true, "immediately shutdown app"));
        this.processPendingEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void processPendingEvents() {
        if (this.containerEventQueue.size() == 0) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.App", "processPendingEvents() in EventCommandContainer called without any events to process (or lock recv. while open ui)", null);
            return;
        }
        UxEvent ev = null;
        long evStartTime = 0L;
        boolean logEventAsMowareTrace = false;
        try {
            this.inLoop = true;
            while (this.containerEventQueue.size() > 0) {
                ev = this.containerEventQueue.take();
                logEventAsMowareTrace = true;
                evStartTime = System.currentTimeMillis();
                this.lastEvents.add(ev);
                if (this.lastBgEvent != null) {
                    this.logEvent(this.lastBgEvent, System.currentTimeMillis() - this.lastBgEventStartTime);
                    this.lastBgEvent = null;
                    this.lastBgEventStartTime = 0L;
                }
                if (ev instanceof InitCmdEvent) {
                    final InitCmdEvent initEvent = (InitCmdEvent)ev;
                    if (initEvent.inBackground()) {
                        this.app.getMainWindowImpl().execEventInBackground(this, new Runnable(){

                            @Override
                            public void run() {
                                EventCommandContainer.this.bg_fg_initContainer(initEvent);
                            }
                        });
                    } else {
                        this.bg_fg_initContainer(initEvent);
                    }
                } else if (ev instanceof OpenUiEvent) {
                    this.fg_openUserInterface();
                    if (this.compoundCommand != null && this.compoundCommand.hasInnerGe()) {
                        this.fg_startCompoundInnerCommand(this.compoundCommand);
                    } else if (this.compoundCommand != null && !this.compoundCommand.hasInnerGe()) {
                        int ccHash = this.getConclusionHashFromName(this.compoundCommand.getAutoConclusion());
                        this.receiveAndProcess(new ConclusionEvent(ccHash, "AutoCon"));
                    } else if (this.singleAutoConclusion != null) {
                        int ccHash = this.getConclusionHashFromName(this.singleAutoConclusion);
                        this.receiveAndProcess(new ConclusionEvent(ccHash, "AutoCon"));
                    }
                } else if (ev instanceof FocusEvent) {
                    logEventAsMowareTrace = false;
                    this.fg_requestFocusAndFinalAfterEventOnCurrentForm(((FocusEvent)ev).isBringTabToForeground());
                } else if (ev instanceof ReevalEvent) {
                    logEventAsMowareTrace = false;
                    this.fg_reevalConclusions();
                } else if (ev instanceof PushSelEvent) {
                    this.fg_pushSelectionNoReloadView(((PushSelEvent)ev).getSingleObjectToSelect());
                    this.currentPagePaneSelCrtl.reloadViews();
                } else if (ev instanceof KeyEvent) {
                    this.fg_conclusionKey((KeyEvent)ev);
                } else if (ev instanceof LockInfoEvent) {
                    this.fg_showLockInfo(((LockInfoEvent)ev).getByUser());
                } else if (ev instanceof InitPageAfterCon) {
                    UxEvent fopEscHit;
                    InitPageAfterCon ipac = (InitPageAfterCon)ev;
                    if (this.uiFactory.isFX8LegacyImpl() && (fopEscHit = (UxEvent)this.containerEventQueue.peek()) != null && fopEscHit instanceof CancelAndCloseImmediately && ((CancelAndCloseImmediately)fopEscHit).isUserCancel()) {
                        this.containerEventQueue.take();
                    }
                    if (ipac.inBackground()) {
                        this.app.getMainWindowImpl().execEventInBackground(this, new Runnable(){

                            @Override
                            public void run() {
                                EventCommandContainer.this.bg_fg_initPage();
                            }
                        });
                    } else {
                        this.bg_fg_initPage();
                    }
                } else if (ev instanceof SetupUiAftrPageInit) {
                    this.fg_setupUiAfterPageInit((SetupUiAftrPageInit)ev);
                } else if (ev instanceof ConclusionEvent) {
                    ConclusionEvent concEv = (ConclusionEvent)ev;
                    this.fg_doConclusion(concEv.getConclusionHash());
                } else if (ev instanceof CloseCntrCmdTermedEvent) {
                    this.fg_closeUiAndContainer(false);
                } else if (ev instanceof CloseCntrExInfoEvent) {
                    final CloseCntrExInfoEvent resultInfo = (CloseCntrExInfoEvent)ev;
                    this.windowCrtl.showException(this.fullCmdNameAndSuccessor, this.sessId, "CloseCntrExInfoEvent Exception", this.lastEvents.toString(), resultInfo.getException(), new IApplication.DlgRunnable(){

                        @Override
                        public void run(boolean confirmed) {
                            EventCommandContainer.this.fg_ensureTerminatedAndCloseContainer(resultInfo.getException());
                        }
                    });
                } else if (ev instanceof CancelAndCloseImmediately) {
                    if (!this.containerClosed) {
                        CancelAndCloseImmediately cce = (CancelAndCloseImmediately)ev;
                        List problems = this.getSession().getAndclearProblemState();
                        ListSequence.fromList((List)problems).addElement((Object)new OFXProblem(cce.getMessage(), null, null, new IOFXProblem.Opt[0]));
                        this.fg_cancelAndClose(cce.isUserCancel(), problems);
                    }
                } else if (ev instanceof CancelAndClose) {
                    CancelAndClose cc = (CancelAndClose)ev;
                    if (cc.isCloseQuestion()) {
                        this.windowCrtl.askCloseQuestionDialog(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.SESSION_DIRTY), new IApplication.DlgRunnable(){

                            @Override
                            public void run(boolean confirmed) {
                                if (confirmed) {
                                    EventCommandContainer.this.fg_cancelAndClose(true, null);
                                }
                            }
                        });
                    } else {
                        final List<IOFXProblem> prblms = ((CancelAndClose)ev).getProblems();
                        this.windowCrtl.showProblemsDialog(prblms, new IApplication.DlgRunnable(){

                            @Override
                            public void run(boolean confirmed) {
                                EventCommandContainer.this.fg_cancelAndClose(false, prblms);
                            }
                        });
                    }
                } else if (!(ev instanceof FlagOnUiEvent)) {
                    if (ev instanceof GlobalCmdTermEvent) {
                        GlobalCmdTermEvent gcte = (GlobalCmdTermEvent)ev;
                        logEventAsMowareTrace = this.fg_handleGlobalCmdTerminate(gcte, this.compoundCommand == null ? null : this.compoundCommand.getAutoConclusion());
                    } else if (ev instanceof RunLater) {
                        RunLater rl = (RunLater)ev;
                        rl.exec();
                    } else {
                        throw new RuntimeException("This can not happen. Unknown event " + ev);
                    }
                }
                if (ev instanceof UxBgableEvent) {
                    this.lastBgEventStartTime = evStartTime;
                    this.lastBgEvent = (UxBgableEvent)ev;
                    continue;
                }
                if (!logEventAsMowareTrace) continue;
                this.logEvent(ev, System.currentTimeMillis() - evStartTime);
            }
        }
        catch (Exception ex) {
            this.isStillOkayAsParentForMultiExecution = false;
            this.windowCrtl.showException(this.fullCmdNameAndSuccessor, this.sessId, "Exception while processing " + ev, this.lastEvents.toString(), ex, new IApplication.DlgRunnable(){

                @Override
                public void run(boolean confirmed) {
                    EventCommandContainer.this.fg_ensureTerminatedAndCloseContainer(ex);
                }
            });
        }
        finally {
            this.inLoop = false;
        }
    }

    public void logEvent(UxEvent ev, long diffTime) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("diff", diffTime);
        if (ev instanceof InitCmdEvent) {
            this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", "command initialized", ev.paramInfo(), params);
        } else if (ev instanceof OpenUiEvent) {
            params.put("param", ev.paramInfo());
            params.put("commitedMem", Runtime.getRuntime().totalMemory() / 0x100000L);
            this.app.logMowareTracing(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", ev.name(), params);
        } else if (ev instanceof FlagOnUiEvent) {
            FlagOnUiEvent fe = (FlagOnUiEvent)ev;
            if (ListSequence.fromList(fe.getMessage()).count() == 0) {
                throw new RuntimeException("this can not happen - flag on ui has 0 problems.");
            }
            for (int i = 0; i < ListSequence.fromList(fe.getMessage()).count(); ++i) {
                IOFXProblem prblm = (IOFXProblem)ListSequence.fromList(fe.getMessage()).getElement(i);
                HashMap<String, Object> copy = new HashMap<String, Object>(params);
                if (i > 0) {
                    copy.remove("diff");
                }
                CoreReporterInfo.takeOverParamsIfNotNull(copy, (Map)prblm.getPropMapOrNull());
                this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", "flag on ui (prblm " + (i + 1) + ")", prblm.getSimpleUserText(), copy);
            }
        } else if (ev instanceof ConclusionEvent) {
            this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", "conclusion", ev.paramInfo(), params);
        } else if (ev instanceof CancelAndClose && !((CancelAndClose)ev).isCloseQuestion()) {
            CancelAndClose ce = (CancelAndClose)ev;
            if (ListSequence.fromList(ce.getProblems()).count() == 0) {
                throw new RuntimeException("this can not happen - CancelAndClose has 0 problems.");
            }
            for (int i = 0; i < ListSequence.fromList(ce.getProblems()).count(); ++i) {
                IOFXProblem prblm = (IOFXProblem)ListSequence.fromList(ce.getProblems()).getElement(i);
                HashMap<String, Object> copy = new HashMap<String, Object>(params);
                if (i > 0) {
                    copy.remove("diff");
                }
                CoreReporterInfo.takeOverParamsIfNotNull(copy, (Map)prblm.getPropMapOrNull());
                this.app.logAppTrace(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", "close on ui (prblm " + (i + 1) + ")", prblm.getSimpleUserText(), copy);
            }
        } else {
            params.put("param", ev.paramInfo());
            this.app.logMowareTracing(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Event", ev.name(), params);
        }
    }

    public void handle(Message busMsg) {
        try {
            if (this.containerClosed) {
                long diff = System.currentTimeMillis() - this.containerClosedTimestamp;
                this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.EbHandler", "Rec. event '" + busMsg + "' althought container '" + this + "' closed " + diff + "ms ago.", null);
                return;
            }
            if (busMsg.isErrorMsg()) {
                this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.EbHandler", "EB BUS ERROR (from EB, but EB still running)", busMsg.getErrMessage() + " / " + busMsg.getErrFailureCode() + " / " + busMsg.getErrFailureType());
                return;
            }
            Json body = busMsg.getBodyAsMJson();
            if (!body.has("type")) {
                this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.EbHandler", "EB BUS ERROR (still running, received an unknown message with no type)", body.toString());
                return;
            }
            String type = body.at("type").asString();
            if ("requestLock".equals(type) || "locked".equals(type)) {
                long reqAppStartup;
                if (!this.ebLockingActive) {
                    this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.EbHandler", "EB BUS ERROR (cmd still running: ebLockingNotActive, but receiving bus msgs)", body.toString());
                    return;
                }
                String reqLockName = body.has("lockName") ? body.at("lockName").asString().toLowerCase() : "";
                String reqUserName = body.has("userName") ? body.at("userName").asString() : "";
                String reqDeviceName = body.has("deviceName") ? body.at("deviceName").asString() : "";
                String reqDeviceId = body.has("deviceId") ? body.at("deviceId").asString() : "";
                String reqUserInstanceName = body.has("userInstanceName") ? body.at("userInstanceName").asString() : "";
                long reqTimestamp = body.has("requestTimestamp") ? body.at("requestTimestamp").asLong() : 0L;
                long reqId = body.has("containerHash") ? body.at("containerHash").asLong() : 0L;
                long reqLockTimestamp = body.has("lockTimestamp") ? body.at("lockTimestamp").asLong() : 0L;
                long l = reqAppStartup = body.has("appStartup") ? body.at("appStartup").asLong() : 0L;
                if (this.isRelevantLock(reqUserInstanceName, reqLockName)) {
                    if ("requestLock".equals(type)) {
                        long timeStampMillis = System.currentTimeMillis();
                        long diff = timeStampMillis - this.ebLockRequestedTimestamp;
                        if (Math.abs(diff) > 43200000L) {
                            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Locking", "Receiving relevant 'requestLock' (from " + reqUserName + " / " + reqLockName + "). We have an old session? " + LOCK_DBG_TIME_FRMT.print(this.ebLockRequestedTimestamp), "Diff between ebLockRequest and now " + diff);
                        } else {
                            this.uiFactory.getEventBus().publish("locking", this.createLockJson(reqLockName, timeStampMillis, reqId).set("type", (Object)"locked").set("lockTimestamp", (Object)this.ebLockRequestedTimestamp));
                            HashMap<String, Object> paramsPayLoad = new HashMap<String, Object>();
                            paramsPayLoad.put("lockName", reqLockName);
                            paramsPayLoad.put("requestedBy", Json.object().set("userName", (Object)reqUserName).set("deviceName", (Object)reqDeviceName).set("deviceId", (Object)reqDeviceId));
                            IOFXUserEnvironment env = this.getSession().getUserEnvironment();
                            paramsPayLoad.put("heldBy", Json.object().set("userName", (Object)env.getUserName()).set("deviceName", (Object)env.getDeviceName()).set("deviceId", (Object)env.getDeviceId()));
                            this.app.logMowareTracing(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Locking", "sent lock not granted", paramsPayLoad);
                        }
                        long diffTime = timeStampMillis - reqTimestamp;
                        if (diffTime > 4000L) {
                            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Locking", "Receiving relevant 'requestLock' (from " + reqUserName + " / " + reqLockName + ") took more than four sec. - (clocks synced?)", "Diff between req. and now " + diffTime);
                        }
                    } else if ("locked".equals(type) && reqId == (long)this.hashCode()) {
                        long diffTime = System.currentTimeMillis() - this.ebLockRequestedTimestamp;
                        if (!this.getSession().isLockedByOtherUser()) {
                            String lockUserName = reqUserName + " " + reqDeviceName;
                            this.getSession().setLockedByOtherUser(lockUserName);
                            HashMap<String, Object> paramsPayLoad = new HashMap<String, Object>();
                            paramsPayLoad.put("lockName", reqLockName);
                            paramsPayLoad.put("heldBy", Json.object().set("userName", (Object)reqUserName).set("deviceName", (Object)reqDeviceName).set("deviceId", (Object)reqDeviceId));
                            IOFXUserEnvironment env = this.getSession().getUserEnvironment();
                            paramsPayLoad.put("requestedBy", Json.object().set("userName", (Object)env.getUserName()).set("deviceName", (Object)env.getDeviceName()).set("deviceId", (Object)env.getDeviceId()));
                            this.app.logMowareTracing(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Locking", "received lock not granted", paramsPayLoad);
                            if (this.uiFactory.useBackgroundThread()) {
                                this.app.getMainWindowImpl().execEventInForeground(this, new LockInfoEvent(lockUserName));
                            } else {
                                this.containerEventQueue.add(new LockInfoEvent(lockUserName));
                            }
                        } else {
                            this.app.logMowareTracing(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Locking", "Session already locked but received another lock not granted for " + reqLockName + " (held by " + reqUserName + " / " + reqDeviceId + ")", "lock hold since " + LOCK_DBG_TIME_FRMT.print(reqLockTimestamp) + " (appstart " + LOCK_DBG_TIME_FRMT.print((ReadableInstant)new DateTime(reqAppStartup)) + ") diffTime " + diffTime);
                        }
                    } else if ("locked".equals(type) && !this.getSession().isLockedByOtherUser()) {
                        long diffTime = System.currentTimeMillis() - reqTimestamp;
                        this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.Locking", "Received 'locked' for" + reqLockName + " (held by " + reqUserName + " / " + reqDeviceId + ") requested by " + reqId + " - but we are " + this.hashCode() + " (simultaneous open?)", "diff time request to now " + diffTime);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.app.logFrmwrkProblem(this.fullCmdNameAndSuccessor, this.sessId, "org.modellwerkstatt.EbHandler", t, "Processing EventBus messages");
        }
    }

    public void ll(String eventName, String desc, String repr) {
        if (eventName.toLowerCase().contains("focus") || eventName.toLowerCase().contains("reeval")) {
            return;
        }
        System.err.println(String.format("%20s %s: %25s  %10s %s", this.fullCmdNameAndSuccessor, ("" + this.hashCode()).substring(0, 3), eventName, desc, repr));
    }
}

