/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;

public class GlobalCmdTermEvent
extends UxEvent {
    private ICommandContainer cmdcrtl;
    private ICommandContainer parentCmdContainer;
    private boolean terminateOk;
    private boolean terminateUserCancel;
    private boolean terminateCancel;
    private boolean killParentGraphOwner;
    private boolean doNotReloadParentViewsOnFastMultiProcessing;
    private List<Object> selections;

    public GlobalCmdTermEvent(ICommandContainer aCmd, ICommandContainer parentCont, boolean killParentGO, boolean termOk, boolean termUserCancel, boolean termCancel, List<Object> selectns) {
        this.cmdcrtl = aCmd;
        this.parentCmdContainer = parentCont;
        this.killParentGraphOwner = killParentGO;
        this.terminateOk = termOk;
        this.terminateCancel = termCancel;
        this.terminateUserCancel = termUserCancel;
        this.selections = selectns;
        this.doNotReloadParentViewsOnFastMultiProcessing = false;
        if (termOk && (termCancel || termUserCancel)) {
            throw new IllegalStateException("ISE1: This can not happen " + termOk + " vs. " + termUserCancel + " / " + termCancel);
        }
        if (termUserCancel && (termOk || termCancel)) {
            throw new IllegalStateException("ISE2: This can not happen " + termOk + " vs. " + termUserCancel + " / " + termCancel);
        }
    }

    public ICommandContainer getClosedContainer() {
        return this.cmdcrtl;
    }

    public ICommandContainer getParentOfClosed() {
        return this.parentCmdContainer;
    }

    public boolean iAmParent(ICommandContainer cmd) {
        return this.parentCmdContainer == cmd;
    }

    public List<Object> getCmdSelections() {
        return this.selections;
    }

    public boolean wasOk() {
        return this.terminateOk;
    }

    public boolean killParentGO() {
        return this.killParentGraphOwner;
    }

    public boolean wasCancelOrUserCancel() {
        return this.terminateCancel || this.terminateUserCancel;
    }

    public void setNotReloadViewsOnParent() {
        this.doNotReloadParentViewsOnFastMultiProcessing = true;
    }

    public boolean isNoReloadOnParent() {
        return this.doNotReloadParentViewsOnFastMultiProcessing;
    }

    @Override
    public String paramInfo() {
        String type;
        String string = type = this.terminateOk ? " OK" : " NOT OK";
        if (this.terminateCancel) {
            type = " CANCEL";
        } else if (this.terminateUserCancel) {
            type = " USR CANCEL";
        }
        return this.cmdcrtl + " in " + type;
    }
}

