/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class LoginController
implements IOFXUserServices {
    private IOFXCoreReporter.MoWarePlatform pltfrm;
    private String systemName;
    private String deviceNameAndSw;
    private String deviceId;
    private String deviceConnectInfo;
    private boolean noExAndNoPreconditionButFalseReturnInStartup;
    private String appVersion;
    private String appFqName;
    private IToolkit_UiFactory fact;

    public LoginController(IToolkit_UiFactory factory, IOFXCoreReporter.MoWarePlatform aPlatform, String aSystemName, String connectInfo) {
        this.pltfrm = aPlatform;
        this.systemName = aSystemName;
        this.deviceConnectInfo = connectInfo;
        this.fact = factory;
    }

    public boolean notAuthenticatedButNoProblems() {
        return this.noExAndNoPreconditionButFalseReturnInStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkLoginPrepareUserEnv(String username, String password, IOFXUserEnvironment env, IGenAppUiModule uiModule) {
        this.noExAndNoPreconditionButFalseReturnInStartup = false;
        boolean startupOk = false;
        String defaultNoLoginStr = String.format(this.fact.getSystemLabel(-1, MoWareTranslations.Key.LOGIN_USER_FAILED), username);
        IOFXSession session = this.fact.createNewSession(env, this);
        try {
            this.appFqName = uiModule.getClass().getName();
            this.appVersion = uiModule.getApplicationVersion();
            this.deviceNameAndSw = env.getDeviceName() + " " + env.getDeviceSwName();
            this.deviceId = env.getDeviceId();
            startupOk = uiModule.startup(username, password, env, session);
            if (!startupOk) {
                this.noExAndNoPreconditionButFalseReturnInStartup = true;
            }
        }
        catch (OFXAbortedException ex) {
            List problems = session.getAndclearProblemState();
            defaultNoLoginStr = OFXConsoleHelper.asSimpleString((List)problems);
        }
        catch (Throwable t) {
            startupOk = false;
            CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_PROBLEM, this.appFqName, this.appVersion, "org.modellwerkstatt.Login", "", "", IOFXCoreReporter.LogPriority.ERROR, 0, "", this.deviceNameAndSw, this.deviceId, this.deviceConnectInfo, "moware11 2025.24 (dck)", this.pltfrm, this.systemName, "Ex in startup while logging in");
            info.setException(t);
            info.addParameter("USERNAME", (Object)username);
            this.fact.report(info);
        }
        finally {
            session.closeSessionAndfreeGC();
        }
        if (!startupOk) {
            CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_MESSAGE, this.appFqName, this.appVersion, "org.modellwerkstatt.Login", "", "", IOFXCoreReporter.LogPriority.INFO, 0, "", this.deviceNameAndSw, this.deviceId, this.deviceConnectInfo, "moware11 2025.24 (dck)", this.pltfrm, this.systemName, "User '" + username + "' not logged in");
            info.addParameter("USERNAME", (Object)username);
            this.fact.report(info);
            return defaultNoLoginStr;
        }
        return null;
    }

    public void logOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String desc, HashMap<String, Object> paramMap) {
        CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_MESSAGE, this.appFqName, this.appVersion, source, cmdFqName, sessId, prio, 0, "", this.deviceNameAndSw, this.deviceId, this.deviceConnectInfo, "moware11 2025.24 (dck)", this.pltfrm, this.systemName, desc);
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                info.addParameter(key, paramMap.get(key));
            }
        }
        this.fact.report(info);
    }

    public void logExOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String desc, Throwable ex) {
        CoreReporterInfo info = new CoreReporterInfo(IOFXCoreReporter.Type.APP_MESSAGE, this.appFqName, this.appVersion, source, cmdFqName, sessId, prio, 0, "", this.deviceNameAndSw, this.deviceId, this.deviceConnectInfo, "moware11 2025.24 (dck)", this.pltfrm, this.systemName, desc);
        info.setException(ex);
        this.fact.report(info);
    }

    public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        throw new RuntimeException("User not logged in, UserService not accessible.");
    }

    public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        throw new RuntimeException("User not logged in, UserService not accessible.");
    }

    public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
        throw new RuntimeException("User not logged in, UserService not accessible.");
    }

    public void view(File pdfFile) {
        throw new RuntimeException("User not logged in, UserService not accessible.");
    }

    public void print(File pdfFile) {
        throw new RuntimeException("User not logged in, UserService not accessible.");
    }

    public void openUrl(String url) {
        throw new RuntimeException("User not logged in, UserService not accessible.");
    }
}

