/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.core;

import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.core.UxEvent;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;

public class MultiCmdStart
extends UxEvent {
    private int currentExecutions;
    private int totalExecutions;
    private boolean goOnWhenCanceled = false;
    private boolean fastExecWithNoUi = false;
    private BasisCmdStart protoType;
    private ICommandContainer parent;
    private List<Object> initialLocalSelection;
    private ISelectionController localSelectionCrtl;
    private IOFXDynCmdParams defaultDynParameterProvider;

    public MultiCmdStart(BasisCmdStart proto, List<Object> localSel, ISelectionController localSelCrtl, IOFXDynCmdParams parameterProvider) {
        this.protoType = proto;
        this.initialLocalSelection = localSel;
        this.totalExecutions = this.initialLocalSelection.size();
        this.currentExecutions = 0;
        this.localSelectionCrtl = localSelCrtl;
        this.defaultDynParameterProvider = parameterProvider;
    }

    public void enable_goOnWhenCanceled() {
        this.goOnWhenCanceled = true;
    }

    public void enable_fastExecNoUi() {
        this.fastExecWithNoUi = true;
    }

    public boolean isFastExecNoUi() {
        return this.fastExecWithNoUi;
    }

    public boolean isGoOnWhenCanceled() {
        return this.goOnWhenCanceled;
    }

    public boolean isLast() {
        return this.currentExecutions >= this.totalExecutions;
    }

    public boolean willBeFirstExecution() {
        return this.currentExecutions == 1;
    }

    public void incExecutions() {
        ++this.currentExecutions;
    }

    public Object getCurrentLocalSelection() {
        return this.initialLocalSelection.get(this.currentExecutions);
    }

    public ISelectionController getLocalSelCrtl() {
        return this.localSelectionCrtl;
    }

    public boolean hasNonDefaultParamProvider() {
        return this.defaultDynParameterProvider != null;
    }

    public IOFXDynCmdParams getNonDefaultParamProvider() {
        return this.defaultDynParameterProvider;
    }

    public String getCommandName() {
        return this.protoType.getCommandName();
    }

    public BasisCmdStart getParameterizedStartEvent(Object[] params) {
        BasisCmdStart cloned = this.protoType.cloneWithParams(params);
        cloned.setParent(this.getParentContainer());
        return cloned;
    }

    public void setParent(ICommandContainer par) {
        this.parent = par;
    }

    public ICommandContainer getParentContainer() {
        return this.parent;
    }

    @Override
    public String paramInfo() {
        return this.protoType.paramInfo() + " / " + this.currentExecutions + " / " + this.totalExecutions;
    }

    public void gcClean() {
        this.localSelectionCrtl = null;
        this.defaultDynParameterProvider = null;
        this.initialLocalSelection = null;
    }
}

