/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.dataux.runtime.delegates.DateTimeDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class DateTimeDateDelegate
extends Delegate<DateTime, IToolkit_DateOrTimeEditor> {
    private DateTimeFormatter formatter;
    private String format;

    public DateTimeDateDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option ... pickerOption) {
        super(factory, langIdx);
        this.formatter = factory.getTransProvider().getLocalDateFormatter(langIdx, null);
        this.format = factory.getTransProvider().getDefaultLocalDateFormat();
        boolean needsPicker = IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, pickerOption);
        this.toolkitEditor = factory.createDateEditor(needsPicker);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setDelegate(this);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setFormatter(this.format, this.formatter.getLocale().toLanguageTag(), this.langIndex);
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(this.format));
    }

    @Override
    public DateTime getValue() {
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        try {
            return this.formatter.parseDateTime(((IToolkit_DateOrTimeEditor)this.toolkitEditor).getText());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setValue(DateTime value) {
        if (value != null) {
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setText(this.formatter.print((ReadableInstant)value));
        } else {
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setText("");
        }
    }

    @Override
    public String isInputValid() {
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setValidationErrorText("");
        try {
            if (this.isCurrentlyInOptionalState()) {
                return null;
            }
            String val = ((IToolkit_DateOrTimeEditor)this.toolkitEditor).getText();
            this.formatter.parseDateTime(val);
            return null;
        }
        catch (Exception val) {
            String errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DATE_VALIDATION_ERR), this.format);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setValidationErrorText(errText);
            return errText;
        }
    }

    @Override
    public void setFormat(String frmt) {
        if (frmt != null && !"".equals(frmt.trim())) {
            this.format = frmt;
            this.formatter = this.uiFactory.getTransProvider().getLocalDateFormatter(this.langIndex, this.format);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setFormatter(this.format, this.formatter.getLocale().toLanguageTag(), this.langIndex);
            ((IToolkit_DateOrTimeEditor)this.toolkitEditor).setEditorPrompt(DateTimeDelegate.convertFormatToPromptString(this.format));
            this.setEnabled(false);
        }
    }
}

