/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.delegates.MetaInfoLocalVar;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRangeScale;

public class DecimalDelegate
extends Delegate<BigDecimal, IToolkit_TextEditor> {
    protected DecimalFormat formatter;
    protected String format;
    protected MetaInfoLocalVar<BigDecimal> minimum = new MetaInfoLocalVar<Object>(null);
    protected MetaInfoLocalVar<BigDecimal> maximum = new MetaInfoLocalVar<Object>(null);
    protected MetaInfoLocalVar<Integer> scale = new MetaInfoLocalVar<Object>(null);
    protected BigDecimal multiplier = new BigDecimal("1");

    public DecimalDelegate(IToolkit_UiFactory factory, int langIdx) {
        super(factory, langIdx);
        this.format = factory.getTransProvider().getDefaultDecimalFormat();
        this.formatter = factory.getTransProvider().getDecimalFormatter(langIdx, null);
        this.formatter.setParseBigDecimal(true);
        this.toolkitEditor = factory.createTextEditor();
        this.toolkitEditor.setDelegate(this);
    }

    @Override
    public BigDecimal getValue() {
        if (this.isCurrentlyInOptionalState()) {
            return null;
        }
        try {
            return ((BigDecimal)this.formatter.parse(this.toolkitEditor.getText())).divide(this.multiplier);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setValue(BigDecimal value) {
        if (value != null) {
            this.toolkitEditor.setText(this.formatter.format(value.multiply(this.multiplier)));
        } else {
            this.toolkitEditor.setText("");
        }
    }

    @Override
    public void load(Object obj) {
        super.load(obj);
        if (this.metaInfo != null) {
            IOFXMetaRangeScale m = (IOFXMetaRangeScale)this.metaInfo;
            this.minimum.setValue((BigDecimal)m.getMin());
            this.maximum.setValue((BigDecimal)m.getMax());
            this.scale.setValue(m.getScale());
            String frmt = m.getFormat();
            if (frmt != null) {
                this.setFormat(frmt);
            }
        }
    }

    @Override
    public String isInputValid() {
        BigDecimal deci;
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        String errText = null;
        String text = "";
        try {
            this.toolkitEditor.setValidationErrorText("");
            if (this.isCurrentlyInOptionalState()) {
                return null;
            }
            text = this.toolkitEditor.getText();
            ParsePosition pp = new ParsePosition(0);
            deci = (BigDecimal)this.formatter.parse(text, pp);
            if (pp.getIndex() != text.length()) {
                throw new Exception("Parselength and stringlength do not match.");
            }
            deci = deci.divide(this.multiplier);
        }
        catch (Exception ex) {
            if (this.isCurrentlyInOptionalState()) {
                return null;
            }
            errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_VALIDATION_ERR), this.formatter.toLocalizedPattern(), text);
            this.toolkitEditor.setValidationErrorText(errText);
            return errText;
        }
        if (this.minimum.isValueSet() && this.maximum.isValueSet()) {
            if (deci.compareTo(this.minimum.getValue()) < 0 || deci.compareTo(this.maximum.getValue()) > 0) {
                errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_BETWEEN_ERR), this.minimum.getValue().multiply(this.multiplier).toString(), this.maximum.getValue().multiply(this.multiplier).toString());
            }
        } else if (this.minimum.isValueSet()) {
            if (deci.compareTo(this.minimum.getValue()) < 0) {
                errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_MINIMUM_ERR), this.minimum.getValue().multiply(this.multiplier).toString());
            }
        } else if (this.maximum.isValueSet() && deci.compareTo(this.maximum.getValue()) > 0) {
            errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_MAXIMUM_ERR), this.maximum.getValue().multiply(this.multiplier).toString());
        }
        if (errText == null && this.scale.isValueSet() && deci.setScale((int)this.scale.getValue(), RoundingMode.HALF_DOWN).compareTo(deci) != 0) {
            errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_SCALE_ERR), this.scale.getValue().toString());
        }
        if (errText != null) {
            this.toolkitEditor.setValidationErrorText(errText);
        }
        return errText;
    }

    public void setMaximum(BigDecimal maxValue) {
        this.maximum.setValue(maxValue);
        this.maximum.setReadOnly();
    }

    public void setMinimum(BigDecimal minValue) {
        this.minimum.setValue(minValue);
        this.minimum.setReadOnly();
    }

    public void setMultiplicationFactor(BigDecimal factor) {
        this.multiplier = factor;
    }

    @Override
    public void setFormat(String frmt) {
        this.format = frmt.toLowerCase().replace("no0", "");
        this.formatter = this.uiFactory.getTransProvider().getDecimalFormatter(this.langIndex, this.format);
    }
}

