/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import java.math.BigDecimal;
import java.text.ParseException;
import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.core.DelegateChange;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.delegates.DateTimeDateDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.DateTimeDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.DecimalDelegate;
import org.modellwerkstatt.dataux.runtime.delegates.MetaInfoLocalVar;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegateHook;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxElementHook;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.dataux.runtime.utils.ValueObjectReplacementFacility;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaBasis;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public abstract class Delegate<T, Editor extends IToolkit_TextEditor>
implements IDataUxDelegate<T> {
    protected MetaInfoLocalVar<Boolean> enabled = new MetaInfoLocalVar<Boolean>(true);
    protected MetaInfoLocalVar<Boolean> optional = new MetaInfoLocalVar<Boolean>(false);
    protected MetaInfoLocalVar<Boolean> requestFocus = new MetaInfoLocalVar<Boolean>(false);
    protected IOFXMetaBasis metaInfo;
    protected String propertyName;
    protected boolean objEnabledState;
    protected boolean issuesUpdate;
    protected int langIndex;
    protected int oldHash;
    protected Editor toolkitEditor;
    protected IToolkit_UiFactory uiFactory;
    private IDataUxElementHook dataUxElementHook;
    protected IUpdateConclusionReceiver updateConclusionResolver;
    protected IDataUxDelegateHook<T> delegateHook;
    protected T initialDelegateValue;

    public Delegate(IToolkit_UiFactory factory, int langIdx) {
        this.uiFactory = factory;
        this.issuesUpdate = false;
        this.langIndex = langIdx;
        this.oldHash = -1;
    }

    @Override
    public abstract T getValue();

    @Override
    public abstract void setValue(T var1);

    @Override
    public abstract String isInputValid();

    @Override
    public void load(Object obj) {
        if (this.propertyName != null) {
            if (obj != null) {
                if (obj.hashCode() != this.oldHash) {
                    this.toolkitEditor.newObjectBound();
                }
                this.oldHash = obj.hashCode();
            } else {
                this.toolkitEditor.newObjectBound();
            }
            this.objEnabledState = true;
            this.metaInfo = (IOFXMetaBasis)MoJSON.get(obj, Delegate.getMetaDataAccessorToPath(this.propertyName));
            if (obj instanceof IOFXEntity) {
                this.objEnabledState = ((IOFXEntity)obj).getEnabled();
            }
            if (this.metaInfo != null) {
                String errorText;
                this.optional.setValue(this.metaInfo.getOptional());
                this.enabled.setValue(this.metaInfo.getEnabled() && this.objEnabledState);
                if (this.metaInfo.getLabel() != null) {
                    String label = this.metaInfo.getLabel();
                    this.toolkitEditor.setLabel(label);
                }
                if ((errorText = this.metaInfo.getValidationError()) != null && !errorText.trim().equals("")) {
                    this.toolkitEditor.setValidationErrorText(errorText);
                }
            } else {
                this.enabled.setValue(this.objEnabledState);
            }
            this.initialDelegateValue = MoJSON.get(obj, this.propertyName);
            this.setValue(this.initialDelegateValue);
            this.toolkitEditor.setEnabled(this.enabled.getValue());
            if (this.enabled.getValue().booleanValue() && this.metaInfo != null && this.metaInfo.getFocusAndClearIt()) {
                this.setRequestFocus(true);
            }
        }
    }

    @Override
    public final IDelegateChange store(Object obj) {
        DelegateChange change = null;
        if (this.propertyName != null && this.enabled.getValue().booleanValue()) {
            boolean changedValue;
            T newValue = this.getValue();
            boolean bl = changedValue = !SaveObjectComperator.equals(this.initialDelegateValue, newValue);
            if (this instanceof DecimalDelegate) {
                changedValue = !SaveObjectComperator.equalsBigDecimal((BigDecimal)((BigDecimal)this.initialDelegateValue), (BigDecimal)((BigDecimal)newValue));
            } else if (this instanceof DateTimeDateDelegate) {
                changedValue = !SaveObjectComperator.equalsDateOnDateTime((DateTime)((DateTime)this.initialDelegateValue), (DateTime)((DateTime)newValue));
            } else if (this instanceof DateTimeDelegate) {
                boolean bl2 = changedValue = !SaveObjectComperator.equalsDateTimeWithoutSeconds((DateTime)((DateTime)this.initialDelegateValue), (DateTime)((DateTime)newValue));
            }
            if (changedValue) {
                change = new DelegateChange(obj.getClass().getSimpleName() + "." + this.propertyName, this.initialDelegateValue + " -> " + newValue);
            }
            ValueObjectReplacementFacility.put(obj, this.propertyName, newValue);
        }
        return change;
    }

    @Override
    public void setProperty(String prop) {
        this.propertyName = prop;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setLabel(String label) {
        this.toolkitEditor.setLabel(label);
    }

    @Override
    public void setLabelTooltip(String label) {
        this.toolkitEditor.setLabelTooltip(label);
    }

    @Override
    public void setOptionalText(String text) {
        throw new RuntimeException("Not implemented for this delegate.");
    }

    @Override
    public void setOptional(boolean opt) {
        this.optional.setValue(opt);
        this.optional.setReadOnly();
    }

    @Override
    public void setEnabled(boolean enbl) {
        this.enabled.setValue(enbl);
        this.enabled.setReadOnly();
        this.toolkitEditor.setEnabled(enbl);
    }

    @Override
    public void setDisableFORCE() {
        if (!this.enabled.getValue().booleanValue() || !this.enabled.isReadOnly()) {
            this.enabled.setValueFORCE(false);
            this.enabled.setReadOnly();
            this.toolkitEditor.setEnabled(false);
        }
    }

    public void setOption(IToolkit_TextEditor.Option ... options) {
        if (options.length > 0) {
            this.toolkitEditor.setOption(options);
        }
    }

    @Override
    public void setRequestFocus(boolean val) {
        this.requestFocus.setValue(val);
    }

    @Override
    public IToolkit_TextEditor getDelegateUiImpl() {
        return this.toolkitEditor;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.getValue();
    }

    @Override
    public boolean isRequestFocus() {
        return this.requestFocus.getValue();
    }

    @Override
    public boolean isCurrentlyInOptionalState() {
        return this.optional.getValue() == true && ("".equals(this.toolkitEditor.getText()) || this.toolkitEditor.getText() == null);
    }

    @Override
    public void keyReleasedEvent() {
        block3: {
            try {
                if (this.dataUxElementHook != null && this.enabled.getValue().booleanValue()) {
                    this.dataUxElementHook.delegateFormDataChanged(this);
                }
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof ParseException) break block3;
                throw ex;
            }
        }
    }

    @Override
    public void setDelegateDataUxElementHook(IDataUxElementHook hook) {
        if (this.issuesUpdate) {
            throw new RuntimeException("Issue update conclusion and an elementHook are not supported at the same time for delegate " + this.propertyName);
        }
        this.dataUxElementHook = hook;
        this.toolkitEditor.enableKeyReleaseEvents();
    }

    @Override
    public void setDelegateHook(IDataUxDelegateHook<T> hook) {
        this.delegateHook = hook;
    }

    public boolean hasDelegateHook() {
        return this.delegateHook != null;
    }

    @Override
    public void setFormat(String frmt) {
        if (frmt != null && !"".equals(frmt.trim())) {
            System.err.println(this.getClass().getName() + " does not implement setFormat()!");
        }
    }

    public void setIssuesUpdateConclusion(IUpdateConclusionReceiver rec) {
        if (this.dataUxElementHook != null) {
            throw new RuntimeException("Issue update conclusion and an elementHook are not supported at the same time for delegate " + this.propertyName);
        }
        this.updateConclusionResolver = rec;
        this.issuesUpdate = true;
        this.toolkitEditor.setIssuesUpdateConclusion();
    }

    @Override
    public boolean issuesUpdate() {
        return this.issuesUpdate;
    }

    @Override
    public void issueUpdateConclusionAfterContentChange() {
        this.updateConclusionResolver.issueUpdateConclusion(this);
    }

    public String toString() {
        return "DLGT " + this.propertyName;
    }

    @Override
    public void gcClear() {
        this.updateConclusionResolver = null;
        this.toolkitEditor.gcClear();
        this.uiFactory = null;
    }

    @Override
    public void preDelayedAfterFullUiInitialized() {
        throw new RuntimeException("Not implemented.");
    }

    public static String getMetaDataAccessorToPath(String propPath) {
        return propPath + "_META";
    }
}

