/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.delegates.MetaInfoLocalVar;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRange;

public class IntegerDelegate
extends Delegate<Integer, IToolkit_TextEditor> {
    protected MetaInfoLocalVar<Integer> min = new MetaInfoLocalVar<Object>(null);
    protected MetaInfoLocalVar<Integer> max = new MetaInfoLocalVar<Object>(null);

    public IntegerDelegate(IToolkit_UiFactory factory, int langIdx) {
        super(factory, langIdx);
        this.toolkitEditor = factory.createTextEditor();
        this.toolkitEditor.setDelegate(this);
    }

    @Override
    public Integer getValue() {
        if (this.isCurrentlyInOptionalState()) {
            return 0;
        }
        return Integer.parseInt(this.toolkitEditor.getText());
    }

    @Override
    public void setValue(Integer value) {
        if (value != null) {
            this.toolkitEditor.setText(value.toString());
        } else {
            this.toolkitEditor.setText("");
        }
    }

    @Override
    public void load(Object obj) {
        super.load(obj);
        if (this.metaInfo != null) {
            IOFXMetaRange m = (IOFXMetaRange)this.metaInfo;
            this.min.setValue((Integer)m.getMin());
            this.max.setValue((Integer)m.getMax());
        }
    }

    @Override
    public String isInputValid() {
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        String errText = null;
        try {
            this.toolkitEditor.setValidationErrorText("");
            if (this.isCurrentlyInOptionalState()) {
                return null;
            }
            int value = Integer.parseInt(this.toolkitEditor.getText());
            if (this.min.isValueSet() && this.max.isValueSet()) {
                if (value < this.min.getValue() || value > this.max.getValue()) {
                    errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_BETWEEN_ERR), this.min.getValue().toString(), this.max.getValue().toString());
                }
            } else if (this.min.isValueSet()) {
                if (value < this.min.getValue()) {
                    errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_MINIMUM_ERR), this.min.getValue().toString());
                }
            } else if (this.max.isValueSet() && value > this.max.getValue()) {
                errText = String.format(this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.DECIMAL_MAXIMUM_ERR), this.max.getValue().toString());
            }
        }
        catch (Exception ex) {
            errText = this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.INTEGER_VALIDATION_ERR);
        }
        if (errText != null) {
            this.toolkitEditor.setValidationErrorText(errText);
        }
        return errText;
    }

    public void setMaximum(int maxValue) {
        this.max.setValue(maxValue);
        this.max.setReadOnly();
    }

    public void setMinimum(int minValue) {
        this.min.setValue(minValue);
        this.min.setReadOnly();
    }

    @Override
    public void setFormat(String frmt) {
        frmt = frmt.toLowerCase().replace("no0", "");
        super.setFormat(frmt);
    }
}

