/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.delegates.Delegate;
import org.modellwerkstatt.dataux.runtime.delegates.ReferenceDelegate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_StatusEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.utils.MoJSON;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaBasis;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class StatusDelegate
extends Delegate<IOFXMetaStatus.IOFXStatusElement, IToolkit_StatusEditor> {
    public String statusOptionalItemText = "---";
    private IOFXMetaStatus.IOFXStatusElement[] elements;
    private List<String> currentDelegateLabels;

    public StatusDelegate(IToolkit_UiFactory factory, int langIdx, IToolkit_TextEditor.Option ... alterOptions) {
        super(factory, langIdx);
        this.toolkitEditor = factory.createStatusEditor(IToolkit_TextEditor.has(IToolkit_TextEditor.Option.ALTER_PICKER, alterOptions));
        ((IToolkit_StatusEditor)this.toolkitEditor).setDelegate(this);
    }

    @Override
    public IOFXMetaStatus.IOFXStatusElement getValue() {
        int selIdx = ((IToolkit_StatusEditor)this.toolkitEditor).getSelectedIndex();
        if (selIdx < this.elements.length) {
            return this.elements[selIdx];
        }
        if (selIdx == this.elements.length && ((Boolean)this.optional.getValue()).booleanValue()) {
            return null;
        }
        throw new RuntimeException("getValue() with selected-index '" + selIdx + "' called but index does not suit elements length " + this.elements.length + " on property " + this.propertyName + "(or +1 while optional is " + this.optional.getValue() + ")");
    }

    @Override
    public void setValue(IOFXMetaStatus.IOFXStatusElement value) {
        if (this.elements == null && value == null) {
            return;
        }
        IListSequence labels = ListSequence.fromList(new ArrayList());
        int selectedIndex = -1;
        for (int i = 0; i < this.elements.length; ++i) {
            if (SaveObjectComperator.equals((Object)this.elements[i], (Object)value)) {
                selectedIndex = i;
            }
            if (this.elements[i] == null) {
                throw new RuntimeException("One of the status elements (index " + i + ") is null. This is not allowed. Scope not correct.");
            }
            ListSequence.fromList((List)labels).addElement((Object)this.uiFactory.getTransProvider().translateSingle(this.langIndex, this.elements[i].getLongDesc()));
        }
        if (((Boolean)this.optional.getValue()).booleanValue() || value == null && !((Boolean)this.enabled.getValue()).booleanValue()) {
            ListSequence.fromList((List)labels).addElement((Object)this.statusOptionalItemText);
            if (value == null) {
                selectedIndex = ListSequence.fromList((List)labels).count() - 1;
            }
        }
        if (!ReferenceDelegate.sameContent(labels, this.currentDelegateLabels)) {
            this.currentDelegateLabels = labels;
            ((IToolkit_StatusEditor)this.toolkitEditor).setItems((List<String>)labels);
        }
        if (selectedIndex == -1) {
            throw new RuntimeException("setValue() with '" + value + "' but enabled elements are restricted to " + (List)labels + " and Editor is enabled.");
        }
        if (selectedIndex >= ListSequence.fromList((List)labels).count()) {
            throw new RuntimeException("setValue() with '" + value + "' called. Index " + selectedIndex + " exceeds items list length " + (List)labels + " on property " + this.propertyName + "(optional is " + this.optional.getValue() + ")");
        }
        ((IToolkit_StatusEditor)this.toolkitEditor).setSelectedIndex(selectedIndex);
    }

    @Override
    public void load(Object obj) {
        if (this.propertyName != null) {
            this.metaInfo = (IOFXMetaBasis)MoJSON.get(obj, Delegate.getMetaDataAccessorToPath(this.propertyName));
            if (this.metaInfo != null) {
                IOFXMetaStatus m = (IOFXMetaStatus)this.metaInfo;
                this.elements = (IOFXMetaStatus.IOFXStatusElement[])m.getElements();
            }
        }
        super.load(obj);
    }

    @Override
    public String isInputValid() {
        if (!((Boolean)this.enabled.getValue()).booleanValue()) {
            return null;
        }
        ((IToolkit_StatusEditor)this.toolkitEditor).setValidationErrorText("");
        String errText = null;
        if (((IToolkit_StatusEditor)this.toolkitEditor).getSelectedIndex() < 0) {
            errText = this.uiFactory.getSystemLabel(this.langIndex, MoWareTranslations.Key.STATUS_VALIDATION_ERR);
            ((IToolkit_StatusEditor)this.toolkitEditor).setValidationErrorText(errText);
        }
        return errText;
    }

    @Override
    public void setOptionalText(String text) {
        if (text != null) {
            this.statusOptionalItemText = text.trim();
        }
    }
}

