/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import java.text.DecimalFormat;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;

public class TableCellIntegerConverter
implements ITableCellStringConverter<Integer> {
    private DecimalFormat formatter;
    private boolean doNotDisplayZeroValue = false;

    public TableCellIntegerConverter(DecimalFormat frmt, boolean noNullOption) {
        this.formatter = frmt;
        this.doNotDisplayZeroValue = noNullOption;
    }

    @Override
    public String convert(Integer obj) {
        if (obj == null) {
            return "";
        }
        if (this.doNotDisplayZeroValue && obj.compareTo(0) == 0) {
            return "";
        }
        if (this.formatter == null) {
            return obj.toString();
        }
        return this.formatter.format(obj);
    }

    @Override
    public boolean isRightAligned() {
        return true;
    }

    @Override
    public String getBgColor(Integer i) {
        return null;
    }

    @Override
    public Integer convertBack(String s) {
        return new Integer(s);
    }
}

