/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.delegates;

import java.util.Map;
import org.modellwerkstatt.dataux.runtime.extensions.ITableCellStringConverter;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;

public class TableCellStatusConverter<T extends IOFXMetaStatus.IOFXStatusElement<T>>
implements ITableCellStringConverter<IOFXMetaStatus.IOFXStatusElement<T>> {
    private IOFXMetaStatus.IOFXStatusElement<T> defaultStatus;
    private Map<Integer, String> tranLationMap;

    public TableCellStatusConverter(IOFXMetaStatus.IOFXStatusElement<T> dflt, Map<Integer, String> descTranslationMap) {
        this.defaultStatus = dflt;
        this.tranLationMap = descTranslationMap;
    }

    @Override
    public String convert(IOFXMetaStatus.IOFXStatusElement<T> obj) {
        if (obj == null) {
            return "";
        }
        return this.tranLationMap.get(obj.getDbValue().hashCode());
    }

    @Override
    public boolean isRightAligned() {
        return false;
    }

    @Override
    public String getBgColor(IOFXMetaStatus.IOFXStatusElement<T> obj) {
        if (obj == null) {
            return null;
        }
        return obj.getColor();
    }

    @Override
    public IOFXMetaStatus.IOFXStatusElement<T> convertBack(String shortText) {
        for (IOFXMetaStatus.IOFXStatusElement t : (IOFXMetaStatus.IOFXStatusElement[])this.defaultStatus.getAllStatusElements()) {
            String translatedText = this.tranLationMap.get(t.getDbValue().hashCode());
            if (!translatedText.equals(shortText)) continue;
            return t;
        }
        return null;
    }

    public T[] getAllElements() {
        return (IOFXMetaStatus.IOFXStatusElement[])this.defaultStatus.getAllStatusElements();
    }

    @Override
    public String[] getColorMapOrNull() {
        IOFXMetaStatus.IOFXStatusElement[] allStati;
        boolean hasColor = false;
        for (IOFXMetaStatus.IOFXStatusElement sta : allStati = (IOFXMetaStatus.IOFXStatusElement[])this.defaultStatus.getAllStatusElements()) {
            if (!sta.hasColor()) continue;
            hasColor = true;
            break;
        }
        if (hasColor) {
            String[] colors = new String[allStati.length];
            int idx = 0;
            for (IOFXMetaStatus.IOFXStatusElement sta : allStati) {
                if (!sta.hasColor()) continue;
                colors[idx++] = sta.getColor();
            }
            return colors;
        }
        return null;
    }
}

