/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.genspecifications;

import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.IEventProcessor;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.core.MultiCmdStart;
import org.modellwerkstatt.dataux.runtime.genspecifications.AbstractAction;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_EnableItem;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXDynCmdParams;
import org.modellwerkstatt.objectflow.runtime.IOFXPlatform;
import org.modellwerkstatt.objectflow.runtime.IOFXSelcrtlBasics;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.IOFXTranslationProvider;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public abstract class CmdAction
extends AbstractAction {
    public IOFXCmdModule cmdModule;
    public IEventProcessor eventProcessor;
    protected IToolkit_EnableItem uiButton_1;
    protected IToolkit_EnableItem uiButton_2;
    protected IOFXDynCmdParams nonDefaultDynParamCreator;
    protected ISelectionController localSelCrtl;
    protected boolean gcCleanCalled;
    protected boolean multiGoOnWhenCanceled;
    protected boolean multiFastExecNoUi;
    protected boolean multicanPotentiallyExecWhenMultiSelection;
    public String commandFqName;
    public String image;
    public String hotKey;
    public String toolTip;
    public boolean globalHotkey;
    public boolean hideWhenDisabled;
    public boolean urlEnabledCmd;
    public boolean isGraphEdit;
    public boolean DEBUG = false;

    public CmdAction(String cmdName, String customLabel, boolean globalHk, IOFXDynCmdParams selProv, boolean goOnWhenCanceled, boolean fastExecNoUi, boolean canPotentiallyMultiSelect) {
        super(customLabel);
        this.nonDefaultDynParamCreator = selProv;
        this.commandFqName = cmdName;
        this.globalHotkey = globalHk;
        this.multiGoOnWhenCanceled = goOnWhenCanceled;
        this.multiFastExecNoUi = fastExecNoUi;
        this.multicanPotentiallyExecWhenMultiSelection = canPotentiallyMultiSelect;
        this.toolTip = "";
        this.hideWhenDisabled = false;
        this.gcCleanCalled = false;
    }

    public CmdAction(String cmdName, boolean globalHk, IOFXDynCmdParams selProv, boolean goOnWhenCanceled, boolean fastExecNoUi, boolean canPotentiallyMultiSelect) {
        this(cmdName, null, globalHk, selProv, goOnWhenCanceled, fastExecNoUi, canPotentiallyMultiSelect);
    }

    public boolean noLabelSet() {
        return this.labelText == null;
    }

    public void configure(IToolkit_UiFactory factory, IEventProcessor processor, ISelectionController localSel, int langIdx) {
        this.localSelCrtl = localSel;
        this.cmdModule = factory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)this.commandFqName));
        this.eventProcessor = processor;
        IOFXTranslationProvider tranProvider = factory.getTransProvider();
        IOFXPlatform platform = factory.getPlatform();
        if (this.noLabelSet()) {
            String defaultLabel = this.cmdModule.getCommandDefaultLabel(this.commandFqName);
            this.labelText = tranProvider.translateSingle(langIdx, defaultLabel);
            this.image = this.cmdModule.getCommandDefaultIcon(this.commandFqName);
            this.hotKey = this.cmdModule.getCommandDefaultHotkey(this.commandFqName);
            this.hideWhenDisabled = false;
        } else {
            String platformKey = this.labelText;
            this.labelText = tranProvider.translateSingle(langIdx, platform.getTextForLabel(platformKey));
            this.image = platform.getIconForLabel(platformKey);
            this.hotKey = platform.getHotKeyForLabel(platformKey);
            this.hideWhenDisabled = platform.isHideOnDisabledForLabel(platformKey);
        }
        this.toolTip = this.cmdModule.getCommandToolTip(this.commandFqName);
        this.isGraphEdit = this.cmdModule.isCommandType(this.commandFqName, new IOFXCommand.OFXCmdTyp[]{IOFXCommand.OFXCmdTyp.GRAPH_EDIT_CMD});
    }

    public void attachButton1(IToolkit_EnableItem item) {
        this.uiButton_1 = item;
    }

    public void attachButton2(IToolkit_EnableItem item) {
        this.uiButton_2 = item;
    }

    public ISelectionController getLocalSelController() {
        return this.localSelCrtl;
    }

    public void adjustTooltipToCmd(IToolkit_UiFactory factory, String fqName) {
        IOFXCmdModule innerProc = factory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)fqName));
        this.toolTip = innerProc.getCommandToolTip(fqName);
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public boolean checkForMultiSelection(IOFXCmdModule proc, String cmdFqName, IOFXSelection localSelection) {
        if (!this.canPotentiallyExecWhenMultiSelection()) {
            return false;
        }
        List objs = localSelection.getObjects();
        IOFXCmdModule.CmdExecStrategy strategy = this.canPotentiallyExecWhenMultiSelection() ? IOFXCmdModule.CmdExecStrategy.AUTO_CON_MULTI : IOFXCmdModule.CmdExecStrategy.MULTI;
        for (Object o : objs) {
            Object[] params = this.calculateParams(o);
            if (params == null) {
                return false;
            }
            IOFXCmdModule.CommandPermission x = proc.getCommandPermission(strategy, cmdFqName, params, this.eventProcessor.getSession());
            if (x != IOFXCmdModule.CommandPermission.DISABLED) continue;
            return false;
        }
        return true;
    }

    public boolean reevalEnabled() {
        boolean enabled = false;
        Object[] params = this.calculateParams(null);
        if (params != null) {
            enabled = this.cmdModule.getCommandPermission(IOFXCmdModule.CmdExecStrategy.SINGLE, this.commandFqName, params, this.eventProcessor.getSession()) != IOFXCmdModule.CommandPermission.DISABLED;
        } else {
            IOFXSelection tmpLocalSelection = this.localSelCrtl.getLocalSelection();
            if (tmpLocalSelection != null && tmpLocalSelection.size() > 0) {
                enabled = this.checkForMultiSelection(this.cmdModule, this.commandFqName, tmpLocalSelection);
            }
        }
        if (this.uiButton_1 != null) {
            this.uiButton_1.setItemEnabled(enabled);
        }
        if (this.uiButton_2 != null) {
            this.uiButton_2.setItemEnabled(enabled);
        }
        return enabled;
    }

    @Override
    public String toString() {
        return "Action '" + this.labelText + "' (" + this.commandFqName + ")";
    }

    public Object[] calculateParams(Object singleSelToReplace) {
        if (this.nonDefaultDynParamCreator != null) {
            return this.nonDefaultDynParamCreator.calc((IOFXSelcrtlBasics)this.localSelCrtl, singleSelToReplace);
        }
        return this.cmdModule.getCommandDefaultParams(this.commandFqName, (IOFXSelcrtlBasics)this.localSelCrtl, singleSelToReplace);
    }

    public BasisCmdStart configCompoundOuterCmdStartOrJustBasisCmdStart(Object[] singleExecParams) {
        return new BasisCmdStart(this.commandFqName, singleExecParams);
    }

    public void startCommand() {
        try {
            IOFXSelection sel = this.localSelCrtl.getLocalSelection();
            if (sel != null && sel.size() >= 2 && this.canPotentiallyExecWhenMultiSelection()) {
                BasisCmdStart prototype = this.configCompoundOuterCmdStartOrJustBasisCmdStart(null);
                prototype.setLabelText(this.labelText);
                MultiCmdStart multi = new MultiCmdStart(prototype, sel.getObjects(), this.localSelCrtl, this.nonDefaultDynParamCreator);
                if (this.multiGoOnWhenCanceled) {
                    multi.enable_goOnWhenCanceled();
                }
                if (this.multiFastExecNoUi) {
                    multi.enable_fastExecNoUi();
                }
                this.eventProcessor.receiveAndProcess(multi);
            } else {
                Object[] localParams = this.calculateParams(null);
                BasisCmdStart ev = this.configCompoundOuterCmdStartOrJustBasisCmdStart(localParams);
                ev.setLabelText(this.labelText);
                this.eventProcessor.receiveAndProcess(ev);
            }
        }
        catch (Exception ex) {
            OFXLogger.log(CmdAction.class, (IOFXCoreReporter.LogPriority)IOFXCoreReporter.LogPriority.ERROR, (String)("EXCEPTION occured in " + this.getClass().getSimpleName() + ".startCommand() for " + this.commandFqName + "\n" + ex.getClass().getName() + ": " + ex.getMessage() + "\n" + OFXConsoleHelper.stackTrace2String((Throwable)ex)), null);
        }
    }

    public boolean canPotentiallyExecWhenMultiSelection() {
        return this.multicanPotentiallyExecWhenMultiSelection;
    }

    public void gcClear() {
        this.gcCleanCalled = true;
        this.cmdModule = null;
        this.eventProcessor = null;
        this.uiButton_1 = null;
        this.uiButton_2 = null;
        this.localSelCrtl = null;
        this.nonDefaultDynParamCreator = null;
    }
}

