/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.genspecifications;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.IDelegateChange;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxElementHook;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Selection;

public abstract class DelegateForm<T>
implements IUpdateConclusionReceiver,
IGenSelControlled<T> {
    protected IToolkit_DelegateForm uiDelegateForm;
    protected IDataUxElementHook dataUxElementHook;
    protected ISelectionController selController;
    protected IUpdateConclusionReceiver.IFocusAbleDelegate updateIssuer;
    protected IDataUxDelegate[] boundDelegates;
    protected T boundObject = null;
    protected boolean readOnly = false;
    protected List<IDelegateChange> delegateChanges = null;
    protected Class contentClass;
    protected boolean boundWithProperty;

    public DelegateForm(Class cc, boolean rd) {
        this.contentClass = cc;
        this.readOnly = rd;
    }

    @Override
    public IToolkit_Form getToolkitImplementation() {
        return this.uiDelegateForm;
    }

    @Override
    public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate issuer) {
        this.updateIssuer = issuer;
        this.selController.issueUpdateConclusion(issuer);
    }

    @Override
    public void preDelayedAfterFullUiInitialized() {
    }

    public void loadDelegatesWithBoundObject() {
        for (IDataUxDelegate dlgt : this.boundDelegates) {
            dlgt.load(this.boundObject);
        }
    }

    public IUpdateConclusionReceiver.IFocusAbleDelegate delegateWithFocus() {
        for (IDataUxDelegate dlgt : this.boundDelegates) {
            if (!dlgt.isRequestFocus()) continue;
            return dlgt;
        }
        return null;
    }

    public void loadObjectToForm(T objectToLoad) {
        this.delegateChanges = null;
        this.boundObject = objectToLoad;
        for (IDataUxDelegate dlgt : this.boundDelegates) {
            dlgt.setRequestFocus(false);
        }
        this.loadDelegatesWithBoundObject();
        IUpdateConclusionReceiver.IFocusAbleDelegate markedByProgrammer = this.delegateWithFocus();
        if (markedByProgrammer == null && this.updateIssuer != null) {
            this.updateIssuer.setRequestFocus(true);
            this.loadDelegatesWithBoundObject();
        }
        this.updateIssuer = null;
        if (this.dataUxElementHook != null) {
            this.dataUxElementHook.boundObjectLoadedOrNull(this.boundObject);
        }
    }

    public void store(Object object) {
        for (IDataUxDelegate dlgt : this.boundDelegates) {
            IDelegateChange change = dlgt.store(this.boundObject);
            if (change == null) continue;
            if (this.delegateChanges == null) {
                this.delegateChanges = new ArrayList<IDelegateChange>();
            }
            this.delegateChanges.add(change);
        }
    }

    @Override
    public String saveAndValidate() {
        String errText = null;
        if (!this.readOnly && (errText = this.uiDelegateForm.checkDelegatesValidAndFocus()) == null) {
            this.store(this.boundObject);
        }
        return errText;
    }

    @Override
    public List<IDelegateChange> collectDelegateChanges() {
        return this.delegateChanges;
    }

    @Override
    public void forceNotEditable() {
        this.readOnly = true;
        for (IDataUxDelegate dlgt : this.boundDelegates) {
            dlgt.setDisableFORCE();
        }
        if (this.dataUxElementHook != null) {
            this.dataUxElementHook.forceNotEditable();
        }
    }

    public void clear() {
        this.loadObjectToForm(null);
    }

    public void setBoundDelegates(IDataUxDelegate ... delegates) {
        this.boundDelegates = delegates;
    }

    public void installDataUxDelegateHook(IToolkit_UiFactory factory, String fqName) {
        this.dataUxElementHook = (IDataUxElementHook)factory.getNewClassInstanceByFQName(fqName);
        this.dataUxElementHook.initialize(this.selController, Arrays.asList(this.boundDelegates));
    }

    @Override
    public boolean selectionChanged(IOFXSelection selection, boolean doNotLoadReloadFollows) {
        if (!this.boundWithProperty) {
            if (selection.size() != 1) {
                this.clear();
            } else if (!doNotLoadReloadFollows) {
                this.loadObjectToForm(selection.getObject());
            }
        }
        return true;
    }

    @Override
    public void loadList(List<T> objects, IOFXSelection selection) {
        if (selection.size() == 1) {
            this.loadObjectToForm(selection.getObject());
        } else if (ListSequence.fromList(objects).count() == 1) {
            if (this.boundWithProperty) {
                Object objectToLoad = ListSequence.fromList(objects).getElement(0);
                this.loadObjectToForm(objectToLoad);
            }
            this.selController.pushSelectionAbsolute((IOFXSelection)new Selection(ListSequence.fromList(objects).getElement(0)));
        } else {
            this.clear();
        }
    }

    public void pushSelection(IOFXSelection selection) {
        this.selController.pushSelectionAbsolute(selection);
    }

    public IOFXSelection getSelection(Class clazz, boolean includingDerived) {
        return this.selController.getSelectionAbsolute(clazz, includingDerived);
    }

    public void gcClear(IDataUxDelegate ... allDelegates) {
        if (this.dataUxElementHook != null) {
            this.dataUxElementHook.gcClear();
        }
        for (IDataUxDelegate dlgt : allDelegates) {
            dlgt.gcClear();
        }
        this.uiDelegateForm.gcClear();
        this.selController = null;
        this.boundObject = null;
        this.uiDelegateForm = null;
    }
}

