/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.genspecifications;

import java.util.Arrays;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.core.IPagePaneSelCrtl;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenPagePane;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_FormContainer;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.Workarounds2;

public abstract class PagePane<T>
implements IGenPagePane<T> {
    protected IPagePaneSelCrtl pagePaneController;
    protected IGenSelControlled pagePaneChild;
    protected IToolkit_Form responsibleForHeadingAndFlag;
    protected List<CmdAction> actions;
    protected Class pagePaneType;
    protected boolean pagePaneNeedsFullSizeWindow;
    protected String pagePaneColor = null;

    public PagePane(Class<T> type, boolean needsFullSizeWin) {
        this(type, needsFullSizeWin, null);
    }

    public PagePane(Class<T> type, boolean needsFullSizeWin, String color) {
        this.pagePaneType = type;
        this.pagePaneNeedsFullSizeWindow = needsFullSizeWin;
        this.pagePaneColor = color;
    }

    @Override
    public Class getPagePaneType() {
        return this.pagePaneType;
    }

    @Override
    public String calcUiColor(Object selectedRootObject) {
        return this.pagePaneColor;
    }

    public IOFXSelection getSelection(Class clazz, boolean includingDerived) {
        return this.pagePaneController.getSelectionAbsolute(clazz, includingDerived);
    }

    public void pushSelection(IOFXSelection selection) {
        this.pagePaneController.pushSelectionAbsolute(selection);
    }

    @Override
    public boolean pageNeedsMaxAvailableSpace() {
        return this.pagePaneNeedsFullSizeWindow;
    }

    @Override
    public void setProblems(List<IOFXProblem> listOfProblems) {
        listOfProblems = Workarounds2.limitProblemsTo((int)8, listOfProblems);
        this.responsibleForHeadingAndFlag.setProblems(listOfProblems);
    }

    @Override
    public void setHeading(String text) {
        this.responsibleForHeadingAndFlag.setTitleText(text);
    }

    public void installWithMenu(IToolkit_UiFactory factory, boolean childCanHandleFlagAndMenu, Menu menu) {
        IToolkit_FormContainer formContainer = childCanHandleFlagAndMenu ? (IToolkit_FormContainer)this.pagePaneChild.getToolkitImplementation() : PagePane.addContainerWithChild(factory, this.pagePaneChild);
        this.pagePaneController.addActionAndInjectDependencies(menu, this.pagePaneController);
        formContainer.addMenuAndSetButtons(menu);
        this.responsibleForHeadingAndFlag = formContainer;
    }

    public void installWithoutMenu(IToolkit_UiFactory factory, boolean childCanHandleFlag) {
        this.responsibleForHeadingAndFlag = childCanHandleFlag ? this.pagePaneChild.getToolkitImplementation() : PagePane.addContainerWithChild(factory, this.pagePaneChild);
    }

    public static IToolkit_FormContainer addContainerWithChild(IToolkit_UiFactory factory, IGenSelControlled child) {
        IToolkit_FormContainer frmc = factory.createToolkitFormContainer(false);
        frmc.setLayoutConstraints(Arrays.asList("1*"), Arrays.asList("1*"));
        frmc.addChildren(child.getToolkitImplementation());
        return frmc;
    }

    @Override
    public IToolkit_Form getPagePaneToolkitImpl() {
        return this.responsibleForHeadingAndFlag;
    }

    @Override
    public void gcClear() {
    }
}

