/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.httpapi;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiException;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiOperationBase;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiEndpointSerdes;
import org.modellwerkstatt.dataux.runtime.httpapi.JSonApiErrorReporter;
import org.modellwerkstatt.dataux.runtime.httpapi.JSonSerialized;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.sdservices.BaseSerdes;
import org.modellwerkstatt.objectflow.sdservices.CField;
import org.modellwerkstatt.objectflow.sdservices.JackyFieldSerdes;
import org.modellwerkstatt.objectflow.sdservices.JackyGraphSerdes;
import org.modellwerkstatt.objectflow.sdservices.JackyInfra;
import org.modellwerkstatt.objectflow.sdservices.JackyParsed;
import org.modellwerkstatt.objectflow.sdservices.VElement;
import org.modellwerkstatt.objectflow.sdservices.VField;
import org.modellwerkstatt.objectflow.sdservices.VList;
import org.modellwerkstatt.objectflow.sdservices.VObject;
import org.modellwerkstatt.objectflow.sdservices.VParent;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.SerdesException;

public class ApiEndpointJSonSerdes
implements IApiEndpointSerdes {
    private JackyInfra infra;
    private HashMap<Integer, JackyGraphSerdes> partialSerdes = new HashMap(10);
    private IConvFormatOptions options;
    protected boolean useCompactingArrays;
    protected boolean usingPackagedResponse;

    public ApiEndpointJSonSerdes(boolean packaged, IConvFormatOptions opt) {
        this.options = opt;
        this.usingPackagedResponse = packaged;
        this.useCompactingArrays = this.options.hasMode(IConvFormatOptions.Mode.SIMPLE_ARRAYS_TO_DTO);
        this.infra = new JackyInfra();
    }

    @Override
    public <T> void createPartialSerdes(Class<T> type, boolean array) {
        JackyGraphSerdes serdes = new JackyGraphSerdes(type, this.options);
        this.partialSerdes.put(type.hashCode(), serdes);
    }

    @Override
    public IApiEndpointSerdes.Deserialized startPayload(int numFlds, String content) {
        if (content.length() == 0) {
            return new IApiEndpointSerdes.Deserialized(numFlds == 1, true, null);
        }
        JackyParsed parser = new JackyParsed();
        VParent rootObject = parser.parse(this.infra.createParser(content));
        return new IApiEndpointSerdes.Deserialized(numFlds == 1, false, rootObject);
    }

    @Override
    public void checkKnownFieldNames(IApiEndpointSerdes.Deserialized deser, String ... flds) {
        if (!deser.isSinglePayload() && !deser.hasNoContent()) {
            Object root = deser.getParsedRoot();
            if (!(root instanceof VObject)) {
                throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "The provided payload is not an object containing expected fields (but " + root.getClass().getSimpleName() + ").");
            }
            VObject rootObject = (VObject)root;
            for (VElement elem : rootObject.fields) {
                if (ApiOperationBase.contains(flds, elem.name)) continue;
                throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "The provided payload field name '" + elem.name + "' is not known to this operation.");
            }
        }
    }

    private Object parseField(IApiEndpointSerdes.Hint hint, Class type, VField fld) {
        if (type == Integer.TYPE || type == Integer.class) {
            return BaseSerdes.parseInt((String)fld.value);
        }
        if (type == String.class) {
            return fld.value;
        }
        if (type == BigDecimal.class) {
            return BaseSerdes.parseBigDecimal((IConvFormatOptions)this.options, (String)fld.value);
        }
        if (type == LocalDate.class) {
            return BaseSerdes.parseLocalDate((IConvFormatOptions)this.options, (String)fld.value);
        }
        if (type == DateTime.class) {
            return BaseSerdes.parseDateTime((IConvFormatOptions)this.options, (String)fld.value);
        }
        if (hint == IApiEndpointSerdes.Hint.STATUS) {
            return BaseSerdes.parseStatus((Class)type, (String)fld.value);
        }
        throw new RuntimeException("This can not happen. Unknown type " + type + " to deserialize as primitive.");
    }

    @Override
    public <T> T deserToVariable(IApiEndpointSerdes.Hint hint, IApiEndpointSerdes.Deserialized deser, Class type, boolean array, String fldName, boolean throwEx, T defaultObj) {
        Object at;
        Object object = at = deser.isSinglePayload() ? "root" : "'" + fldName + "'";
        if (deser.hasNoContent()) {
            if (!throwEx) {
                return defaultObj;
            }
            throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + (String)at + " but no payload provided.");
        }
        Object toParse = deser.getParsedRoot();
        if (!deser.isSinglePayload()) {
            if (!(toParse instanceof VObject)) {
                throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + (String)at + " but no json object as root given.");
            }
            VObject root = (VObject)toParse;
            toParse = null;
            for (VElement jsonFld : root.fields) {
                if (!fldName.equals(jsonFld.name)) continue;
                toParse = jsonFld;
            }
            if (toParse == null) {
                if (throwEx) {
                    throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting " + type.getSimpleName() + " at " + (String)at + " but field not provided.");
                }
                return defaultObj;
            }
        }
        if (hint == IApiEndpointSerdes.Hint.PRIMITIVE || hint == IApiEndpointSerdes.Hint.STATUS) {
            try {
                if (!array) {
                    if (!(toParse instanceof VField)) {
                        throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + (String)at + " but no field given (hint '" + toParse + "').");
                    }
                    VField fld = (VField)toParse;
                    return (T)this.parseField(hint, type, fld);
                }
                if (!(toParse instanceof VList)) {
                    throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json array for " + type.getSimpleName() + " at " + (String)at + " but no array given (hint '" + toParse + "').");
                }
                VList jsonList = (VList)toParse;
                ArrayList<Object> result = new ArrayList<Object>();
                for (VObject obj : jsonList.objects) {
                    if (obj.fields.size() != 1 || !(obj.fields.get(0) instanceof VField)) {
                        throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json array with fields for " + type.getSimpleName() + " at " + (String)at + " but no array with fields given (hint '" + obj + "').");
                    }
                    VField fld = (VField)obj.fields.get(0);
                    result.add(this.parseField(hint, type, fld));
                }
                return (T)result;
            }
            catch (SerdesException ex) {
                throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + (String)at + " - " + ex.getMessage());
            }
        }
        if (array && !(toParse instanceof VList)) {
            throw new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + (String)at + " but no array given (hint '" + toParse + "').");
        }
        if (!array && !(toParse instanceof VObject)) {
            new ApiException(ApiException.Code.JSON_FORMAT_ERROR, "Expecting json for " + type.getSimpleName() + " at " + (String)at + " but no object given (hint '" + toParse + "').");
        }
        JackyGraphSerdes partial = this.partialSerdes.get(type.hashCode());
        Object toCastAndReturn = partial.internalDeser((VParent)toParse);
        if (array) {
            return (T)Arrays.asList((Object[])toCastAndReturn);
        }
        return (T)toCastAndReturn;
    }

    @Override
    public IApiEndpointSerdes.ISerialzed startResponse(int numFlds) throws IOException {
        boolean singlePayLoad = numFlds == 1;
        StringWriter sw = new StringWriter();
        JsonGenerator gen = this.infra.createGenerator(sw, this.options.hasMode(IConvFormatOptions.Mode.PRETTY));
        if (this.usingPackagedResponse) {
            singlePayLoad = false;
            gen.writeStartObject();
            gen.writeFieldName("data");
            gen.writeStartObject();
        } else if (!singlePayLoad) {
            gen.writeStartObject();
        }
        return new JSonSerialized(gen, sw, singlePayLoad);
    }

    public CField.OFXType resolveType(IApiEndpointSerdes.Hint hnt, Class type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return CField.OFXType.OFX_INT;
        }
        if (type == String.class) {
            return CField.OFXType.OFX_STRING;
        }
        if (type == BigDecimal.class) {
            return CField.OFXType.OFX_BIGDECIMAL;
        }
        if (type == LocalDate.class) {
            return CField.OFXType.OFX_LOCALDATE;
        }
        if (type == DateTime.class) {
            return CField.OFXType.OFX_DATETIME;
        }
        if (type == byte[].class) {
            throw new RuntimeException("byte[] not supported yet.");
        }
        if (hnt == IApiEndpointSerdes.Hint.STATUS) {
            return CField.OFXType.OFX_STATUS;
        }
        throw new RuntimeException("This can not happen. Unknown type " + type);
    }

    @Override
    public void serVar(IApiEndpointSerdes.Hint hint, IApiEndpointSerdes.ISerialzed serToCast, Class ct, boolean array, String fldName, Object value) throws IOException {
        JSonSerialized ser = (JSonSerialized)serToCast;
        if (hint == IApiEndpointSerdes.Hint.PRIMITIVE || hint == IApiEndpointSerdes.Hint.STATUS) {
            CField.OFXType type = this.resolveType(hint, ct);
            if (array && value != null) {
                List listOfPrim = (List)value;
                if (this.usingPackagedResponse && !ser.isSinglePayload()) {
                    ser.gen().writeFieldName(fldName);
                }
                ser.gen().writeStartArray();
                for (Object obj : listOfPrim) {
                    JackyFieldSerdes.serField((JsonGenerator)ser.gen(), (IConvFormatOptions)this.options, (CField.OFXType)type, (String)"", obj, (boolean)true);
                }
                ser.gen().writeEndArray();
            } else {
                JackyFieldSerdes.serField((JsonGenerator)ser.gen(), (IConvFormatOptions)this.options, (CField.OFXType)type, (String)fldName, (Object)value, (boolean)ser.isSinglePayload());
            }
        } else {
            JackyGraphSerdes partial = this.partialSerdes.get(ct.hashCode());
            if (array) {
                List list = (List)value;
                value = list.toArray();
            }
            partial.internalSer(ser.gen(), fldName, (Object)value, ser.isSinglePayload());
        }
    }

    @Override
    public void writeResponse(HttpServletResponse __response, IApiEndpointSerdes.ISerialzed ser, List<IOFXProblem> warnings) throws IOException {
        JSonSerialized jSonSerialized = (JSonSerialized)ser;
        JsonGenerator gen = jSonSerialized.gen();
        if (this.usingPackagedResponse) {
            gen.writeEndObject();
            gen.writeNumberField("status", 200);
            gen.writeStringField("error", "NONE");
            gen.writeStringField("desc", "success, processing completed");
            JSonApiErrorReporter.writeProblems(gen, warnings);
            gen.writeEndObject();
        } else if (!jSonSerialized.isSinglePayload()) {
            jSonSerialized.gen().writeEndObject();
        }
        jSonSerialized.gen().close();
        __response.setStatus(200);
        __response.setContentType("application/json");
        __response.getWriter().write(jSonSerialized.asString());
    }

    @Override
    public void serPrimitive(HttpServletResponse __response, Object value, List<IOFXProblem> warnings) throws IOException {
        __response.setStatus(200);
        __response.setContentType("text/plain");
        __response.getWriter().print(value);
    }
}

