/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.httpapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiException;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;

public abstract class ApiOperationBase {
    protected String __location;
    protected String __method;
    protected boolean __needsTransactionFlush;

    public ApiOperationBase(String method, String loc, boolean transact) {
        this.__method = method;
        this.__location = loc;
        this.__needsTransactionFlush = transact;
    }

    public String getLocation() {
        return this.__location;
    }

    public String getMethod() {
        return this.__method;
    }

    public boolean needsTransactionFlush() {
        return this.__needsTransactionFlush;
    }

    public abstract void executeOp(HttpServletRequest var1, HttpServletResponse var2, IOFXSession var3) throws Exception;

    public static String convString(String nameAndType, String data, boolean throwEx, String defaultString) {
        if (data != null) {
            return data;
        }
        if (!throwEx) {
            return defaultString;
        }
        throw new ApiException(ApiException.Code.REQ_FIELD_NECESSARY, "The " + nameAndType + " is not specified in the request.");
    }

    public static List<String> convListString(String nameAndType, String data, boolean throwEx, List<String> defaultList) {
        if (data != null) {
            try {
                List<String> all = Arrays.asList(data.split(","));
                for (int i = 0; i < all.size(); ++i) {
                    all.set(i, all.get(i).trim());
                }
                return all;
            }
            catch (Exception ex) {
                throw new ApiException(ApiException.Code.CONVERSION_ERROR_ON_PRIMITIVE, "The " + nameAndType + " with value '" + data + "' can not be converted to a list of strings (" + ex.getClass().getName() + " - " + ex.getMessage() + ").");
            }
        }
        if (!throwEx) {
            return defaultList;
        }
        throw new ApiException(ApiException.Code.REQ_FIELD_NECESSARY, "The " + nameAndType + " is not specified in the request.");
    }

    public static int convInt(String nameAndType, String data, boolean throwEx, int defaultint) {
        if (data != null) {
            try {
                return Integer.valueOf(data);
            }
            catch (NumberFormatException ex) {
                throw new ApiException(ApiException.Code.CONVERSION_ERROR_ON_PRIMITIVE, "The " + nameAndType + " with value '" + data + "' can not be converted to an integer.");
            }
        }
        if (!throwEx) {
            return defaultint;
        }
        throw new ApiException(ApiException.Code.REQ_FIELD_NECESSARY, "The " + nameAndType + " is not specified in the request.");
    }

    public static List<Integer> convListInt(String nameAndType, String data, boolean throwEx, List<Integer> defaultList) {
        if (data != null) {
            try {
                List<String> all = Arrays.asList(data.split(","));
                ArrayList<Integer> converted = new ArrayList<Integer>(all.size());
                for (int i = 0; i < all.size(); ++i) {
                    converted.add(Integer.valueOf(all.get(i).trim()));
                }
                return converted;
            }
            catch (Exception ex) {
                throw new ApiException(ApiException.Code.CONVERSION_ERROR_ON_PRIMITIVE, "The " + nameAndType + " with value '" + data + "' can not be converted to a list of integers (" + ex.getClass().getName() + " - " + ex.getMessage() + ").");
            }
        }
        if (!throwEx) {
            return defaultList;
        }
        throw new ApiException(ApiException.Code.REQ_FIELD_NECESSARY, "The " + nameAndType + " is not specified in the request.");
    }

    public static void checkForUnknownParams(HttpServletRequest req, String ... paramDeclNames) {
        Enumeration givenParams = req.getParameterNames();
        while (givenParams.hasMoreElements()) {
            String key = (String)givenParams.nextElement();
            if (ApiOperationBase.contains(paramDeclNames, key)) continue;
            throw new ApiException(ApiException.Code.UNKNOWN_PARAM, "The parameter '" + key + "' is not known to this operation.");
        }
    }

    protected static boolean contains(String[] array, String key) {
        for (String elem : array) {
            if (!key.equals(elem)) continue;
            return true;
        }
        return false;
    }

    public static String primitiveListResponse(List lst) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lst.size(); ++i) {
            sb.append(lst.get(i).toString());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String data = "dan, man ,pete";
        System.err.println("" + data.split(","));
    }
}

