/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.httpapi;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.modellwerkstatt.dataux.runtime.httpapi.ApiException;
import org.modellwerkstatt.dataux.runtime.httpapi.IApiErrorReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.serdes.SerdesException;

public class TextApiErrorReporter
implements IApiErrorReporter {
    @Override
    public void reportApiExFieldNamesProblem(HttpServletResponse resp, ApiException apiEx) throws IOException {
        TextApiErrorReporter.prepareErrorResponse(resp, 400, apiEx.getErrorCode(), apiEx.getMessage(), apiEx);
    }

    @Override
    public void reportSerdesProblem(HttpServletResponse resp, SerdesException ex) throws IOException {
        TextApiErrorReporter.prepareErrorResponse(resp, 400, ApiException.Code.JSON_FORMAT_ERROR.intCode, ex.getMessage(), ex);
    }

    @Override
    public void reportOfxProblems(HttpServletResponse resp, List<IOFXProblem> problms) throws IOException {
        TextApiErrorReporter.prepareErrorResponse(resp, 202, 0, "Operation aborted.\n" + OFXConsoleHelper.asSimpleString(problms), null);
    }

    @Override
    public void reportInternalProblem(HttpServletResponse resp, Exception ex) throws IOException {
        TextApiErrorReporter.prepareErrorResponse(resp, 500, 0, "internal server error", ex);
    }

    @Override
    public void notFound(HttpServletResponse resp) throws IOException {
        TextApiErrorReporter.prepareErrorResponse(resp, 404, 0, "not found", null);
    }

    private static void prepareErrorResponse(HttpServletResponse resp, int httpCode, int subcode, String text, Throwable tToDebug) throws IOException {
        resp.resetBuffer();
        resp.setHeader("Content-Type", "text/plain");
        resp.setStatus(httpCode);
        String st = "" + httpCode;
        if (subcode > 0) {
            st = st + "." + subcode;
        }
        if (text != null) {
            st = st + " : " + text;
        }
        if (tToDebug != null) {
            st = st + "\n     \n" + OFXConsoleHelper.stackTrace2String((Throwable)tToDebug);
        }
        resp.getWriter().print(st);
    }
}

