/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.sdicore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.dataux.runtime.core.ApplicationBasis;
import org.modellwerkstatt.dataux.runtime.core.BasisCmdStart;
import org.modellwerkstatt.dataux.runtime.core.IApplication;
import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.IEventProcessor;
import org.modellwerkstatt.dataux.runtime.core.ISelectionController;
import org.modellwerkstatt.dataux.runtime.core.IUpdateConclusionReceiver;
import org.modellwerkstatt.dataux.runtime.genspecifications.AbstractAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.CmdAction;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenSelControlled;
import org.modellwerkstatt.dataux.runtime.genspecifications.Menu;
import org.modellwerkstatt.dataux.runtime.genspecifications.TileAction;
import org.modellwerkstatt.dataux.runtime.sdicore.LandingPageDummyProcessor;
import org.modellwerkstatt.dataux.runtime.sdicore.LandingPageUrlItem;
import org.modellwerkstatt.dataux.runtime.sdicore.WindowControllerSDI;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXUrlParams;

public abstract class ApplicationSDI
extends ApplicationBasis {
    protected List<IOFXCmdModule.CmdUrlDefaults> allUrlDefaults;
    protected String availableCmdUrlsDescription;
    private List<TileAction> tileActions;
    private List<LandingPageUrlItem> tileActionsUrlItems;
    private List<CmdAction> menuActions;
    private LandingPageUrlItem rootOfMainMenu;
    private WindowControllerSDI crtlPickingUp;
    private IToolkit_CommandContainerUi uiToPickup;
    private String urlToPickupFrom;
    private boolean potentialStartupCmdExecuted;
    private List<WindowControllerSDI> allWindows;
    private String appLockedByModalName = null;
    private ISelectionController dummySelCrtl = new ISelectionController(){

        @Override
        public ISelectionController registerSelControlled(Class interestedInSelectionType, ISelectionController.Binding binding, IGenSelControlled xuElemToRegister) {
            return null;
        }

        @Override
        public IOFXSelection getSelectionAbsolute(Class cls, boolean includingDerived) {
            return null;
        }

        @Override
        public void pushSelectionAbsolute(IOFXSelection sel) {
            throw new RuntimeException("DummySelCrtl - not implemented.");
        }

        public void forceNotEditable() {
            throw new RuntimeException("DummySelCrtl - not implemented.");
        }

        @Override
        public IOFXSelection getLocalSelection() {
            return null;
        }

        @Override
        public void issueUpdateConclusion(IUpdateConclusionReceiver.IFocusAbleDelegate newFocusHolder) {
            throw new RuntimeException("DummySelCrtl - not implemented.");
        }
    };
    private IEventProcessor appLandingPageProcessor;

    public ApplicationSDI(IToolkit_UiFactory factory, IGenAppUiModule appBehavior, AppJmxRegistration registration, IOFXCoreReporter.MoWarePlatform pltfrm) {
        super(factory, appBehavior, registration, pltfrm);
    }

    private void initMenuAccordingUrlDefaults(Menu menu, LandingPageUrlItem item) {
        for (AbstractAction action : menu.getAllItems()) {
            if (action instanceof CmdAction) {
                CmdAction cmdAction = (CmdAction)action;
                IOFXCmdModule.CmdUrlDefaults urlDefault = (IOFXCmdModule.CmdUrlDefaults)ListSequence.fromList(this.allUrlDefaults).findFirst(urlCmd -> urlCmd.cmdFqName.equals(cmdAction.commandFqName));
                if (urlDefault == null) continue;
                ListSequence.fromList(this.menuActions).addElement((Object)cmdAction);
                cmdAction.configure(this.uiFactory, this.appLandingPageProcessor, this.dummySelCrtl, this.userEnvironment.getLangIndex());
                item.addToSubMenu(new LandingPageUrlItem(cmdAction.hashCode(), urlDefault.url, cmdAction.labelText, cmdAction.getToolTip(), cmdAction.image, null, cmdAction.hotKey, false));
                continue;
            }
            if (action instanceof Menu) {
                Menu subMenu = (Menu)action;
                if (subMenu.labelText != null) {
                    subMenu.configureLabel(this.uiFactory.getTransProvider().translateSingle(this.userEnvironment.getLangIndex(), subMenu.labelText));
                }
                LandingPageUrlItem newItem = new LandingPageUrlItem(subMenu.labelText);
                this.initMenuAccordingUrlDefaults(subMenu, newItem);
                if (!newItem.hasItemsInSubMenu()) continue;
                item.addToSubMenu(newItem);
                continue;
            }
            if (!item.hasItemsInSubMenu()) continue;
            item.addToSubMenu(new LandingPageUrlItem(0, null, null, null, null, null, null, false));
        }
    }

    protected void initializeApplication(List<IOFXCmdModule.CmdUrlDefaults> defaults, String systemName, IOFXUserEnvironment userEnv, String userConnectionInfo, String startupInfo) {
        this.potentialStartupCmdExecuted = false;
        this.allUrlDefaults = defaults;
        this.availableCmdUrlsDescription = String.join((CharSequence)" , ", (Iterable<? extends CharSequence>)ListSequence.fromList(this.allUrlDefaults).select(it -> it.urlAndParamDescription));
        this.userEnvironment = userEnv;
        this.userEnvironment.setAppStartupLocalMillis(System.currentTimeMillis());
        this.userLoggedIn(systemName, userEnv, userConnectionInfo, startupInfo, this.applicationBehaviour.getClass().getName(), this.applicationBehaviour.getShortAppName(), this.applicationBehaviour.getApplicationVersion());
        this.applicationBehaviour.userLoggedIn(userEnv, this);
        IOFXSession lpdSession = this.uiFactory.createNewSession(this.userEnvironment, this);
        this.appLandingPageProcessor = new LandingPageDummyProcessor(lpdSession);
        List<TileAction> allTiles = this.applicationBehaviour.createAppTileActions(this.uiFactory, this.userEnvironment);
        ListSequence.fromList(allTiles).visitAll(it -> it.setupTileAction());
        this.tileActions = ListSequence.fromList(new ArrayList());
        this.tileActionsUrlItems = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(allTiles).visitAll(it -> {
            IOFXCmdModule.CmdUrlDefaults urlDefault = (IOFXCmdModule.CmdUrlDefaults)ListSequence.fromList(this.allUrlDefaults).findFirst(urlCmd -> urlCmd.cmdFqName.equals(it.getAction().commandFqName));
            if (urlDefault != null) {
                ListSequence.fromList(this.tileActions).addElement(it);
                CmdAction action = it.getAction();
                action.configure(this.uiFactory, this.appLandingPageProcessor, this.dummySelCrtl, this.userEnvironment.getLangIndex());
                ListSequence.fromList(this.tileActionsUrlItems).addElement((Object)new LandingPageUrlItem(it.hashCode(), urlDefault.url, action.labelText, action.getToolTip(), action.image, it.getColor(), action.hotKey, false));
            }
        });
        this.menuActions = ListSequence.fromList(new ArrayList());
        this.rootOfMainMenu = new LandingPageUrlItem("Root");
        Menu menu = this.applicationBehaviour.createStartMenu(this.userEnvironment);
        this.initMenuAccordingUrlDefaults(menu, this.rootOfMainMenu);
        menu = this.applicationBehaviour.createExtrasMenu(this.userEnvironment);
        this.initMenuAccordingUrlDefaults(menu, this.rootOfMainMenu);
        menu = this.applicationBehaviour.createHelpMenu(this.userEnvironment);
        this.initMenuAccordingUrlDefaults(menu, this.rootOfMainMenu);
        this.logAppTrace("", "", "org.modellwerkstatt.Login", "application startup", this.getuser_connectionInfoAddOn(), null);
        this.allWindows = ListSequence.fromList(new LinkedList());
    }

    public boolean hasToRunStartupCmdAsModalFirst(OFXUrlParams checkStartupCmd, IToolkit_Window win) {
        if (!this.potentialStartupCmdExecuted) {
            BasisCmdStart cmdStart = this.applicationBehaviour.createStartupCmd(this.appLandingPageProcessor.getSession());
            if (cmdStart == null) {
                this.potentialStartupCmdExecuted = true;
            } else {
                IOFXCmdModule.CmdUrlDefaults def = null;
                if (checkStartupCmd != null && checkStartupCmd.hasCmdName()) {
                    def = this.getUrlDefaultFor(this.uiFactory.getAllCmdUrlDefaults(), checkStartupCmd);
                }
                if (def != null && cmdStart.getCommandName().equals(def.cmdFqName)) {
                    this.potentialStartupCmdExecuted = true;
                } else {
                    if (!cmdStart.hasParamsSet()) {
                        IOFXCmdModule mod = this.uiFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName((String)cmdStart.getCommandName()));
                        cmdStart = cmdStart.cloneWithParams(mod.getCommandDefaultParams(cmdStart.getCommandName(), null, (Object)false));
                    }
                    this.potentialStartupCmdExecuted = true;
                    this.intenal_startCmd(false, cmdStart, win, true);
                    this.setCurrentAsAppStartupContainer();
                    return true;
                }
            }
        }
        return false;
    }

    public List<LandingPageUrlItem> updateLandingPageTileUrlItems() {
        for (int i = 0; i < ListSequence.fromList(this.tileActions).count(); ++i) {
            TileAction tile = (TileAction)ListSequence.fromList(this.tileActions).getElement(i);
            LandingPageUrlItem item = (LandingPageUrlItem)ListSequence.fromList(this.tileActionsUrlItems).getElement(i);
            CmdAction action = tile.getAction();
            tile.calcAndSetCurrentTileLabel(this.appLandingPageProcessor.getSession());
            item.enabled = tile.getAction().reevalEnabled();
            item.label = action.labelText;
        }
        return this.tileActionsUrlItems;
    }

    private int checkEnabledForMenu(int index, LandingPageUrlItem menu) {
        if (!menu.isSubMenu()) {
            throw new RuntimeException("This can not happen..");
        }
        for (LandingPageUrlItem item : menu.getSubItems()) {
            if (item.isSeperator()) continue;
            if (item.isSubMenu()) {
                index = this.checkEnabledForMenu(index, item);
                continue;
            }
            CmdAction action = (CmdAction)ListSequence.fromList(this.menuActions).getElement(index);
            item.enabled = action.reevalEnabled();
            ++index;
        }
        return index;
    }

    public List<LandingPageUrlItem> updateLandingPageMenuUrlItems() {
        this.checkEnabledForMenu(0, this.rootOfMainMenu);
        return this.rootOfMainMenu.getSubItems();
    }

    @Override
    public void reevalEnabledInMenusAndTiles() {
    }

    @Override
    public IOFXSession getMainWindowEvalSession() {
        return null;
    }

    public boolean noGraphsToCommit() {
        for (int i = 0; i < ListSequence.fromList(this.allWindows).count(); ++i) {
            if (!((WindowControllerSDI)ListSequence.fromList(this.allWindows).getElement(i)).hasRwSessionToCommit()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkForAppParDeploymentForward() {
        boolean forwardPlease = false;
        if (this.getAppTelemetrics().isParDeploymentForwardImmediate() || this.getAppTelemetrics().isParDeploymentForwardGracefully() && this.noGraphsToCommit()) {
            forwardPlease = true;
            if (!this.userAlreadyNotifiedParDeplyForward) {
                this.userAlreadyNotifiedParDeplyForward = true;
                for (int i = 0; i < ListSequence.fromList(this.allWindows).count(); ++i) {
                    WindowControllerSDI win = (WindowControllerSDI)ListSequence.fromList(this.allWindows).getElement(i);
                    win.showSimpleInfoDialog(this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.APPLICATION_LOCKED), new IApplication.DlgRunnable(){

                        @Override
                        public void run(boolean confirmed) {
                            ApplicationSDI.this.internal_shutdownSDIAppImmediatelly();
                            ApplicationSDI.this.parDeployForward();
                        }
                    });
                }
            }
        }
        return forwardPlease;
    }

    public abstract void parDeployForward();

    @Override
    public boolean isSameInstanceRunningThenFocus(String fqName, Object[] params) {
        for (int i = 0; i < this.allRunningContainersToTerminate.size(); ++i) {
            if (!((ICommandContainer)this.allRunningContainersToTerminate.get(i)).isSameCommandInstance(fqName, params)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IToolkit_MainWindow getMainWindowImpl() {
        return null;
    }

    @Override
    public String fullApplicationCrtlState() {
        return "This is the SDI Application Crtl\nCurrently with " + ListSequence.fromList(this.allWindows).count() + ". In shutdown mode is " + this.shutdownMode;
    }

    public void startWithNewCrtl(IToolkit_Window parentWin, BasisCmdStart toStart) {
        WindowControllerSDI sdi;
        toStart.forceToThisWindowCrtl();
        this.crtlPickingUp = sdi = new WindowControllerSDI(this.uiFactory, this, parentWin);
        ListSequence.fromList(this.allWindows).addElement((Object)sdi);
        sdi.receiveAndProcess(toStart);
    }

    public void setUiForPickup(String url, IToolkit_CommandContainerUi ui) {
        this.urlToPickupFrom = url;
        this.uiToPickup = ui;
    }

    public boolean hasCrtlAwaitingPickup() {
        return this.crtlPickingUp != null;
    }

    public boolean wasPickupCmdThenStart(IToolkit_Window newWindow, OFXUrlParams params) {
        if (params.asUrl().equals(this.urlToPickupFrom)) {
            this.crtlPickingUp.swapWindows(newWindow);
            this.crtlPickingUp = null;
            newWindow.addTab(this.uiToPickup);
            this.uiToPickup = null;
            this.urlToPickupFrom = null;
            return true;
        }
        return false;
    }

    public String startLandingPageCmdViaHash(IToolkit_Window win, int hash) {
        if (this.appLockedByModalName != null) {
            return String.format(this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.APP_IN_MODAL_NO_CMD_START), this.appLockedByModalName);
        }
        TileAction tileAction = (TileAction)ListSequence.fromList(this.tileActions).findFirst(it -> it.hashCode() == hash);
        CmdAction toStart = tileAction != null ? tileAction.getAction() : (CmdAction)ListSequence.fromList(this.menuActions).findFirst(it -> it.hashCode() == hash);
        if (toStart == null) {
            throw new RuntimeException("This can not happen.");
        }
        Object[] localParams = toStart.calculateParams(null);
        BasisCmdStart ev = toStart.configCompoundOuterCmdStartOrJustBasisCmdStart(localParams);
        ev.setLabelText(toStart.labelText);
        this.intenal_startCmd(true, ev, win, false);
        return null;
    }

    public String startCommandViaUrl(boolean withPickup, IToolkit_Window win, OFXUrlParams urlParam) {
        IOFXCmdModule.CmdUrlDefaults infoForCmd = this.getUrlDefaultFor(this.allUrlDefaults, urlParam);
        if (this.appLockedByModalName != null) {
            return String.format(this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.APP_IN_MODAL_NO_CMD_START), this.appLockedByModalName);
        }
        if (infoForCmd == null) {
            return String.format(this.uiFactory.getSystemLabel(this.userLangIndex, MoWareTranslations.Key.CMD_NOT_AVAILABLE), this.availableCmdUrlsDescription);
        }
        BasisCmdStart ev = this.cmdStartForUrlDefault(infoForCmd, urlParam, this.appLandingPageProcessor.getSession());
        this.intenal_startCmd(withPickup, ev, win, false);
        return null;
    }

    private void intenal_startCmd(boolean withPickup, BasisCmdStart ev, IToolkit_Window win, boolean isStartup) {
        ev.forceToThisWindowCrtl();
        WindowControllerSDI sdi = new WindowControllerSDI(this.uiFactory, this, win);
        if (isStartup) {
            sdi.setModal();
        }
        if (withPickup) {
            this.crtlPickingUp = sdi;
        }
        ListSequence.fromList(this.allWindows).addElement((Object)sdi);
        sdi.receiveAndProcess(ev);
    }

    public void closedWindowCrtl(WindowControllerSDI crtl) {
        if (!ListSequence.fromList(this.allWindows).contains((Object)crtl)) {
            throw new RuntimeException("This can not happen. The crtl " + crtl + " is not part of our " + ListSequence.fromList(this.allWindows).count() + " windows.");
        }
        ListSequence.fromList(this.allWindows).removeElement((Object)crtl);
    }

    public void setModal(WindowControllerSDI themodalWindow, String name) {
        if (themodalWindow != null && this.appLockedByModalName != null) {
            throw new RuntimeException("This can not happen.");
        }
        if (themodalWindow == null) {
            this.applicationModalTabMode = false;
            this.appLockedByModalName = null;
            ListSequence.fromList(this.allWindows).visitAll(it -> it.lockWindow(false));
        } else {
            this.applicationModalTabMode = true;
            this.appLockedByModalName = name;
            ListSequence.fromList(this.allWindows).visitAll(it -> {
                boolean isModalWin = it == themodalWindow;
                it.lockWindow(!isModalWin);
            });
        }
    }

    public void external_closeBrowserTab(IToolkit_Window win) {
        WindowControllerSDI crtl = (WindowControllerSDI)ListSequence.fromList(this.allWindows).findFirst(it -> it.responsibleFor(win));
        if (crtl != null) {
            crtl.externalClose();
        }
    }

    public void internal_shutdownSDIAppImmediatelly() {
        if (!this.shutdownMode) {
            this.afterStartupCmd = null;
            ArrayList allContainers = new ArrayList(this.allRunningContainersToTerminate);
            Collections.reverse(allContainers);
            for (ICommandContainer c : allContainers) {
                c.internal_immediatelyShutdown();
            }
        }
        this.shutdownMode = true;
    }

    public String getAppVersionAndDyn() {
        return this.userEnvironment.getUserName() + " - " + this.applicationBehaviour.getShortAppName() + " " + this.applicationBehaviour.getApplicationVersion() + " " + this.userEnvironment.getDynamicStatusInfo();
    }

    public boolean inShutdownMode() {
        return this.shutdownMode;
    }

    public String toString() {
        Object cmdsOpen = "";
        for (ICommandContainer cc : this.allRunningContainersToTerminate) {
            cmdsOpen = (String)cmdsOpen + cc + ", ";
        }
        return this.getClass().getSimpleName() + "_" + this.hashCode() % 1000 + " (" + (String)cmdsOpen + ")";
    }
}

