/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.sdicore;

import java.util.ArrayList;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class LandingPageUrlItem {
    public String url;
    public String label;
    public String tooltip;
    public String icon;
    public String color;
    public String hotkey;
    public boolean enabled;
    public int actionHashcode;
    public List<LandingPageUrlItem> subItems;

    public LandingPageUrlItem(int hash, String aUrl, String aLabel, String aTooltip, String aIcon, String aColor, String aHotkey, boolean aEnabled) {
        this.url = aUrl;
        this.label = aLabel;
        this.tooltip = aTooltip;
        this.icon = aIcon;
        this.color = aColor;
        this.hotkey = aHotkey;
        this.enabled = aEnabled;
        this.actionHashcode = hash;
    }

    public LandingPageUrlItem(String aLabel) {
        this.label = aLabel;
        this.subItems = ListSequence.fromList(new ArrayList());
    }

    public boolean isSubMenu() {
        return this.subItems != null;
    }

    public boolean hasItemsInSubMenu() {
        return ListSequence.fromList(this.subItems).count() > 0;
    }

    public void addToSubMenu(LandingPageUrlItem itm) {
        ListSequence.fromList(this.subItems).addElement((Object)itm);
    }

    public List<LandingPageUrlItem> getSubItems() {
        return this.subItems;
    }

    public boolean isSeperator() {
        return this.label == null;
    }

    public String toString() {
        if (this.isSubMenu()) {
            return "SubMenu (" + ListSequence.fromList(this.subItems).count() + ")";
        }
        if (this.isSeperator()) {
            return "---";
        }
        return this.label;
    }

    public static String print(String ident, LandingPageUrlItem menu) {
        if (!menu.isSubMenu()) {
            throw new RuntimeException("This can not happen.");
        }
        Object st = "";
        for (LandingPageUrlItem item : menu.getSubItems()) {
            if (item.isSeperator()) {
                st = (String)st + ident + "--- \n";
                continue;
            }
            if (item.isSubMenu()) {
                st = (String)st + ident + "-- " + item.label + " -- \n";
                st = (String)st + LandingPageUrlItem.print(ident + "     ", item) + "\n";
                continue;
            }
            st = (String)st + ident + item.label + "\n";
        }
        return st;
    }
}

