/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.sdicore;

import org.modellwerkstatt.dataux.runtime.core.ICommandContainer;
import org.modellwerkstatt.dataux.runtime.core.WindowController;
import org.modellwerkstatt.dataux.runtime.sdicore.ApplicationSDI;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Window;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;

public class WindowControllerSDI
extends WindowController {
    private ICommandContainer windowContainer;
    private ICommandContainer promptContainer;
    private boolean externalModalSet = false;

    public WindowControllerSDI(IToolkit_UiFactory uf, ApplicationSDI theApp, IToolkit_Window win) {
        super(uf, theApp, win);
    }

    protected ApplicationSDI getTheApp() {
        return (ApplicationSDI)this.app;
    }

    @Override
    public void sameInstanceRunningUserNotification() {
        this.showSimpleInfoDialog(this.uiFactory.getSystemLabel(this.app.getUserEnvironment().getLangIndex(), MoWareTranslations.Key.CMD_OPENED_IN_OTHER_TAB), null);
    }

    @Override
    public void showCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, String windowTitle, IToolkit_Form content) {
        content.rootForm();
        ui.show(windowTitle, content);
        if (ui.isTabWindow()) {
            if (this.windowContainer != null) {
                throw new RuntimeException("This can not happen. WindowContainer is " + this.windowContainer + " and the tab to show is " + cc);
            }
            this.windowContainer = cc;
            this.window.addTab(ui);
            if (ui.isModalTabWindow() || this.externalModalSet) {
                this.getTheApp().setModal(this, windowTitle);
            }
        } else {
            if (this.promptContainer != null) {
                throw new RuntimeException("This can not happen. PromptContainer is " + this.promptContainer + " and the prompt to show is " + cc);
            }
            this.promptContainer = cc;
        }
    }

    @Override
    public void closeCommandContainerUI(ICommandContainer cc, IToolkit_CommandContainerUi ui, ICommandContainer parent) {
        if (ui.isTabWindow()) {
            this.window.ensureTabClosed(ui);
            if (ui.isModalTabWindow() || this.externalModalSet) {
                this.getTheApp().setModal(null, null);
            }
            this.getTheApp().closedWindowCrtl(this);
        } else {
            this.promptContainer = null;
        }
        ui.close();
    }

    @Override
    public void focusTab(ICommandContainer cc, IToolkit_CommandContainerUi ui) {
        this.window.focusTab(ui);
    }

    public void swapWindows(IToolkit_Window win) {
        this.window = win;
    }

    public boolean responsibleFor(IToolkit_Window win) {
        return this.window == win;
    }

    public void lockWindow(boolean lock) {
        if (lock) {
            if (this.promptContainer != null) {
                this.promptContainer.internal_immediatelyShutdown();
            }
            this.window.setCurrentTabModal(true);
        } else {
            this.window.setCurrentTabModal(false);
        }
    }

    public boolean hasRwSessionToCommit() {
        if (this.windowContainer == null) {
            return false;
        }
        return this.windowContainer.hasRwSessionToCommit();
    }

    public void externalClose() {
        if (this.promptContainer != null) {
            this.promptContainer.internal_immediatelyShutdown();
        }
        this.windowContainer.internal_immediatelyShutdown();
    }

    public void setModal() {
        this.externalModalSet = true;
    }
}

