/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.services;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import mjson.Json;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.modellwerkstatt.dataux.runtime.core.EventCommandContainer;
import org.modellwerkstatt.dataux.runtime.services.DynLockStateHolder;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UiFactory;
import org.modellwerkstatt.javaxbus.ConsumerHandler;
import org.modellwerkstatt.javaxbus.Message;
import org.modellwerkstatt.objectflow.runtime.IMoEventBusService;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;

public class ImplDynLockQuery
implements ConsumerHandler,
DynLockStateHolder {
    private IMoEventBusService bus;
    private Map<String, String> locksAndUsers;
    private String problem;
    private long ebLockRequestedTimeStamp;
    private String userName;
    private String deviceName;
    private String sessId;
    private long appStartupLocalMillis;
    private IOFXUserServices userServices;

    public ImplDynLockQuery(IToolkit_UiFactory uiFactory, IOFXSession session) {
        this.bus = uiFactory.getEventBus();
        this.locksAndUsers = MapSequence.fromMap(new HashMap());
        this.problem = null;
        this.userName = session.getUserEnvironment().getUserName();
        this.deviceName = session.getUserEnvironment().getDeviceName();
        this.ebLockRequestedTimeStamp = 0L;
        this.appStartupLocalMillis = session.getUserEnvironment().getAppStartupLocalMillis();
        this.userServices = session.getUserServices();
        this.sessId = session.getSessionLoggingId();
    }

    @Override
    public void requestLocks(List<String> requestedLocks) {
        if (this.ebLockRequestedTimeStamp != 0L) {
            throw new RuntimeException("Do not call requestLocks twice!");
        }
        this.bus.register((ConsumerHandler)this, "locking");
        this.ll("requesteLocks", "bus receiver registered.");
        for (String lockName : requestedLocks) {
            String lowerLockName = lockName.toLowerCase();
            String lockingInstanceName = lowerLockName + "_" + this.hashCode();
            String lockingUserName = "".equals(this.deviceName) ? this.userName : this.userName + " " + this.deviceName;
            this.ebLockRequestedTimeStamp = System.currentTimeMillis();
            MapSequence.fromMap(this.locksAndUsers).put((Object)lowerLockName, (Object)"");
            this.bus.publish("locking", Json.object().set("type", (Object)"requestLock").set("lockName", (Object)lowerLockName).set("userName", (Object)lockingUserName).set("userInstanceName", (Object)lockingInstanceName).set("requestTimestamp", (Object)this.ebLockRequestedTimeStamp).set("containerHash", (Object)this.hashCode()).set("appStartup", (Object)this.appStartupLocalMillis));
            this.ll("requestLocks", "sent req. for " + lowerLockName);
        }
    }

    @Override
    public void ensureLocksReceived(long minMillisWaitTime) {
        try {
            long diff = System.currentTimeMillis() - this.ebLockRequestedTimeStamp;
            this.ll("ensureLocksRecieved", "diff to wait is " + diff + "ms");
            if (diff < minMillisWaitTime) {
                long timeToWaitAdditionally = minMillisWaitTime - diff;
                Thread.sleep(timeToWaitAdditionally);
                this.ll("ensureLocksReceived", "ok, we waited additionally " + timeToWaitAdditionally + "ms");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String userHoldingLock(String lockName) {
        String relevantLock = lockName.toLowerCase();
        if (!MapSequence.fromMap(this.locksAndUsers).containsKey((Object)relevantLock)) {
            return null;
        }
        String result = (String)MapSequence.fromMap(this.locksAndUsers).get((Object)relevantLock);
        if ("".equals(result)) {
            return null;
        }
        return result;
    }

    @Override
    public boolean anyLockNotGranted() {
        return this.firstUserHoldingALock() != null;
    }

    @Override
    public String firstUserHoldingALock() {
        if (this.problem != null) {
            throw new RuntimeException(this.problem);
        }
        for (String key : MapSequence.fromMap(this.locksAndUsers).keySet()) {
            if ("".equals(MapSequence.fromMap(this.locksAndUsers).get((Object)key))) continue;
            this.ll("firstUserHoldingALock", "oh, we have a lock for " + (String)MapSequence.fromMap(this.locksAndUsers).get((Object)key));
            return (String)MapSequence.fromMap(this.locksAndUsers).get((Object)key);
        }
        return null;
    }

    public void handle(Message busMsg) {
        if (busMsg.isErrorMsg()) {
            this.problem = "EB BUS ERROR (from EB, but EB still running) " + busMsg.getErrMessage() + " / " + busMsg.getErrFailureCode() + " / " + busMsg.getErrFailureType();
            return;
        }
        Json body = busMsg.getBodyAsMJson();
        if (!body.has("type")) {
            this.problem = "EB BUS ERROR (still running, received an unknown message with no type)" + body.toString();
            return;
        }
        String type = body.at("type").asString();
        if ("locked".equals(type)) {
            long appStartup;
            String lockName = body.has("lockName") ? body.at("lockName").asString().toLowerCase() : "";
            String byUserName = body.has("userName") ? body.at("userName").asString() : "";
            String userInstanceName = body.has("userInstanceName") ? body.at("userInstanceName").asString() : "";
            long requestContainerHash = body.has("containerHash") ? body.at("containerHash").asLong() : 0L;
            long lockTimestamp = body.has("lockTimestamp") ? body.at("lockTimestamp").asLong() : 0L;
            long l = appStartup = body.has("appStartup") ? body.at("appStartup").asLong() : 0L;
            if (this.userServices != null) {
                HashMap<String, CallSite> parameterMap = new HashMap<String, CallSite>();
                String paramSt = "lock hold since " + EventCommandContainer.LOCK_DBG_TIME_FRMT.print(lockTimestamp) + " (appstart " + EventCommandContainer.LOCK_DBG_TIME_FRMT.print((ReadableInstant)new DateTime(appStartup)) + ")";
                parameterMap.put("param", (CallSite)((Object)paramSt));
                this.userServices.logOnCoreReporter(this.getClass().getName(), this.sessId, "org.modellwerkstatt.Locking", IOFXCoreReporter.LogPriority.TRACE, "received lock not granted for " + lockName + " (held by " + byUserName + ")", parameterMap);
            }
            for (String tmp : lockName.split(",")) {
                String requestedLock = tmp.trim();
                if ("".equals(requestedLock) || !MapSequence.fromMap(this.locksAndUsers).containsKey((Object)requestedLock) || requestContainerHash != (long)this.hashCode() || userInstanceName.equals(requestedLock + "_" + this.hashCode())) continue;
                MapSequence.fromMap(this.locksAndUsers).put((Object)requestedLock, (Object)byUserName);
            }
        }
    }

    public void ll(String method, String msg) {
    }

    @Override
    public void close() {
        this.bus.unregister((ConsumerHandler)this, "locking");
        this.ll("close", "bus receiver unregistered.");
        this.bus = null;
        this.userServices = null;
    }
}

