/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.telemetrics;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.joda.time.DateTime;
import org.modellwerkstatt.dataux.runtime.telemetrics.ApplicationTelemetricsMBean;
import org.modellwerkstatt.objectflow.runtime.TelemetricsLongAbsoluter;
import org.modellwerkstatt.objectflow.runtime.TelemetricsLongSampler;

public class ApplicationTelemetrics
extends NotificationBroadcasterSupport
implements ApplicationTelemetricsMBean {
    private static final long hour = 3600000L;
    private static final long tenMinutes = 600000L;
    private String settings;
    private boolean preventHtmlCache;
    private long sequence = 0L;
    private AtomicLong totalRequest;
    private AtomicLong totalCommands;
    private AtomicLong totalExceptions;
    private AtomicInteger totalClients;
    private AtomicInteger openCommands;
    private TelemetricsLongSampler durationSampler;
    private TelemetricsLongAbsoluter durationAbsolut;
    private TelemetricsLongSampler exceptionSampler;
    private TelemetricsLongSampler requestSampler;
    private TelemetricsLongSampler commandSampler;
    private String appFqName;
    private String apNamepVersion;
    private String frameworkVersion;
    private String guessedServerName;
    private String servletBasePath;
    private String homeScreenPath;
    private String connectionUrl;
    private String uiFactorySettings;
    private DynamicInfo uiFactoryDynInfo;
    private DynamicInfo parDeployAutoDynInfo;
    private DynamicAction parDeployAutoSetCurrentVersion;
    private DynamicAction resetEventBusConnection;
    private boolean parDeploymentForwardImmediate = false;
    private boolean parDeploymentForwardGracefully = false;
    private DateTime appLoadedAt;

    public ApplicationTelemetrics(String aFqNam, String aNameVers, String servletPath, String homePath, String connUrl, String frameVers, String guessedServName, String uiFactSettings, String aSettings) {
        this.appFqName = aFqNam;
        this.apNamepVersion = aNameVers;
        this.connectionUrl = connUrl;
        this.frameworkVersion = frameVers;
        this.guessedServerName = guessedServName;
        this.servletBasePath = servletPath;
        this.homeScreenPath = homePath;
        this.appLoadedAt = new DateTime();
        this.uiFactorySettings = uiFactSettings;
        this.settings = aSettings;
        this.preventHtmlCache = false;
        this.totalRequest = new AtomicLong(0L);
        this.totalCommands = new AtomicLong(0L);
        this.totalExceptions = new AtomicLong(0L);
        this.openCommands = new AtomicInteger(0);
        this.totalClients = new AtomicInteger(0);
        this.durationSampler = new TelemetricsLongSampler(10000);
        this.requestSampler = new TelemetricsLongSampler(100000);
        this.commandSampler = new TelemetricsLongSampler(10000);
        this.exceptionSampler = new TelemetricsLongSampler(10000);
        this.durationAbsolut = new TelemetricsLongAbsoluter();
    }

    public void setUiFactDynInfo(DynamicInfo info) {
        this.uiFactoryDynInfo = info;
    }

    public void setAutoParDeplyDynInfo(DynamicInfo info) {
        this.parDeployAutoDynInfo = info;
    }

    public void setAutoParDeplyToCurrentVersion(DynamicAction act) {
        this.parDeployAutoSetCurrentVersion = act;
    }

    public void applicationLog(String msg1, String msg) {
        Notification n = new Notification("application log", (Object)this, this.sequence++, msg);
        n.setUserData(msg1);
        this.sendNotification(n);
    }

    @Override
    public String getapp_FramkworkVersion() {
        return this.frameworkVersion;
    }

    @Override
    public String getapp_FqName() {
        return this.appFqName;
    }

    @Override
    public String getapp_Application() {
        return this.apNamepVersion;
    }

    @Override
    public String getapp_ServerName() {
        return this.guessedServerName;
    }

    @Override
    public String getapp_ServletBasePath() {
        return this.servletBasePath;
    }

    @Override
    public String getapp_HomeScreenPath() {
        return this.homeScreenPath;
    }

    @Override
    public String getapp_ConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getapp_FactorySettings() {
        return this.uiFactorySettings;
    }

    @Override
    public String getapp_FactoryStatus() {
        return this.uiFactoryDynInfo == null ? "null" : this.uiFactoryDynInfo.getDescription();
    }

    @Override
    public String getapp_InitAndStartup() {
        return this.appLoadedAt.toString();
    }

    @Override
    public int getclients_unique() {
        return this.totalClients.get();
    }

    @Override
    public long getrequests_PerHour() {
        return this.requestSampler.getCount(System.currentTimeMillis() - 3600000L);
    }

    @Override
    public long getrequests_Per10Minutes() {
        return this.requestSampler.getCount(System.currentTimeMillis() - 600000L);
    }

    @Override
    public long getrequests_Total() {
        return this.totalRequest.get();
    }

    @Override
    public long getcommands_PerHour() {
        return this.commandSampler.getCount(System.currentTimeMillis() - 3600000L);
    }

    @Override
    public long getcommands_Per10Minutes() {
        return this.commandSampler.getCount(System.currentTimeMillis() - 600000L);
    }

    @Override
    public long getcommands_Total() {
        return this.totalCommands.get();
    }

    @Override
    public long getcommands_Open() {
        return this.openCommands.get();
    }

    @Override
    public long getexceptions_PerHour() {
        return this.exceptionSampler.getCount(System.currentTimeMillis() - 3600000L);
    }

    @Override
    public long getexceptions_Per10Minutes() {
        return this.exceptionSampler.getCount(System.currentTimeMillis() - 600000L);
    }

    @Override
    public long getexceptions_Total() {
        return this.totalExceptions.get();
    }

    @Override
    public long getduration_AVG_Last10() {
        return this.durationSampler.getAverage(10);
    }

    @Override
    public long getduration_AVG_Last100() {
        return this.durationSampler.getAverage(100);
    }

    @Override
    public long getduration_AVG_Last1000() {
        return this.durationSampler.getAverage(1000);
    }

    @Override
    public long getduration_AVG() {
        return this.durationAbsolut.getAverage();
    }

    @Override
    public long getduration_MAX_Last10() {
        return this.durationSampler.getMax(10);
    }

    @Override
    public long getduration_MAX_Last100() {
        return this.durationSampler.getMax(100);
    }

    @Override
    public long getduration_MAX_Last1000() {
        return this.durationSampler.getMax(1000);
    }

    @Override
    public long getduration_MAX() {
        return this.durationAbsolut.getMax();
    }

    public void incException() {
        this.totalExceptions.incrementAndGet();
        this.exceptionSampler.addSample(System.currentTimeMillis());
    }

    public void incCommands() {
        this.totalCommands.incrementAndGet();
        this.openCommands.incrementAndGet();
        this.commandSampler.addSample(System.currentTimeMillis());
    }

    public void decCommand() {
        this.openCommands.decrementAndGet();
    }

    public void incClient() {
        this.totalClients.incrementAndGet();
    }

    public void decClient() {
        this.totalClients.decrementAndGet();
    }

    public void servedRequest(String remoteAddr, String userName, String execCommand, long startTime) {
        if (startTime == -1L) {
            this.applicationLog(remoteAddr, userName + ": " + execCommand);
        } else {
            long now = System.currentTimeMillis();
            long diff = now - startTime;
            this.totalRequest.incrementAndGet();
            this.requestSampler.addSample(now);
            this.durationSampler.addSample(diff);
            this.durationAbsolut.addSample(diff);
            if (diff > 1000L) {
                this.applicationLog(remoteAddr + " (" + diff + "ms)", userName + ": " + execCommand);
            }
        }
    }

    @Override
    public String getapp_Settings() {
        return this.settings;
    }

    @Override
    public String preventHtmlCaching(boolean status) {
        this.preventHtmlCache = status;
        return "Prevent html cache is " + this.preventHtmlCache;
    }

    public boolean isPreventHtmlCaching() {
        return this.preventHtmlCache;
    }

    @Override
    public String getapp_parDeploymentStatus() {
        return "parDeploymentForwardGracefully is " + this.parDeploymentForwardGracefully + ", parDeplyomentForwardImmediate is " + this.parDeploymentForwardImmediate;
    }

    @Override
    public String parDeployForwardImmediate(boolean status) {
        this.parDeploymentForwardImmediate = status;
        return "parDeploymentForwardImmediate is now " + this.parDeploymentForwardImmediate;
    }

    public boolean isParDeploymentForwardImmediate() {
        return this.parDeploymentForwardImmediate;
    }

    @Override
    public String parDeployForwardGracefully(boolean status) {
        this.parDeploymentForwardGracefully = status;
        return "parDeploymentForwardGracefully is now " + this.parDeploymentForwardGracefully;
    }

    public boolean isParDeploymentForwardGracefully() {
        return this.parDeploymentForwardGracefully;
    }

    @Override
    public String getapp_PreventHtmlCaching() {
        return "" + this.preventHtmlCache;
    }

    @Override
    public String getapp_AutoDeployForward() {
        return this.parDeployAutoDynInfo == null ? "null" : this.parDeployAutoDynInfo.getDescription();
    }

    @Override
    public String setAutoDeployForwardToCurrentVersion() {
        if (this.parDeployAutoSetCurrentVersion == null) {
            return "null - frmwk error?";
        }
        this.parDeploymentForwardGracefully = false;
        this.parDeploymentForwardImmediate = false;
        return this.parDeployAutoSetCurrentVersion.execAction();
    }

    public void setResetEventBusAction(DynamicAction act) {
        this.resetEventBusConnection = act;
    }

    @Override
    public String tryResetEventBusConnection() {
        if (this.resetEventBusConnection != null) {
            return this.resetEventBusConnection.execAction();
        }
        return "no reset action set :/";
    }

    public void gcClean() {
        this.uiFactoryDynInfo = null;
        this.parDeployAutoDynInfo = null;
    }

    public static interface DynamicInfo {
        public String getDescription();
    }

    public static interface DynamicAction {
        public String execAction();
    }
}

