/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.telemetrics;

import java.util.Properties;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class MessaggingLogger {
    private static final DateTimeFormatter frmt = DateTimeFormat.forPattern((String)"EEE dd MMM kk:mm:ss");
    private String topic;
    private boolean disabled;

    public void init(String server) {
        Properties props = new Properties();
        props.put("bootstrap.servers", server);
        props.put("acks", "0");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)100);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("request.timeout.ms", (Object)1000);
        props.put("max.block.ms", (Object)1100);
        props.put("metadata.fetch.timeout.ms", (Object)1100);
        this.topic = "mylogs";
        this.disabled = false;
    }

    public void disabled() {
        this.disabled = true;
    }

    public void send(String key, long lastEventMillis, String value) {
        if (this.disabled) {
            return;
        }
        try {
            long t = System.currentTimeMillis();
            String dateAsString = frmt.print(lastEventMillis);
            if (System.currentTimeMillis() - t > 1000L) {
                this.disabled = true;
                this.close();
                System.err.println("Kafka event logging disabled since custom timeout was hit.");
            }
        }
        catch (IllegalStateException ex) {
            String st = ex.getMessage();
            if (st != null && st.contains("Cannot send after the producer is closed")) {
                this.disabled = true;
            }
            throw ex;
        }
    }

    public void close() {
    }

    public static void main(String[] args) {
        System.err.println(" DateTime now " + frmt.print(System.currentTimeMillis()));
    }
}

