/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.dataux.runtime.telemetrics;

import java.util.Properties;
import java.util.Set;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public class ParDeployAutoForwarder {
    private final String PREFIX = "modellwerkstatt.pardeploy.";
    private String propKey;
    private String ownVersion;
    private boolean iAmOldVersion;
    private boolean enabled;

    public ParDeployAutoForwarder(String appShortName, String version) {
        this.propKey = "modellwerkstatt.pardeploy." + appShortName.replace(' ', '_').toLowerCase();
        this.ownVersion = version;
        this.iAmOldVersion = false;
        this.enabled = false;
    }

    public void updateParDeployInfo() {
        this.enabled = true;
        String existing = System.getProperty(this.propKey);
        if (existing == null) {
            System.setProperty(this.propKey, this.ownVersion);
        } else if (this.ownVersion.compareTo(existing) > 0) {
            System.setProperty(this.propKey, this.ownVersion);
        } else {
            OFXLogger.log(ParDeployAutoForwarder.class, (IOFXCoreReporter.LogPriority)IOFXCoreReporter.LogPriority.ERROR, (String)("Strange, probably an error: deployed " + this.propKey + " with '" + this.ownVersion + "' but found '" + existing + "' which is the same or a lower version?"), null);
        }
    }

    public boolean checkIsOldVersion() {
        if (!this.enabled) {
            return false;
        }
        if (this.iAmOldVersion) {
            return true;
        }
        String existing = System.getProperty(this.propKey);
        if (this.ownVersion.compareTo(existing) < 0) {
            this.iAmOldVersion = true;
            return true;
        }
        return false;
    }

    public String getAutoParDeploySettings() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.propKey + " - " + this.enabled);
        Properties sysProps = System.getProperties();
        Set<String> keys = sysProps.stringPropertyNames();
        for (String key : keys) {
            if (!key.startsWith("modellwerkstatt.pardeploy.")) continue;
            sb.append(" , " + key + ": " + sysProps.getProperty(key));
        }
        return sb.toString();
    }

    public String setToCurrentVersion() {
        this.iAmOldVersion = false;
        System.setProperty(this.propKey, this.ownVersion);
        return "set " + this.propKey + " to " + this.ownVersion;
    }

    public static void main(String[] args) {
        System.err.println("> " + "6.28.2.3".compareTo("6.3.2.3"));
        System.err.println("> " + "1.0.0".compareTo("0.1.9"));
        System.err.println("> " + "02".compareTo("11"));
        System.err.println("> " + "0.9".compareTo("0.9"));
    }
}

