/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import java.util.List;
import org.modellwerkstatt.objectflow.batchjob.ConsumerReporterMBean;
import org.modellwerkstatt.objectflow.batchjob.JobProperties;
import org.modellwerkstatt.objectflow.batchjob.JobReporter;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.TelemetricsLongAbsoluter;

public class ConsumerReporter
extends JobReporter
implements ConsumerReporterMBean {
    private TelemetricsLongAbsoluter processingTimes = new TelemetricsLongAbsoluter();
    private long startMillis = 0L;
    private long faults = 0L;
    private long cancels = 0L;
    private Object currentKey;
    private String lastAction;
    private String internalState;

    public ConsumerReporter(String pcPairName, int idOrProducer, JobProperties props) {
        super(pcPairName, idOrProducer, props);
    }

    @Override
    public String getconsumer1_InternalState() {
        return this.internalState;
    }

    @Override
    public String getconsumer2_LastAction() {
        return this.lastAction;
    }

    @Override
    public String getconsumer3_LastKeyReceived() {
        return "" + this.currentKey;
    }

    @Override
    public long getconsumer4_AvgProcessingDuration() {
        return this.processingTimes.getAverage();
    }

    @Override
    public long getconsumer5_MaxProcessingDuration() {
        return this.processingTimes.getMax();
    }

    @Override
    public long getconsumer6_SuccessfullyProcessedKeys() {
        return this.processingTimes.getCount();
    }

    @Override
    public long getconsumer7_FaultedProcessings() {
        return this.faults;
    }

    @Override
    public long getconsumer8_CanceledProcessings() {
        return this.cancels;
    }

    public void setInternalStatus(String s) {
        this.internalState = s;
    }

    public void startProcessing(Object key) {
        if (this.startMillis != 0L) {
            ++this.faults;
            this.logFrmwrkError("Processing next item/key " + key + ", but last item/key " + this.currentKey + " was not concluded successfully, fault count increased to " + this.faults, null);
        }
        this.startMillis = System.currentTimeMillis();
        this.currentKey = key;
    }

    public void setLastAction(String action) {
        this.lastAction = action;
        this.logFrmwrkTrace("Last action was: " + action);
    }

    public void stopProcessing() {
        long diff = System.currentTimeMillis() - this.startMillis;
        this.processingTimes.addSample(diff);
        CoreReporterInfo info = this.createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, IOFXCoreReporter.LogPriority.DEBUG, "Consumer processed item/key " + this.currentKey);
        info.addParameter("diff", diff);
        info.addParameter("param", "" + this.currentKey);
        this.coreReporter.report(info);
        this.jmxLog(false, "" + info.getPrio(), "Processed item/key " + this.currentKey, null);
        this.startMillis = 0L;
        this.currentKey = null;
    }

    public void canceledProcessing(boolean silentLog, String cmdFqName, List<IOFXProblem> problems) {
        long diff = System.currentTimeMillis() - this.startMillis;
        for (IOFXProblem prblm : problems) {
            CoreReporterInfo info = this.createInfoObject(prblm.isWarningOnly() ? IOFXCoreReporter.Type.APP_MESSAGE : IOFXCoreReporter.Type.APP_PROBLEM, prblm.translatedLogPrio(), "Canceled processing of " + this.currentKey);
            info.setCmdFqName(cmdFqName);
            info.addParameter("diff", diff);
            info.addParameter("param", prblm.getSimpleUserText());
            if (prblm.hasForwardedEx()) {
                info.setException(prblm.getForwardedEx());
            }
            CoreReporterInfo.takeOverParamsIfNotNull(info.getParameters(), prblm.getPropMapOrNull());
            this.coreReporter.report(info);
            this.jmxLog(false, "" + info.getPrio(), "[" + this.currentKey + " canceled] " + prblm, null);
        }
        ++this.cancels;
        this.startMillis = 0L;
        this.currentKey = null;
    }
}

