/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.batchjob.OFXBatchJobHtmlDashboard;
import org.modellwerkstatt.objectflow.batchjob.OFXCronMasterController;
import org.modellwerkstatt.objectflow.runtime.DeprecatedServerDateProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public class OFXBatchJobServlet
extends HttpServlet {
    public static OFXCronMasterController masterController;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (masterController == null) {
            resp.getWriter().print("Internal Error: OFXCronMasterController is (null) - not correctly initialized");
            return;
        }
        String fqName = OFXBatchJobServlet.masterController.getJobProperties().swJobFqName;
        OFXBatchJobHtmlDashboard dashboard = new OFXBatchJobHtmlDashboard(fqName);
        masterController.buildHtmlDashboardInfo(dashboard);
        resp.getWriter().print(dashboard.getPage());
    }

    public String getXmlConfigFromContext(ServletContext context) {
        String xmlConfigFileParam = context.getInitParameter("xmlConfigFile");
        if (xmlConfigFileParam == null) {
            StringBuilder b = new StringBuilder();
            Enumeration e = context.getInitParameterNames();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                b.append(s + ":" + context.getInitParameter(s) + "  ");
            }
            throw new RuntimeException("InitParameter xmlConfigFile not found in servlet config... found merely " + b.toString());
        }
        return xmlConfigFileParam;
    }

    public void ensureLocalTimeFitsServerTime() {
        DateTime here = new DateTime();
        DateTime sqlServer = DeprecatedServerDateProvider.getSqlServerDateTime();
        long diffInMillis = here.getMillis() - sqlServer.getMillis();
        if (diffInMillis >= 600000L || diffInMillis <= -600000L) {
            OFXLogger.log(((Object)((Object)this)).getClass(), IOFXCoreReporter.LogPriority.ERROR, "SqlServer DateTime (" + sqlServer + ") and local JVM DateTime (" + here + ") are not synchronized.", null);
        }
    }

    public void cl_joinOnAllProducerThreads(List<Thread> threadsToJoin) {
        for (Thread t : threadsToJoin) {
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean cl_waitForThreads(List<Thread> threadsToWait) {
        boolean nonAlive = false;
        for (int i = 0; i < 500; ++i) {
            if (ListSequence.fromList(threadsToWait).all(it -> !it.isAlive())) {
                nonAlive = true;
                break;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return nonAlive;
    }
}

