/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

public abstract class OFXExceptionStrategy {
    public abstract Strategy strategyFor(Throwable var1);

    public static class Strategy {
        private Integer waitDelayTimeInMs;
        private StrategyProp[] properties;

        public Strategy(Integer inMillis, StrategyProp ... p) {
            this.waitDelayTimeInMs = inMillis;
            this.properties = p;
        }

        public int getDelayTimeInMsOrZero() {
            if (this.isDelayExecution()) {
                return this.waitDelayTimeInMs;
            }
            return 0;
        }

        public StrategyProp[] getPropertiesOfStrategy() {
            return this.properties;
        }

        public boolean isReaddToInbox() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.READD_TO_INBOX) continue;
                return true;
            }
            return false;
        }

        public boolean isSilentNoLog() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.SILENT_NO_LOG) continue;
                return true;
            }
            return false;
        }

        public boolean isConsumerRestart() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.CONSUMER_RESTART) continue;
                return true;
            }
            return false;
        }

        public boolean isVMShutdown() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.VM_SHUTDOWN) continue;
                return true;
            }
            return false;
        }

        public boolean isVMRestart() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.VM_RESTART) continue;
                return true;
            }
            return false;
        }

        public boolean isJobShutdown() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.JOB_SHUTDOWN) continue;
                return true;
            }
            return false;
        }

        public boolean isJobRestart() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.JOB_RESTART) continue;
                return true;
            }
            return false;
        }

        public boolean isClearInbox() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.CLEAR_INBOX) continue;
                return true;
            }
            return false;
        }

        public boolean isDelayExecution() {
            for (StrategyProp prop : this.properties) {
                if (prop != StrategyProp.DELAY_EXECUTION) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            Object s = "ExStrat: ";
            for (StrategyProp p : this.properties) {
                s = (String)s + p + " ";
            }
            s = (String)s + "wait=" + this.waitDelayTimeInMs;
            return s;
        }
    }

    public static enum StrategyProp {
        VM_SHUTDOWN,
        VM_RESTART,
        JOB_SHUTDOWN,
        JOB_RESTART,
        CONSUMER_RESTART,
        READD_TO_INBOX,
        DELAY_EXECUTION,
        SILENT_NO_LOG,
        CLEAR_INBOX;

    }
}

