/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.batchjob;

public class RollatingLogger {
    private int size;
    private boolean timestamps = true;
    private String[] logStatements;
    private int i;

    public RollatingLogger(int size) {
        this.size = size;
        this.i = 0;
        this.logStatements = new String[size];
    }

    public RollatingLogger(int size, boolean timeStamps) {
        this(size);
        this.timestamps = timeStamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String text) {
        RollatingLogger rollatingLogger = this;
        synchronized (rollatingLogger) {
            this.logStatements[this.i] = text;
            ++this.i;
            if (this.i >= this.size) {
                this.i = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        RollatingLogger rollatingLogger = this;
        synchronized (rollatingLogger) {
            int current = this.i;
            for (int line = 0; line < this.size; ++line) {
                if (current >= this.size) {
                    current = 0;
                }
                if (this.logStatements[current] == null) {
                    sb.append("");
                } else {
                    sb.append(this.logStatements[current] + "\n");
                }
                ++current;
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        RollatingLogger l = new RollatingLogger(4, false);
        l.add("Hello World");
        l.add("My Hello World");
        l.add("One Two Three");
        l.add("A B C D E");
        l.add("Hello World");
        System.out.println("" + l);
    }
}

