/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

public class JavaStringFromatHelper {
    public static final char[] FLAGS = new char[]{'-', '#', '+', ' ', '0', ',', '('};
    public static final char[] NUMS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char DOT = '.';
    public static final char PERCENT = '%';

    public static boolean in(char c, char[] chars) {
        for (char candidate : chars) {
            if (c != candidate) continue;
            return true;
        }
        return false;
    }

    public static int isFlagsAndPrecission(String candidate) {
        int curPos = 0;
        int len = candidate.length();
        if (curPos >= len) {
            return -1;
        }
        curPos = JavaStringFromatHelper.noneOrMore(curPos, candidate, FLAGS);
        if ((curPos = JavaStringFromatHelper.noneOrMore(curPos, candidate, NUMS)) == -1 || curPos >= len) {
            return -1;
        }
        if (candidate.charAt(curPos) == '.') {
            ++curPos;
            curPos = JavaStringFromatHelper.oneOrMore(curPos, candidate, NUMS);
        }
        return curPos;
    }

    public static int noneOrMore(int start, String candidate, char[] match) {
        int curPos;
        if (start == -1) {
            return -1;
        }
        int len = candidate.length();
        for (curPos = start; curPos < len && JavaStringFromatHelper.in(candidate.charAt(curPos), match); ++curPos) {
        }
        if (curPos >= len) {
            return -1;
        }
        return curPos;
    }

    public static int oneOrMore(int start, String candidate, char[] match) {
        int curPos;
        if (start == -1) {
            return -1;
        }
        int len = candidate.length();
        for (curPos = start; curPos < len && JavaStringFromatHelper.in(candidate.charAt(curPos), match); ++curPos) {
        }
        if (start >= len) {
            return -1;
        }
        if (curPos == start) {
            return -1;
        }
        return curPos;
    }

    public static String[] getPercentFormatters(String x) {
        int arraySize = 0;
        int length = x.length();
        boolean lastWasPercent = false;
        for (int i = 0; i < length; ++i) {
            if (x.charAt(i) == '%') {
                if (lastWasPercent) {
                    lastWasPercent = false;
                    continue;
                }
                ++arraySize;
                lastWasPercent = true;
                continue;
            }
            lastWasPercent = false;
        }
        String[] partsOfString = new String[++arraySize];
        int part = 0;
        lastWasPercent = false;
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (x.charAt(i) == '%') {
                if (lastWasPercent) {
                    lastWasPercent = false;
                    b.append('%');
                    continue;
                }
                partsOfString[part] = b.toString();
                b = new StringBuilder();
                ++part;
                lastWasPercent = true;
                continue;
            }
            b.append(x.charAt(i));
            lastWasPercent = false;
        }
        partsOfString[part] = b.toString();
        return partsOfString;
    }

    public static void main(String[] args) {
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission(""));
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission("-0.00"));
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission("0-00"));
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission("-##.00"));
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission(".%"));
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission(".2"));
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission("."));
        System.out.println("> " + JavaStringFromatHelper.isFlagsAndPrecission("nad"));
        System.out.println(" -- " + "Hello Dan".hashCode());
        System.out.println("\n---------------------------- ");
        for (String s : JavaStringFromatHelper.getPercentFormatters("hello world")) {
            System.out.println("  >" + s + "< ");
        }
        System.out.println("\n---------------------------- ");
        for (String s : JavaStringFromatHelper.getPercentFormatters("hello %world")) {
            System.out.println("  >" + s + "< ");
        }
        System.out.println("\n---------------------------- ");
        for (String s : JavaStringFromatHelper.getPercentFormatters("hello %world%")) {
            System.out.println("  >" + s + "< ");
        }
        System.out.println("\n---------------------------- ");
        for (String s : JavaStringFromatHelper.getPercentFormatters("%hello %world%")) {
            System.out.println("  >" + s + "< ");
        }
        System.out.println("\n---------------------------- ");
        for (String s : JavaStringFromatHelper.getPercentFormatters("%hello %%world%")) {
            System.out.println("  >" + s + "< ");
        }
    }
}

