/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import org.apache.logging.log4j.Level;
import org.modellwerkstatt.objectflow.runtime.Log4JProperties;

public class Log4JLogLevel {
    private String loggerToConfigureName;

    public Log4JLogLevel() {
    }

    public Log4JLogLevel(String loggerName) {
        this.loggerToConfigureName = loggerName;
    }

    public Log4JLogLevel(String loggerName, String level) {
        this.loggerToConfigureName = loggerName;
        Log4JLogLevel.setLevelOnLogger(this.loggerToConfigureName, level);
    }

    public void setLevel(String level) {
        Log4JLogLevel.setLevelOnLogger(this.loggerToConfigureName, level);
    }

    public static Level getLevelFromString(String level) {
        String compareToLevel = level.trim();
        if ("OFF".equals(compareToLevel) || "FATAL".equals(compareToLevel)) {
            return Level.OFF;
        }
        if ("ERROR".equals(compareToLevel)) {
            return Level.ERROR;
        }
        if ("WARN".equals(compareToLevel)) {
            return Level.WARN;
        }
        if ("INFO".equals(compareToLevel)) {
            return Level.INFO;
        }
        if ("DEBUG".equals(compareToLevel)) {
            return Level.DEBUG;
        }
        if ("TRACE".equals(compareToLevel)) {
            return Level.TRACE;
        }
        if ("ALL".equals(compareToLevel)) {
            return Level.ALL;
        }
        throw new IllegalStateException("Can not set level >>" + compareToLevel + "<< - level not known!");
    }

    public static void setLevelOnLogger(String loggerName, String levelName) {
        Level level = Log4JLogLevel.getLevelFromString(levelName);
        Log4JProperties.setLogLevel(loggerName, level);
    }
}

