/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

public class MoVersion {
    public static final String MOWARE_PLUGIN_VERSION = "moware11 2025.24 (dck)";

    public static String getShortNameFromFQ(String fq) {
        return fq.substring(fq.lastIndexOf(".") + 1);
    }

    public static String getCapitalizedShortNameFromFQ(String fq) {
        String name = MoVersion.getShortNameFromFQ(fq);
        if (name.length() > 0) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }

    public static String getLowerShortNameFromFQ(String fq) {
        String name = MoVersion.getShortNameFromFQ(fq);
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static String getPackageName(String fq) {
        if (fq.contains(".")) {
            return fq.substring(0, fq.lastIndexOf("."));
        }
        return fq;
    }

    public static String getCmdModuleInstanceName(String commandFqName) {
        String packageName = MoVersion.getPackageName(commandFqName);
        String moduleFqName = packageName + "." + MoVersion.getCmdModuleClassName(packageName);
        return moduleFqName.replace(".", "_");
    }

    public static String getCmdModuleClassName(String packageName) {
        String lastNameSpace = MoVersion.getLowerShortNameFromFQ(packageName);
        return "CmdModule" + lastNameSpace;
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    public static String getUpperName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String removeNL(String withNL) {
        return withNL.replace("\n", " ").replace("\r", " ");
    }

    public static void main(String[] args) {
        System.out.println(MOWARE_PLUGIN_VERSION);
    }
}

