/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class MoWareFormattersFactory {
    public static final int PIVOT_YEAR = 2000;
    public static final String NO0_FORMAT_OPTION = "no0";
    private static Map<String, DateTimeFormatter> dateTimeFormatterCache = MapSequence.fromMap(new HashMap());

    public static DateTimeFormatter forDateTimePattern(String pattern, String locale) {
        String key = pattern + "_" + locale;
        if (MapSequence.fromMap(dateTimeFormatterCache).containsKey((Object)key)) {
            return (DateTimeFormatter)MapSequence.fromMap(dateTimeFormatterCache).get((Object)key);
        }
        DateTimeFormatter newFrmter = DateTimeFormat.forPattern((String)pattern).withPivotYear(2000).withLocale(new Locale(locale));
        MapSequence.fromMap(dateTimeFormatterCache).put((Object)key, (Object)newFrmter);
        return newFrmter;
    }

    public static DecimalFormat forDecimalFormatPattern(String pattern, String locale) {
        if (pattern.toLowerCase().contains(NO0_FORMAT_OPTION)) {
            pattern = pattern.toLowerCase().replace(NO0_FORMAT_OPTION, "").trim();
        }
        DecimalFormat formatter = new DecimalFormat(pattern, new DecimalFormatSymbols(new Locale(locale)));
        formatter.setParseBigDecimal(true);
        return formatter;
    }

    public static DecimalFormat forIntegerFormatPattern(String pattern, String locale) {
        if (pattern.toLowerCase().contains(NO0_FORMAT_OPTION)) {
            pattern = pattern.toLowerCase().replace(NO0_FORMAT_OPTION, "").trim();
        }
        if ("".equals(pattern.trim())) {
            pattern = "0";
        }
        DecimalFormat formatter = new DecimalFormat(pattern, new DecimalFormatSymbols(new Locale(locale)));
        return formatter;
    }

    public static boolean containsNo0FormatStatment(String pattern) {
        if (pattern == null) {
            return false;
        }
        return pattern.toLowerCase().contains(NO0_FORMAT_OPTION);
    }

    public static int twoToFourDigitYear(int twoDigitYear) {
        int SPAN = 100;
        int _1900 = 2000 - SPAN;
        if (twoDigitYear > 100) {
            twoDigitYear %= 100;
        }
        if (twoDigitYear < 50) {
            twoDigitYear += SPAN;
        }
        return twoDigitYear + _1900;
    }

    public static void main(String[] args) {
        System.err.println("? " + new DecimalFormat("", new DecimalFormatSymbols(new Locale("de"))).format(0.1234f));
        System.err.println(MoWareFormattersFactory.twoToFourDigitYear(2049));
        System.err.println(MoWareFormattersFactory.twoToFourDigitYear(2051));
        System.err.println(MoWareFormattersFactory.twoToFourDigitYear(1980));
        System.err.println(MoWareFormattersFactory.twoToFourDigitYear(2000));
    }
}

