/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaRangeScale;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableAttribute;

public class OFXBigDecimal
implements IOFXMetaRangeScale<BigDecimal>,
IOFXRevertableAttribute<OFXBigDecimal> {
    private boolean enabled = true;
    private boolean optional = false;
    private String label;
    private BigDecimal value = new BigDecimal("0.0");
    private BigDecimal min;
    private BigDecimal max;
    private Integer scale;
    private String format;
    private Boolean requestFocus;
    private String validationErrorText;

    public OFXBigDecimal() {
    }

    public OFXBigDecimal(BigDecimal start, BigDecimal stop, int scale) {
        this.min = start;
        this.max = stop;
        this.scale = scale;
    }

    @Override
    public void setEnabled(boolean enbl) {
        this.enabled = enbl;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setOptional(boolean opt) {
        this.optional = opt;
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setLabel(String lbl) {
        this.label = lbl;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean setValue(BigDecimal val) {
        if (val != null && this.scale != null) {
            val = val.setScale((int)this.scale, RoundingMode.HALF_UP);
        }
        if (this.value == null) {
            if (val != null) {
                this.value = val;
                return true;
            }
        } else if (val == null || this.value.compareTo(val) != 0) {
            this.value = val;
            return true;
        }
        return false;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setMin(BigDecimal m) {
        this.min = m;
    }

    @Override
    public BigDecimal getMin() {
        return this.min;
    }

    public void setMax(BigDecimal m) {
        this.max = m;
    }

    @Override
    public BigDecimal getMax() {
        return this.max;
    }

    @Override
    public void setMinMax(BigDecimal min, BigDecimal max, int scale) {
        this.min = min;
        this.max = max;
        this.scale = scale;
    }

    @Override
    public void setMinMax(BigDecimal min, BigDecimal max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void setScale(Integer val) {
        this.scale = val;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public OFXBigDecimal copy() {
        OFXBigDecimal i = new OFXBigDecimal();
        i.enabled = this.enabled;
        i.optional = this.optional;
        i.label = this.label;
        i.value = this.value;
        i.min = this.min;
        i.max = this.max;
        i.scale = this.scale;
        i.format = this.format;
        return i;
    }

    @Override
    public void load(OFXBigDecimal cp, boolean fullRevertNotMerge) {
        if (fullRevertNotMerge) {
            this.enabled = cp.enabled;
            this.optional = cp.optional;
            this.label = cp.label;
            this.min = cp.min;
            this.max = cp.max;
            this.scale = cp.scale;
            this.format = cp.format;
        }
        this.value = cp.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public void requestFocus() {
        this.requestFocus = new Boolean(true);
    }

    @Override
    public boolean getFocusAndClearIt() {
        if (this.requestFocus != null && this.requestFocus.equals(true)) {
            this.requestFocus = null;
            return true;
        }
        this.requestFocus = null;
        return false;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public void setValidationError(String val) {
        this.validationErrorText = val;
    }

    @Override
    public String getValidationError() {
        return this.validationErrorText;
    }
}

