/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.manmap.runtime.MMAdditionalInfoException;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXPage;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSelProvider;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXChangePageException;
import org.modellwerkstatt.objectflow.runtime.OFXCommandDoneException;
import org.modellwerkstatt.objectflow.runtime.OFXCommandPage;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.OFXProblem;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;

public abstract class OFXCommand
implements IOFXCommand {
    protected boolean finalCancelStarted = false;
    protected boolean finalOKStarted = false;
    protected boolean userCancelStarted = false;
    protected boolean lockFinalOkDueSuccessor = false;
    protected boolean readyForFinalOkConclusion = true;
    protected IOFXSession __manMapSession;
    protected IOFXPage<?> currentPage;
    protected int currentPageIndex;
    protected OFXCommandPage<?>[] allPages;
    protected int pagesAdded = 0;
    protected boolean wizzarddWithFullSizeUis = false;
    protected StringBuilder lockHolders = new StringBuilder();
    protected IOFXCommand predecessorCommand = null;
    protected boolean hasSuccessorCommand = false;
    protected String cmdDefaultTitle;
    protected String cmdDefaultIcon;
    protected String cmdFqName;
    protected String cmdTitleAddOn = "";
    protected IOFXCommand.OFXWindowTitleType cmdTitleOverwrite;
    protected IOFXCommand.OFXCmdTyp cmdType = IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD;
    protected IOFXCommand.OFXTermHandlerType cmdTermHandlerType = IOFXCommand.OFXTermHandlerType.NO_HANDLER_PRESENT;
    protected IOFXCommand.OFXCmdOptions[] cmdOptions;
    protected String cmdHelpMessage = "";
    protected String cmdTerminateOkInfo = "";

    public OFXCommand(String fqName, String defaultCmdTitle, String defaultIcon, IOFXCommand.OFXWindowTitleType titleOverwrite, boolean hasSucc, boolean fullSizeUi, int pageSize) {
        this.cmdFqName = fqName;
        this.cmdDefaultTitle = defaultCmdTitle;
        this.cmdDefaultIcon = defaultIcon;
        this.cmdTitleOverwrite = titleOverwrite;
        this.hasSuccessorCommand = hasSucc;
        this.wizzarddWithFullSizeUis = fullSizeUi;
        this.allPages = new OFXCommandPage[pageSize];
    }

    public void page(OFXCommandPage page) {
        this.allPages[this.pagesAdded] = page;
        ++this.pagesAdded;
    }

    @Override
    public String getCommandFqName() {
        return this.cmdFqName;
    }

    @Override
    public String getCommandName() {
        return this.cmdDefaultTitle;
    }

    @Override
    public String getCommandTitleShort() {
        return this.cmdDefaultTitle + " ";
    }

    @Override
    public IOFXCommand.OFXWindowTitleType getWindowTitleType() {
        return this.cmdTitleOverwrite;
    }

    @Override
    public String getWindowTitle() {
        return this.cmdTitleAddOn;
    }

    public String toString() {
        return this.cmdFqName;
    }

    @Override
    public String getCommandIcon() {
        return this.cmdDefaultIcon;
    }

    @Override
    public String getAdjustedCmdUrl() {
        return null;
    }

    @Override
    public String getCommandHelp() {
        return this.cmdHelpMessage;
    }

    @Override
    public IOFXSession getCommandSession() {
        return this.__manMapSession;
    }

    public void setCommandParams(IOFXSession session, boolean hasCmdSucessor) {
        this.__manMapSession = session;
        if (hasCmdSucessor) {
            this.lockFinalOkDueSuccessor = true;
            this.readyForFinalOkConclusion = false;
        }
        for (OFXCommandPage<?> page : this.allPages) {
            page.initGenPageConclusion();
        }
        if (this.allPages.length > 0) {
            this.currentPage = this.allPages[0];
        }
        this.currentPageIndex = -1;
    }

    @Override
    public void manageAlsoPredecessor(IOFXCommand pre) {
        this.predecessorCommand = pre;
        if (!this.predecessorCommand.hasSuccessorCommand()) {
            throw new RuntimeException("This can not be true. Framework error.");
        }
    }

    @Override
    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public void setCurrentPage(OFXChangePageException cpe) {
        String lookingForPage = cpe.getMessage();
        int i = 0;
        boolean found = false;
        for (OFXCommandPage<?> page : this.allPages) {
            if (page.getPageName().equals(lookingForPage)) {
                this.currentPage = page;
                this.currentPageIndex = i;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            throw new IllegalStateException("setCurrentPage() did not found page '" + lookingForPage + "'.");
        }
    }

    public abstract void initCommandStatements() throws Exception;

    @Override
    public void initCommand() throws Exception {
        if (this.finalCancelStarted || this.finalOKStarted || this.userCancelStarted) {
            throw new IllegalStateException(this.dumpCommandState("initCommand() no longer available."));
        }
        this.startShadowing();
        boolean controllingExReceived = false;
        try {
            this.initCommandStatements();
        }
        catch (OFXChangePageException changePage) {
            controllingExReceived = true;
            this.setCurrentPage(changePage);
        }
        catch (OFXCommandDoneException done) {
            controllingExReceived = true;
            this.doFinalOkConclusion();
        }
        catch (OFXAbortedException aborted) {
            throw aborted;
        }
        catch (Exception ex) {
            controllingExReceived = true;
            this.doFinalCancelConclusion(null, ex);
            throw ex;
        }
        if (this.allPages.length == 0 && !controllingExReceived) {
            if (this.__manMapSession.isReadOnly() && !this.hasSuccessorCommand()) {
                this.doFinalUserCancelConclusion();
            } else {
                this.doFinalOkConclusion();
            }
        }
        if (!(this.currentPageIndex >= 0 || this.finalCancelStarted || this.finalOKStarted || this.userCancelStarted)) {
            this.currentPageIndex = 0;
        }
    }

    @Override
    public List<?> initCurrentPage(IOFXSelProvider selRecorder) throws Exception {
        List<?> returnValue = null;
        if (this.finalCancelStarted || this.finalOKStarted || this.userCancelStarted) {
            throw new IllegalStateException(this.dumpCommandState("initCurrentPage no longer available."));
        }
        try {
            returnValue = this.currentPage.initPage(selRecorder);
        }
        catch (OFXAbortedException aborted) {
            throw aborted;
        }
        catch (Exception ex) {
            this.doFinalCancelConclusion(null, ex);
            throw ex;
        }
        return returnValue;
    }

    @Override
    public void execConclusion(IOFXPage.IOFXPageConclusion conclusion) throws Exception {
        if (this.finalCancelStarted || this.finalOKStarted || this.userCancelStarted) {
            throw new IllegalStateException(this.dumpCommandState("doConclusion() no longer available."));
        }
        try {
            this.currentPage.execPageConclusion(conclusion);
        }
        catch (OFXCommandDoneException doneEx) {
            this.doFinalOkConclusion();
        }
        catch (OFXChangePageException pageEx) {
            this.setCurrentPage(pageEx);
            throw pageEx;
        }
        catch (OFXAbortedException aborted) {
            throw aborted;
        }
        catch (Exception ex) {
            this.doFinalCancelConclusion(null, ex);
            throw ex;
        }
    }

    @Override
    public void doPredecessorFinalOk() throws Exception {
        if (!this.isReadyForSuccessor()) {
            throw new IllegalStateException(this.dumpCommandState("extForceOKConclusion() can only be applied on commands which are waiting for the final ok conclusion."));
        }
        this.lockFinalOkDueSuccessor = false;
        this.doFinalOkConclusion();
    }

    public abstract void finalOkStatements();

    public void doFinalOkConclusion() throws Exception {
        this.readyForFinalOkConclusion = true;
        if (this.lockFinalOkDueSuccessor) {
            return;
        }
        try {
            if (this.finalOKStarted || this.userCancelStarted || this.finalCancelStarted) {
                throw new IllegalStateException(this.dumpCommandState("FINAL_OK no longer available. Already executed (maybe precond in final_ok?)"));
            }
            this.finalOKStarted = true;
            this.finalOkStatements();
            if (this.predecessorCommand != null) {
                this.predecessorCommand.doPredecessorFinalOk();
            }
            if (this.isCommitSession() && this.predecessorCommand == null) {
                this.__manMapSession.startTransactionAndFlush();
            }
        }
        catch (OFXAbortedException ex) {
            List<IOFXProblem> prblms = this.__manMapSession.getCopyOfProblemState();
            this.doFinalCancelConclusion(null, ex);
            throw new IllegalStateException("Preconditions in FINAL_OK of commands are not supported yet!\n\n" + OFXConsoleHelper.asSimpleString(prblms) + "\n\n");
        }
        catch (Exception ex) {
            this.doFinalCancelConclusion(null, ex);
            throw ex;
        }
        this.clearShadowing();
        if (this.isSessionOwner() && this.predecessorCommand == null) {
            this.__manMapSession.closeSessionAndfreeGC();
        }
    }

    @Override
    public void doFinalUserCancelConclusion() {
        if (this.userCancelStarted || this.finalCancelStarted || this.finalOKStarted) {
            throw new IllegalStateException(this.dumpCommandState("USER_CANCELED no longer available."));
        }
        this.userCancelStarted = true;
        this.revertToShadow();
        try {
            if (this.predecessorCommand != null) {
                this.predecessorCommand.doFinalUserCancelConclusion();
            }
        }
        finally {
            this.clearShadowing();
            if (this.isSessionOwner() && this.predecessorCommand == null) {
                this.__manMapSession.closeSessionAndfreeGC();
            }
        }
    }

    public abstract void finalCancelStatementsAndMarker(List<IOFXProblem> var1) throws Exception;

    @Override
    public void doFinalCancelConclusion(List<IOFXProblem> listOfProblems, Exception unexpecteEX) throws Exception {
        if (listOfProblems == null) {
            listOfProblems = this.__manMapSession.getAndclearProblemState();
        }
        if (unexpecteEX != null) {
            if (unexpecteEX instanceof OFXShutDownSessionException) {
                ListSequence.fromList(listOfProblems).addElement((Object)((OFXShutDownSessionException)unexpecteEX).getProblem());
            } else {
                ListSequence.fromList(listOfProblems).addElement((Object)new OFXProblem(false, "FINAL_CANCEL forwarded " + unexpecteEX.getClass().getName(), null, unexpecteEX));
            }
        }
        if (this.userCancelStarted || this.finalCancelStarted) {
            String state = this.dumpCommandState("FINAL_CANCEL or USER_CANCEL already processed.") + "\n\n";
            state = state + OFXConsoleHelper._____organizeCurrentStacktrace_____();
            OFXLogger.log(this.getClass(), IOFXCoreReporter.LogPriority.ERROR, state, null);
            return;
        }
        try {
            this.finalCancelStarted = true;
            this.revertToShadow();
            this.finalCancelStatementsAndMarker(listOfProblems);
            if (this.predecessorCommand != null && !this.predecessorCommand.isTerminatedCancel()) {
                this.predecessorCommand.doFinalCancelConclusion(listOfProblems, null);
            }
        }
        catch (OFXAbortedException ex) {
            String stateToReport = "OFXAbortedException while processing FINAL_CANCEL for '" + listOfProblems + "'";
            this.doFinalCancelConclusion(null, ex);
            IllegalStateException toThrow = new IllegalStateException("Preconditions in FINAL_CANCEL of commands are not supported yet!");
            toThrow.addSuppressed((Throwable)new MMAdditionalInfoException(stateToReport));
            throw toThrow;
        }
        catch (Exception exWhileCancel) {
            String stateToReport = "Exception while processing FINAL_CANCEL for '" + listOfProblems + "'";
            if (unexpecteEX != null) {
                stateToReport = "Exception while processing Exception '" + unexpecteEX.getClass().getName() + "', unexpected ex trace \n" + OFXConsoleHelper.stackTrace2String(unexpecteEX) + "\n\n";
            }
            exWhileCancel.addSuppressed((Throwable)new MMAdditionalInfoException(stateToReport));
            throw exWhileCancel;
        }
        finally {
            this.clearShadowing();
            if (this.isSessionOwner() && this.predecessorCommand == null) {
                this.__manMapSession.closeSessionAndfreeGC();
            }
        }
    }

    public abstract void startShadowing();

    public abstract void clearShadowing();

    public abstract void revertToShadow();

    @Override
    public IOFXCommand.OFXTermHandlerType getCmdTermHandlerType() {
        return this.cmdTermHandlerType;
    }

    @Override
    public void handleCmdTermAndClearGeFqName(boolean wasChild, boolean terminatedInFinalOk, List<Object> cmdSelections, IOFXSelProvider selectionRecorder) throws Exception {
        try {
            if (wasChild) {
                this.__manMapSession.clearGraphEditFqName();
            }
            this.currentPage.cmdTerminated(wasChild, terminatedInFinalOk, selectionRecorder);
            for (Object selection : cmdSelections) {
                if (selection instanceof List) {
                    List selectionList = (List)selection;
                    for (Object obj : selectionList) {
                        this.currentPage.cmdTerminatedWithPushed(wasChild, terminatedInFinalOk, obj, selectionRecorder);
                    }
                    continue;
                }
                this.currentPage.cmdTerminatedWithPushed(wasChild, terminatedInFinalOk, selection, selectionRecorder);
            }
        }
        catch (OFXAbortedException aborted) {
            throw aborted;
        }
        catch (Exception ex) {
            this.doFinalCancelConclusion(null, ex);
            throw ex;
        }
    }

    @Override
    public boolean isCurrentlyReadOnlySession() {
        return this.__manMapSession.isReadOnly();
    }

    @Override
    public boolean isTerminatedOk() {
        return this.finalOKStarted && !this.finalCancelStarted && !this.userCancelStarted;
    }

    @Override
    public boolean isReadyForSuccessor() {
        return this.readyForFinalOkConclusion && this.lockFinalOkDueSuccessor && !this.finalOKStarted && !this.finalCancelStarted && !this.userCancelStarted;
    }

    @Override
    public boolean isTerminatedCancel() {
        return this.finalCancelStarted && !this.userCancelStarted;
    }

    @Override
    public boolean isUserCancelTerminated() {
        return this.userCancelStarted && !this.finalCancelStarted && !this.finalOKStarted;
    }

    public void setProcess(IOFXCmdModule process) {
    }

    @Override
    public IOFXPage.IOFXPageConclusion[] getCurrentPageConclusions(IOFXSelProvider finalView) {
        return this.currentPage.getPageConclusions(finalView);
    }

    @Override
    public String calcCurrentPageDynamicTitleAndScopes() {
        return this.currentPage.calcDynamicPageTitleAndScopes();
    }

    @Override
    public String getTerminateOkInformation() {
        String trimmed = this.cmdTerminateOkInfo.trim();
        if (trimmed.equals("")) {
            return null;
        }
        return trimmed;
    }

    @Override
    public boolean hasOption(IOFXCommand.OFXCmdOptions lookingFor) {
        for (IOFXCommand.OFXCmdOptions opt : this.cmdOptions) {
            if (!opt.equals((Object)lookingFor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCommandType(IOFXCommand.OFXCmdTyp ... commandTypsOred) {
        for (IOFXCommand.OFXCmdTyp t : commandTypsOred) {
            if (!t.equals((Object)this.cmdType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSuccessorCommand() {
        return this.hasSuccessorCommand;
    }

    @Override
    public boolean wizzardWithFullSizeUis() {
        return this.wizzarddWithFullSizeUis;
    }

    @Override
    public String calcCurrentPagePaneFqName(int pageNum) {
        return this.allPages[pageNum].calcPagePaneFqName();
    }

    public boolean isSessionOwner() {
        return OFXCommand.isSessionOwner(this.cmdType);
    }

    public static boolean isSessionOwner(IOFXCommand.OFXCmdTyp cmdType) {
        return cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD || cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL || cmdType == IOFXCommand.OFXCmdTyp.SEARCH_CMD;
    }

    public boolean isCommitSession() {
        return this.cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD || this.cmdType == IOFXCommand.OFXCmdTyp.GRAPH_OWNER_CMD_MODAL;
    }

    public String dumpCommandState(String helpMsg) {
        Object userInfo = "(no user info)";
        if (this.__manMapSession.getUserEnvironment() != null) {
            userInfo = this.__manMapSession.getUserEnvironment().getUserId() + "/" + this.__manMapSession.getUserEnvironment().getUserName();
        }
        return helpMsg + "[" + this.cmdDefaultTitle + (String)userInfo + " , finalOKStarted=" + this.finalOKStarted + ", finalCancelStarted=" + this.finalCancelStarted + ", userCancelStarted=" + this.userCancelStarted + ", readyForFinalOk=" + this.readyForFinalOkConclusion + ", predecessor=" + this.predecessorCommand + "]";
    }
}

