/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.Naming;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.sql.DataSource;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.Log4JProperties;
import org.modellwerkstatt.objectflow.runtime.OFXSimpleManMapSession;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class OFXConsoleHelper {
    private static ApplicationContext applicationContext;
    private static Properties properties;
    private static final String propertyFile = "objectflow.properties";

    public static String stackTrace2String(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String _____organizeCurrentStacktrace_____() {
        Object state = "";
        for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
            state = (String)state + elem.toString() + "\n";
        }
        return state;
    }

    public static Object initializeForTestSuit(String xmlConfiguration, Class classWeNeed) {
        properties = new Properties();
        try {
            Log4JProperties.initRichClientSetup();
            applicationContext = new ClassPathXmlApplicationContext(xmlConfiguration);
            Log4JProperties.endRichClientSetup(true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not initialize spring ioc: " + xmlConfiguration + " - " + ex.getClass().getName() + ":\n" + ex.getMessage().replace("nested exception is", "nested exception is\n"));
        }
        Object userDir = "?";
        try {
            userDir = System.getProperty("user.dir") + "/";
            FileInputStream stream = new FileInputStream((String)userDir + propertyFile);
            properties.load(stream);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return applicationContext.getAutowireCapableBeanFactory().createBean(classWeNeed);
    }

    public static Object createBean(Class classWeNeed) {
        return applicationContext.getAutowireCapableBeanFactory().createBean(classWeNeed);
    }

    public static void unbindJmxRmiNaming(boolean success) {
        try {
            RMIConnectorServer server;
            if (applicationContext != null && applicationContext.containsBean("mConnectorService") && (server = (RMIConnectorServer)applicationContext.getBean("mConnectorService")) != null) {
                String path = server.getAddress().getURLPath();
                Naming.unbind(path.substring(path.lastIndexOf("/") + 1));
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getClass().getName() + " - " + ex.getMessage());
        }
        if (success) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public static String closeConnectionPoolExplicitly(AbstractApplicationContext ctx) {
        try {
            Object dataSource = ctx.getBean(DataSource.class);
            Method m = dataSource.getClass().getMethod("close", Boolean.TYPE);
            m.invoke(dataSource, true);
        }
        catch (Exception ex) {
            return "While trying to dataSource.close(true) we got a " + ex.getClass().getSimpleName() + " " + ex.getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXmlConfigFromManifest(Class mainClass) {
        InputStream stream = null;
        String fullClassPath = mainClass.getResource(mainClass.getSimpleName() + ".class").toString();
        if (!fullClassPath.startsWith("jar")) {
            return null;
        }
        String manifestPath = fullClassPath.substring(0, fullClassPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            String pathToConfig;
            stream = new URL(manifestPath).openStream();
            Manifest mf = new Manifest(stream);
            Attributes attr = mf.getMainAttributes();
            String string = pathToConfig = attr.getValue("AppXmlConfig");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static OFXSimpleManMapSession getNewManMapSession() {
        throw new RuntimeException("getNewManMapSession() is no longer implemented @ OFXConsoleHelper. If absolutley necessary, inject appFactory in order to call getNewSession().");
    }

    public static String asSimpleString(List<IOFXProblem> problems) {
        Object sb = "";
        if (ListSequence.fromList(problems).count() == 1) {
            return ((IOFXProblem)ListSequence.fromList(problems).getElement(0)).getSimpleUserText();
        }
        for (int i = 0; i < ListSequence.fromList(problems).count(); ++i) {
            sb = (String)sb + "(" + (i + 1) + ") " + ((IOFXProblem)ListSequence.fromList(problems).getElement(i)).getSimpleUserText();
            if (i >= ListSequence.fromList(problems).count() - 1) continue;
            sb = (String)sb + "\n";
        }
        return sb;
    }

    public static IOFXProblem containsGuard(List<IOFXProblem> problems) {
        for (int i = 0; i < ListSequence.fromList(problems).count(); ++i) {
            IOFXProblem cur = (IOFXProblem)ListSequence.fromList(problems).getElement(i);
            if (!cur.isFromGuard()) continue;
            return cur;
        }
        return null;
    }

    public static String getProperty(String prop) {
        if (!properties.containsKey(prop)) {
            throw new IllegalStateException("The property " + prop + " was not found in property file 'objectflow.properties'.");
        }
        return properties.getProperty(prop);
    }
}

