/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.ArrayList;
import java.util.List;
import org.modellwerkstatt.manmap.runtime.MMStaticAccessHelper;
import org.modellwerkstatt.objectflow.runtime.IOFXEntity;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaDTO;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaReferences;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableAttribute;
import org.modellwerkstatt.objectflow.runtime.IOFXRevertableObject;
import org.modellwerkstatt.objectflow.runtime.IOFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXIllegalAccessException;
import org.modellwerkstatt.objectflow.runtime.OFXNotInitializedException;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;

public class OFXKeyReference<KEY, ENTITY extends IOFXEntity<KEY>>
implements IOFXMetaDTO<ENTITY>,
IOFXMetaReferences<ENTITY>,
IOFXRevertableAttribute<OFXKeyReference<KEY, ENTITY>> {
    private boolean enabled = true;
    private boolean optional = false;
    private String label = null;
    private boolean opposite = false;
    private Class keyClass;
    private ENTITY value;
    private ENTITY origRef2Value;
    private KEY key;
    private List<ENTITY> scope;
    private String scopeHint = "";
    private Boolean requestFocus;
    private String validationErrorText;

    public OFXKeyReference(boolean op, Class keyClass) {
        this.opposite = op;
        this.keyClass = keyClass;
        this.key = this.getNullKeyInstance();
    }

    @Override
    public void setEnabled(boolean enbl) {
        this.enabled = enbl;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setOptional(boolean opt) {
        this.optional = opt;
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setLabel(String lbl) {
        this.label = lbl;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setOpposite(boolean opt) {
        this.opposite = opt;
    }

    public boolean getOpposite() {
        return this.opposite;
    }

    @Override
    public String getHintForScope() {
        return this.scopeHint;
    }

    public void setHintForScope(String val) {
        this.scopeHint = val;
    }

    public boolean setValue(ENTITY val) {
        if (val == null) {
            this.value = null;
            if (!OFXKeyReference.isNullKey(this.key)) {
                this.key = this.getNullKeyInstance();
                return true;
            }
            this.key = this.getNullKeyInstance();
        } else {
            this.value = val;
            if (!SaveObjectComperator.equals(val.getIM3Key(), this.key)) {
                this.key = val.getIM3Key();
                return true;
            }
            if (OFXKeyReference.isNullKey(val.getIM3Key())) {
                this.key = val.getIM3Key();
                return true;
            }
        }
        return false;
    }

    public ENTITY getValue() {
        if (this.value == null && !OFXKeyReference.isNullKey(this.key)) {
            throw new OFXNotInitializedException("OFXIntKeyReference: key " + this.key + " present, but reference not initialized.");
        }
        return this.value;
    }

    public void checkReferenceBeforeSave() {
        if (this.value != null && (this.value.getIM3Key() == null || OFXKeyReference.isNullKey(this.value.getIM3Key()))) {
            throw new IllegalStateException("Saving a reference without saving the referred entity first. (value = " + this.value + " / key = " + this.value.getIM3Key() + ")");
        }
    }

    public KEY getKey() {
        if (this.value != null) {
            this.key = this.value.getIM3Key();
        }
        return this.key;
    }

    public void setKey(KEY key) {
        this.key = key;
    }

    @Override
    public void setScope(List<ENTITY> scope) {
        this.scope = scope;
    }

    @Override
    public List<ENTITY> getScope() {
        return this.scope;
    }

    @Override
    public boolean isInitialized() {
        if (this.value == null) {
            if (OFXKeyReference.isNullKey(this.key)) {
                return false;
            }
            return false;
        }
        if (!this.value.getIM3Key().equals(this.key)) {
            throw new OFXIllegalAccessException("Key " + this.key + " not in sync with ref.getIM3Key() " + this.value.getIM3Key() + ".");
        }
        return true;
    }

    @Override
    public OFXKeyReference<KEY, ENTITY> copy() {
        OFXKeyReference<KEY, ENTITY> i = new OFXKeyReference<KEY, ENTITY>(this.opposite, this.keyClass);
        i.enabled = this.enabled;
        i.optional = this.optional;
        i.label = this.label;
        i.origRef2Value = this.value;
        i.value = !i.opposite && this.value != null && !this.value.getReadOnly() ? (IOFXEntity)this.value.copy() : this.value;
        if (this.key instanceof IOFXRevertableObject) {
            IOFXRevertableObject keyCopy = ((IOFXRevertableObject)this.key).copy();
            i.key = keyCopy;
        } else {
            i.key = this.key;
        }
        if (this.scope != null) {
            i.scope = new ArrayList<ENTITY>();
            i.scope.addAll(this.scope);
        } else {
            i.scope = this.scope;
        }
        return i;
    }

    @Override
    public void load(OFXKeyReference<KEY, ENTITY> cp, boolean fullRevertNotMerge) {
        if (fullRevertNotMerge) {
            this.enabled = cp.enabled;
            this.optional = cp.optional;
            this.label = cp.label;
            this.opposite = cp.opposite;
            if (cp.scope != null) {
                this.scope.clear();
                this.scope.addAll(cp.scope);
            } else {
                this.scope = cp.scope;
            }
            this.keyClass = cp.keyClass;
            this.value = cp.origRef2Value;
            if (this.value != null && !this.opposite && !this.value.getReadOnly()) {
                this.value.load(cp.value, fullRevertNotMerge);
            }
            this.key = cp.key;
        } else {
            this.key = this.getNullKeyInstance();
            this.value = null;
        }
    }

    public KEY getNullKeyInstance() {
        if (this.keyClass == null) {
            return null;
        }
        if (this.keyClass.equals(Integer.class)) {
            return (KEY)new Integer(0);
        }
        if (this.keyClass.equals(String.class)) {
            return (KEY)"";
        }
        try {
            if (IOFXValueObject.class.isAssignableFrom(this.keyClass)) {
                return (KEY)((IOFXValueObject)this.keyClass.newInstance()).createNullKey();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Unknown KEY class in OFXKeyRefence: " + this.keyClass);
    }

    public static boolean isNullKey(Object key) {
        return MMStaticAccessHelper.isNullKeyStaticHelper((Object)key);
    }

    public String toString() {
        return "OFXKeyRef " + this.key;
    }

    @Override
    public void requestFocus() {
        this.requestFocus = new Boolean(true);
    }

    @Override
    public boolean getFocusAndClearIt() {
        if (this.requestFocus != null && this.requestFocus.equals(true)) {
            this.requestFocus = null;
            return true;
        }
        this.requestFocus = null;
        return false;
    }

    @Override
    public void setValidationError(String val) {
        this.validationErrorText = val;
    }

    @Override
    public String getValidationError() {
        return this.validationErrorText;
    }
}

