/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import mjson.Json;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;

public class OFXLogger {
    private static boolean portJLoggingEnabled = false;
    private static boolean batchJoblogOnConsole = false;
    private static Log portJLog;

    public static OFXLogger enablePortJ() {
        portJLoggingEnabled = true;
        portJLog = LogFactory.getLog((String)"org.modellwerkstatt.portj");
        return null;
    }

    public static boolean isEnabledPortJ() {
        return portJLoggingEnabled;
    }

    public static void enableBatchJobLogOnConsole() {
        batchJoblogOnConsole = true;
    }

    public static void log(String packageName, IOFXCoreReporter.LogPriority level, String msg, Throwable t) {
        Log log = LogFactory.getLog((String)packageName);
        OFXLogger.logInternal(log, level, msg, t);
    }

    public static void log(Class packageClass, IOFXCoreReporter.LogPriority level, String msg, Throwable t) {
        Log log = LogFactory.getLog((Class)packageClass);
        OFXLogger.logInternal(log, level, msg, t);
    }

    public static void logConsole(String str) {
        System.err.println(str);
    }

    private static String stackTrace2String(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String convertToString(CoreReporterInfo cri) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%20s: %45s %55s %7s ", new Object[]{cri.getMsgType(), MoVersion.getCapitalizedShortNameFromFQ(cri.getCmdFqName()), MoVersion.getCapitalizedShortNameFromFQ(cri.getSource()), cri.getPrio()}));
        sb.append(cri.getDescription() + " ");
        if (cri.getParameters().containsKey("param")) {
            sb.append(cri.getParameters().get("param") + " ");
            cri.getParameters().remove("param");
        }
        Set<String> allKeys = cri.getParameters().keySet();
        for (String key : allKeys) {
            sb.append(" " + key + ": " + cri.getParameters().get(key));
        }
        if (cri.getException() != null) {
            sb.append(OFXConsoleHelper.stackTrace2String(cri.getException()));
        }
        return sb.toString();
    }

    public static String simpleInfo(Json json) {
        Object msg = "";
        if (json.has("Source")) {
            msg = (String)msg + json.at("Source").asString() + " / ";
        }
        if (json.has("UserName")) {
            msg = (String)msg + json.at("UserName").asString() + " / ";
        }
        if (json.has("CmdFqName")) {
            msg = (String)msg + json.at("CmdFqName").asString() + " / ";
        }
        if (json.has("Description")) {
            msg = (String)msg + json.at("Description").asString() + " / ";
        }
        return msg;
    }

    public static Json convertToJSON(CoreReporterInfo cri) {
        Json obj = Json.object();
        obj.set("logstamp", (Object)System.currentTimeMillis());
        obj.set("MsgType", (Object)("" + cri.getMsgType()));
        obj.set("AppFqName", (Object)cri.getAppFqName());
        obj.set("AppVersion", (Object)cri.getAppVersion());
        obj.set("Source", (Object)cri.getSource());
        obj.set("CmdFqName", (Object)cri.getCmdFqName());
        obj.set("SessionId", (Object)cri.getSessionLogId());
        obj.set("Description", (Object)cri.getDescription());
        obj.set("Prio", (Object)("" + cri.getPrio()));
        obj.set("UserId", (Object)cri.getUserId());
        obj.set("UserName", (Object)cri.getUserName());
        obj.set("ActorDevice", (Object)cri.getActorDevice());
        obj.set("ActorDeviceId", (Object)cri.getActorDeviceId());
        obj.set("ActorDeviceConnInfo", (Object)cri.getActorDeviceConnInfo());
        obj.set("MowareVersion", (Object)cri.getMowareVersion());
        obj.set("MowarePlatform", (Object)("" + cri.getMowarePlatform()));
        obj.set("SystemName", (Object)cri.getSystemName());
        Set<String> allKeys = cri.getParameters().keySet();
        Json params = Json.object();
        for (String key : allKeys) {
            Object paramValue = cri.getParameters().get(key);
            try {
                String stParamValue;
                if (paramValue instanceof String && (stParamValue = ((String)paramValue).trim()).startsWith("{")) {
                    paramValue = Json.read((String)stParamValue);
                }
            }
            catch (Throwable t) {
                paramValue = "MoWare convertToJSON: While converting " + paramValue + "\n\nEXCEPTION\n" + OFXConsoleHelper.stackTrace2String(t);
            }
            params.set(key, paramValue);
        }
        obj.set("Params", params);
        if (cri.getException() != null) {
            obj.set("Exception", (Object)OFXConsoleHelper.stackTrace2String(cri.getException()));
        }
        return obj;
    }

    public static void logCoreInfoToJOrConsole(CoreReporterInfo info) {
        if (portJLoggingEnabled) {
            OFXLogger.logInternal(portJLog, info.getPrio(), OFXLogger.convertToJSON(info).toString(), null);
        } else if (batchJoblogOnConsole) {
            System.err.println(OFXLogger.convertToString(info));
        } else {
            OFXLogger.log(info.getSource(), info.getPrio(), OFXLogger.convertToString(info), null);
        }
    }

    private static void logInternal(Log log, IOFXCoreReporter.LogPriority level, String msg, Throwable t) {
        block17: {
            block16: {
                if (t == null) break block16;
                switch (level) {
                    case FATAL: {
                        log.fatal((Object)msg, t);
                        break block17;
                    }
                    case ERROR: {
                        log.error((Object)msg, t);
                        break block17;
                    }
                    case WARN: {
                        log.warn((Object)msg, t);
                        break block17;
                    }
                    case INFO: {
                        log.info((Object)msg, t);
                        break block17;
                    }
                    case DEBUG: {
                        log.debug((Object)msg, t);
                        break block17;
                    }
                    case TRACE: {
                        log.trace((Object)msg, t);
                        break block17;
                    }
                    default: {
                        throw new RuntimeException("This can not happen! Level is " + level);
                    }
                }
            }
            switch (level) {
                case FATAL: {
                    log.fatal((Object)msg);
                    break;
                }
                case ERROR: {
                    log.error((Object)msg);
                    break;
                }
                case WARN: {
                    log.warn((Object)msg);
                    break;
                }
                case INFO: {
                    log.info((Object)msg);
                    break;
                }
                case DEBUG: {
                    log.debug((Object)msg);
                    break;
                }
                case TRACE: {
                    log.trace((Object)msg);
                    break;
                }
                default: {
                    throw new RuntimeException("This can not happen! Level is " + level);
                }
            }
        }
    }

    public static void main(String[] args) {
        Json obj = Json.object();
        obj.set("Source", (Object)"SrcFld");
        obj.set("CmdFqName", (Object)"CmdFld");
        obj.set("Description", (Object)"DscFld");
        obj.set("UserName", (Object)"UsrFld");
        System.err.println("> " + OFXLogger.simpleInfo(obj));
    }
}

