/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import org.modellwerkstatt.objectflow.runtime.IOFXApplicationFactory;
import org.modellwerkstatt.objectflow.runtime.IOFXCmdModule;
import org.modellwerkstatt.objectflow.runtime.IOFXCommand;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;
import org.modellwerkstatt.objectflow.runtime.IOFXSession;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.modellwerkstatt.objectflow.runtime.OFXAbortedException;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.modellwerkstatt.objectflow.runtime.OFXFakePagePane;
import org.modellwerkstatt.objectflow.runtime.OFXJobWorkCanceledException;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.OFXSuccessorCommandConfig;

public class OFXRunCmdContainer {
    protected String surroundingPackage;
    protected OFXRunCmdContainer outer;
    private IOFXUserEnvironment __userEnvironment;
    private IOFXUserServices __userServices;
    private IOFXApplicationFactory __localApplicationFactory;
    private String cmdFqName;
    private Object[] commandParams;
    private boolean successorSituation;
    private IOFXCommand command;
    private IOFXCommand successorCommand;
    private IOFXPageHandler commandPages;
    private IOFXPageHandler successorPages;

    public OFXRunCmdContainer(OFXRunCmdContainer outerContainer) {
        this.outer = outerContainer;
        this.surroundingPackage = this.outer.surroundingPackage;
        this.__localApplicationFactory = this.outer.__localApplicationFactory;
        this.__userEnvironment = this.outer.__userEnvironment;
        this.__userServices = this.outer.__userServices;
    }

    public OFXRunCmdContainer(String aPackage, IOFXApplicationFactory appFactory, IOFXUserEnvironment userEnv, IOFXUserServices userSrv) {
        this.surroundingPackage = aPackage;
        this.__localApplicationFactory = appFactory;
        this.__userEnvironment = userEnv;
        this.__userServices = userSrv;
    }

    public void parameterize(String aCmdFqName, Object[] theParams, boolean needsSuccessor) {
        this.cmdFqName = aCmdFqName;
        this.commandParams = theParams;
        this.successorSituation = needsSuccessor;
    }

    public void setCommandPages(IOFXPageHandler cmdPages) {
        this.commandPages = cmdPages;
    }

    public void setSuccessorPages(IOFXPageHandler cmdPages) {
        this.successorPages = cmdPages;
    }

    public void run() throws Exception {
        IOFXCmdModule module = this.__localApplicationFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(this.cmdFqName));
        IOFXSession session = this.outer != null ? this.outer.command.getCommandSession() : null;
        this.command = module.startCommand(IOFXCmdModule.CmdExecStrategy.SINGLE, this.cmdFqName, this.commandParams, session, this.__userEnvironment, this.__userServices);
        try {
            this.command.initCommand();
            this.commandPages.handlePages(this.command, this.command.getCommandSession());
            if (this.successorSituation) {
                this.handleSuccessor();
            }
            this.reportResidualWarnings(this.__userServices, this.command);
            if (this.outer != null) {
                List<Object> selections = this.command.isTerminatedOk() ? this.command.getTerminateOkSelections() : (this.command.isTerminatedCancel() ? this.command.getTerminateCancelSelections() : null);
                this.outer.childTerminated(true, this.command.isTerminatedOk(), selections);
            }
            if (!this.command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD) && !this.command.isTerminatedOk()) {
                throw new IllegalStateException("GraphOWNER / GraphEDIT Command " + this.command.getCommandFqName() + " still not terminated in final ok, after all pages handled.");
            }
            if (this.command.isCommandType(IOFXCommand.OFXCmdTyp.SEARCH_CMD) && !this.isTerminated(this.command)) {
                throw new IllegalStateException("SEARCH Command " + this.command.getCommandFqName() + " still not terminated ok/cancel/user_cancel, after all pages handled.");
            }
        }
        catch (OFXAbortedException userFlag) {
            List<IOFXProblem> lop = this.command.getCommandSession().getAndclearProblemState();
            this.cancel(lop, null);
            throw new OFXJobWorkCanceledException(this.command.getCommandFqName(), lop);
        }
        catch (OFXJobWorkCanceledException cancelEx) {
            if (this.outer != null) {
                throw new RuntimeException("This can not happen.");
            }
            this.cancel(cancelEx.getSessionProblems(), null);
            throw cancelEx;
        }
        catch (Exception e) {
            this.cancel(null, e);
            throw e;
        }
        finally {
            if (this.successorSituation && this.successorCommand != null && !this.isTerminated(this.successorCommand)) {
                OFXLogger.log(this.surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Framework-error, succesor command " + this.successorCommand + " neither terminated in final ok, cancel nor in exception conclusion.", null);
            }
            if (!this.isTerminated(this.command)) {
                OFXLogger.log(this.surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Framework-error, command " + this.command.getCommandFqName() + " neither terminated in final ok, cancel nor in exception conclusion.", null);
            }
        }
    }

    private void handleSuccessor() throws Exception {
        if (!this.command.isReadyForSuccessor()) {
            throw new IllegalStateException("Command " + this.cmdFqName + " not ready to run successor command, but expected to after pages processed.");
        }
        OFXSuccessorCommandConfig cfg = this.command.getSuccessorCommandConfig();
        IOFXCmdModule successorModule = this.__localApplicationFactory.getModuleByInstanceName(MoVersion.getCmdModuleInstanceName(cfg.getCmdName()));
        this.successorCommand = successorModule.startCommand(IOFXCmdModule.CmdExecStrategy.INNER_NO_NEW_SESSION, cfg.getCmdName(), cfg.getParams(), this.command.getCommandSession(), this.__userEnvironment, this.__userServices);
        this.successorCommand.manageAlsoPredecessor(this.command);
        this.successorCommand.initCommand();
        boolean successorPagesHandled = this.successorPages.handlePages(this.successorCommand, this.successorCommand.getCommandSession());
        if (!successorPagesHandled) {
            throw new IllegalStateException("Successor " + this.successorCommand.getCommandFqName() + " and pages not handled correctly in RunCommand.");
        }
        if (!this.successorCommand.isTerminatedOk()) {
            throw new IllegalStateException("Successor Command " + this.successorCommand.getCommandFqName() + " still not terminated in final ok/cancel, after all pages handled.");
        }
        this.reportResidualWarnings(this.__userServices, this.successorCommand);
    }

    public void childTerminated(boolean child, boolean wasOk, List<Object> selections) throws Exception {
        if (this.successorSituation) {
            if (this.successorCommand == null) {
                throw new IllegalStateException("This can not happen. Successor not initialized yet");
            }
            if (this.isTerminated(this.successorCommand)) {
                throw new IllegalStateException("This can not happen. Successor is terminated.");
            }
            this.successorCommand.handleCmdTermAndClearGeFqName(child, wasOk, selections, new OFXFakePagePane());
        } else {
            this.command.handleCmdTermAndClearGeFqName(child, wasOk, selections, new OFXFakePagePane());
        }
    }

    public void cancel(List<IOFXProblem> lop, Exception unexpetedExOrNull) {
        try {
            if (this.successorSituation && this.successorCommand != null && !this.isTerminated(this.successorCommand)) {
                this.successorCommand.doFinalCancelConclusion(lop, unexpetedExOrNull);
            }
            if (!this.isTerminated(this.command)) {
                this.command.doFinalCancelConclusion(lop, unexpetedExOrNull);
            }
        }
        catch (Exception exInCancelConclusion) {
            OFXLogger.log(this.surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Framework-error, ex in cancel() of " + this.command.getCommandFqName() + " container.", (Throwable)exInCancelConclusion);
        }
        if (this.outer != null) {
            try {
                List<Object> selections = this.command.isTerminatedOk() ? this.command.getTerminateOkSelections() : (this.command.isTerminatedCancel() ? this.command.getTerminateCancelSelections() : null);
                this.outer.childTerminated(true, this.command.isTerminatedOk(), selections);
            }
            catch (OFXAbortedException e) {
                List<IOFXProblem> prblms = this.outer.command.getCommandSession().getCopyOfProblemState();
                String msgs = OFXConsoleHelper.asSimpleString(prblms);
                OFXLogger.log(this.surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Precondition in cmd-term handler of " + this.outer.command.getCommandFqName() + " while canceling " + this.command.getCommandFqName() + ":\n" + msgs, null);
            }
            catch (Throwable t) {
                OFXLogger.log(this.surroundingPackage, IOFXCoreReporter.LogPriority.ERROR, "Exception in cmd-term handler of " + this.outer.command.getCommandFqName() + " while canceling " + this.command.getCommandFqName() + ":\n", t);
            }
        }
    }

    private boolean isTerminated(IOFXCommand cmd) {
        return cmd.isTerminatedOk() || cmd.isTerminatedCancel() || cmd.isUserCancelTerminated();
    }

    private void reportResidualWarnings(IOFXUserServices __userServices, IOFXCommand cmd) {
        String sessId = cmd.getCommandSession().getSessionLoggingId();
        List<IOFXProblem> allProblems = cmd.getCommandSession().getAndclearProblemState();
        for (int i = 0; i < ListSequence.fromList(allProblems).count(); ++i) {
            IOFXProblem prblm = (IOFXProblem)ListSequence.fromList(allProblems).getElement(i);
            if (!prblm.isWarningOnly()) {
                throw new IllegalStateException("This can not happen: '" + prblm.getSimpleUserText() + "' is not a warning.");
            }
            IOFXCoreReporter.LogPriority prio = IOFXCoreReporter.LogPriority.WARN;
            if (prblm.isPrioError()) {
                prio = IOFXCoreReporter.LogPriority.ERROR;
            } else if (prblm.isPrioFatal()) {
                prio = IOFXCoreReporter.LogPriority.FATAL;
            }
            __userServices.logOnCoreReporter(cmd.getCommandFqName(), sessId, "org.modellwerkstatt.Event", prio, prblm.getSimpleUserText(), prblm.getPropMapOrNull());
        }
    }

    public Object getTerminateOkObjectForId(String id) {
        return this.command.getTerminateOkObjectForId(id);
    }

    public static interface IOFXPageHandler {
        public boolean handlePages(IOFXCommand var1, IOFXSession var2) throws Exception;
    }
}

