/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;

public class StaticJmxAccess {
    public static void register(Object objToRegister, String name) {
        String regErrorText = " " + name + " = " + objToRegister.getClass().getSimpleName();
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(objToRegister, new ObjectName(name));
        }
        catch (MalformedObjectNameException e) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "MalformedObjectNameEx during reg. of " + regErrorText, (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "MBeanRegistrationException during reg. of " + regErrorText, (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "NotCompliantMBeanException during reg. of " + regErrorText, (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "InstanceAlreadyExistsException during reg. of " + regErrorText, (Throwable)e);
        }
    }

    public static void unregister(String name) {
        String regErrorText = " " + name + " (no obj class info)";
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(name));
        }
        catch (MalformedObjectNameException e) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "MalformedObjectNameEx during unreg. of " + regErrorText, (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "MBeanRegistrationException during unreg. of " + regErrorText, (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "InstanceNotFoundException during unreg. of " + regErrorText, (Throwable)e);
        }
        catch (NullPointerException ex) {
            OFXLogger.log(StaticJmxAccess.class, IOFXCoreReporter.LogPriority.ERROR, "NPE during unreg. of " + regErrorText, (Throwable)ex);
        }
    }
}

