/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.concurrent.atomic.AtomicInteger;

public class TelemetricsLongSampler {
    private int max;
    private long[] samples;
    private AtomicInteger index;

    public TelemetricsLongSampler(int m) {
        this.max = m;
        this.index = new AtomicInteger(0);
        this.samples = new long[this.max];
        for (int i = 0; i < this.max; ++i) {
            this.samples[i] = 0L;
        }
    }

    public void reset() {
        for (int i = 0; i < this.max; ++i) {
            this.samples[i] = 0L;
        }
        this.index.set(0);
    }

    public int getAndIncrement() {
        int next;
        int current;
        while (!this.index.compareAndSet(current = this.index.get(), next = (current + 1) % this.max)) {
        }
        return current;
    }

    public void addSample(long smpl) {
        this.samples[this.getAndIncrement()] = smpl;
    }

    public long getAverageTotal() {
        long avg = 0L;
        int cnt = 0;
        for (int i = 0; i < this.max; ++i) {
            if (this.samples[i] == 0L) continue;
            avg += this.samples[i];
            ++cnt;
        }
        if (cnt > 0) {
            avg /= (long)cnt;
        }
        return avg;
    }

    public long getAverage(int backward) {
        int diff;
        long avg = 0L;
        int cnt = 0;
        int currentIndex = this.index.get();
        if (currentIndex == 0) {
            currentIndex = this.max;
        }
        if ((diff = currentIndex - backward) < 0) {
            int i;
            for (i = this.max + diff; i < this.max; ++i) {
                if (this.samples[i] == 0L) continue;
                avg += this.samples[i];
                ++cnt;
            }
            for (i = 0; i < currentIndex; ++i) {
                if (this.samples[i] == 0L) continue;
                avg += this.samples[i];
                ++cnt;
            }
        } else {
            for (int i = diff; i < currentIndex; ++i) {
                if (this.samples[i] == 0L) continue;
                avg += this.samples[i];
                ++cnt;
            }
        }
        if (cnt > 0) {
            avg /= (long)cnt;
        }
        return avg;
    }

    public long getMax(int backward) {
        int diff;
        long maxTime = 0L;
        int currentIndex = this.index.get();
        if (currentIndex == 0) {
            currentIndex = this.max;
        }
        if ((diff = currentIndex - backward) < 0) {
            int i;
            for (i = this.max + diff; i < this.max; ++i) {
                if (this.samples[i] == 0L || this.samples[i] <= maxTime) continue;
                maxTime = this.samples[i];
            }
            for (i = 0; i < currentIndex; ++i) {
                if (this.samples[i] == 0L || this.samples[i] <= maxTime) continue;
                maxTime = this.samples[i];
            }
        } else {
            for (int i = diff; i < currentIndex; ++i) {
                if (this.samples[i] == 0L || this.samples[i] <= maxTime) continue;
                maxTime = this.samples[i];
            }
        }
        return maxTime;
    }

    public long getCount(long boundary) {
        boolean boundaryPassed = false;
        int cnt = 0;
        int currentIndex = this.index.get() - 1;
        if (currentIndex == -1) {
            currentIndex = this.max - 1;
        }
        while (cnt < this.max && !boundaryPassed) {
            if (this.samples[currentIndex] > boundary) {
                ++cnt;
            } else {
                boundaryPassed = true;
            }
            if (currentIndex == 0) {
                currentIndex = this.max - 1;
                continue;
            }
            --currentIndex;
        }
        return cnt;
    }

    public static void main(String[] args) {
        TelemetricsLongSampler m = new TelemetricsLongSampler(10000);
        m.addSample(10L);
        System.out.println("" + m.getMax(100));
        System.out.println("" + m.getMax(10));
        System.out.println("" + m.getMax(1000));
    }
}

