/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.runtime;

import java.util.HashMap;
import java.util.Map;
import org.modellwerkstatt.objectflow.runtime.IOFXUserEnvironment;

public class UserEnvironmentInformation
implements IOFXUserEnvironment {
    private int uid = 0;
    private String username = "(no username)";
    private String dynamicStatusInfo = "";
    private int lang = -1;
    private String langAsString = "";
    private boolean appCompactMode = false;
    private Map<Integer, Boolean> cachedRoles = new HashMap<Integer, Boolean>();
    private Map<Integer, Object> cachedIdentities = new HashMap<Integer, Object>();
    private String deviceName = "";
    private String deviceSwName = "";
    private String deviceId = "";
    private long appStartupMillis = 0L;
    private int brandingId = 1;

    public UserEnvironmentInformation() {
    }

    public UserEnvironmentInformation(String user, String id) {
        this();
        this.username = user;
        this.uid = new Integer(id);
    }

    @Override
    public long getAppStartupLocalMillis() {
        return this.appStartupMillis;
    }

    @Override
    public void setAppStartupLocalMillis(long value) {
        this.appStartupMillis = value;
    }

    public void setDevice(String devName, String devSwName, String devId) {
        this.deviceName = devName;
        this.deviceSwName = devSwName;
        this.deviceId = devId;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public String getDeviceSwName() {
        return this.deviceSwName;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public void adjustDeviceId(String newId) {
        this.deviceId = newId;
    }

    public void setLang(String val) {
        if (val == null) {
            throw new RuntimeException("Do not set Language to null");
        }
        if (!val.startsWith("trans_")) {
            throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal lang label: " + val);
        }
        try {
            this.lang = Integer.parseInt(val.substring(6));
            this.langAsString = val;
        }
        catch (Exception e) {
            throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal integer suffix: " + val);
        }
    }

    public int getLangIndex() {
        return this.lang;
    }

    public String getLang() {
        return this.langAsString;
    }

    @Deprecated
    public String getUserName_DEP() {
        return this.username;
    }

    public void setUserId(int u) {
        this.uid = u;
    }

    public int getUserId() {
        return this.uid;
    }

    public String getUserName() {
        return this.username;
    }

    public void setDynamicStatusInfo(String name) {
        this.dynamicStatusInfo = name;
    }

    public String getDynamicStatusInfo() {
        return this.dynamicStatusInfo;
    }

    public void setUserName(String u) {
        this.username = u;
    }

    public void setValue(String id, Boolean val) {
        this.cachedRoles.put(id.hashCode(), val);
    }

    public Boolean getValue(String id) {
        return this.cachedRoles.get(id.hashCode());
    }

    public void setIdentity(String id, Object val) {
        this.cachedIdentities.put(id.hashCode(), val);
    }

    public Object getIdentity(String id) {
        return this.cachedIdentities.get(id.hashCode());
    }

    public void setCompactMode() {
        this.appCompactMode = true;
    }

    public boolean isCompactMode() {
        return this.appCompactMode;
    }

    public void clearCachedValues(boolean includingIdentities) {
        this.cachedRoles = new HashMap<Integer, Boolean>();
        if (includingIdentities) {
            this.cachedIdentities = new HashMap<Integer, Object>();
        }
    }

    public String toString() {
        return this.username + " (" + this.uid + ") " + this.deviceName + " " + this.deviceId;
    }

    @Override
    public int getBrandingId() {
        return this.brandingId;
    }

    @Override
    public void setBrandingId(int id) {
        this.brandingId = id;
    }

    @Override
    public void gcClean() {
        if (this.cachedRoles != null) {
            this.cachedRoles.clear();
            this.cachedRoles = null;
            this.cachedIdentities.clear();
            this.cachedIdentities = null;
        }
    }
}

