/*
 * Decompiled with CFR 0.152.
 */
package org.modellwerkstatt.objectflow.sdservices;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.modellwerkstatt.objectflow.sdservices.CListField;

public class CField {
    public String name;
    public OFXType type;
    public Class typeParameter;
    public Method setter;
    public Method getter;

    public CField(String n, OFXType t, Class tp) {
        this.name = n;
        this.type = t;
        this.typeParameter = tp;
    }

    public String info() {
        return "Field '" + this.name + "'";
    }

    public void init(Class parentClass) {
        try {
            String methodName1 = "get" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
            this.getter = parentClass.getMethod(methodName1, new Class[0]);
            if (this instanceof CListField) {
                String methodName2 = "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
                this.setter = parentClass.getMethod(methodName2, List.class);
            } else {
                String methodName2 = "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
                this.setter = parentClass.getMethod(methodName2, this.typeParameter);
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(this.info(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(this.info(), e);
        }
    }

    public void set(Object root, Object value) {
        try {
            this.setter.invoke(root, value);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(this.info(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.info(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(this.info(), e);
        }
    }

    public Object get(Object root) {
        try {
            return this.getter.invoke(root, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(this.info(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.info(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(this.info(), e);
        }
    }

    public String toString() {
        return this.type + " " + this.typeParameter.getSimpleName() + "." + this.name;
    }

    public String getTypeShortName() {
        return this.typeParameter.getSimpleName();
    }

    public static enum OFXType {
        OFX_INT,
        OFX_BIGDECIMAL,
        OFX_STRING,
        OFX_LOCALDATE,
        OFX_DATETIME,
        OFX_STATUS,
        OFX_KEY_REFERENCE,
        OFX_VALUE_OBJ,
        OFX_LIST,
        OFX_VP_BASE;

    }
}

